/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.testing;

import java.io.File;
import java.io.Reader;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.monitor.logging.DefaultLog;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.testing.ConfigurationException;
import org.apache.maven.plugin.testing.ResolverExpressionEvaluatorStub;
import org.codehaus.plexus.PlexusTestCase;
import org.codehaus.plexus.component.configurator.ComponentConfigurator;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.ReflectionUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;

public abstract class AbstractMojoTestCase
extends PlexusTestCase {
    private ComponentConfigurator configurator;

    protected void setUp() throws Exception {
        super.setUp();
        this.configurator = (ComponentConfigurator)this.getContainer().lookup(ComponentConfigurator.ROLE, "basic");
    }

    protected Mojo lookupMojo(String goal, String pluginPom) throws Exception {
        return this.lookupMojo(goal, new File(pluginPom));
    }

    protected Mojo lookupEmptyMojo(String goal, String pluginPom) throws Exception {
        return this.lookupEmptyMojo(goal, new File(pluginPom));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Mojo lookupMojo(String goal, File pom) throws Exception {
        File pluginPom = new File(AbstractMojoTestCase.getBasedir(), "pom.xml");
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader((File)pluginPom);
            Xpp3Dom pluginPomDom = Xpp3DomBuilder.build((Reader)reader);
            String artifactId = pluginPomDom.getChild("artifactId").getValue();
            String groupId = this.resolveFromRootThenParent(pluginPomDom, "groupId");
            String version = this.resolveFromRootThenParent(pluginPomDom, "version");
            PlexusConfiguration pluginConfiguration = this.extractPluginConfiguration(artifactId, pom);
            Mojo mojo = this.lookupMojo(groupId, artifactId, version, goal, pluginConfiguration);
            return mojo;
        }
        finally {
            IOUtil.close((Reader)reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Mojo lookupEmptyMojo(String goal, File pom) throws Exception {
        File pluginPom = new File(AbstractMojoTestCase.getBasedir(), "pom.xml");
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader((File)pluginPom);
            Xpp3Dom pluginPomDom = Xpp3DomBuilder.build((Reader)reader);
            String artifactId = pluginPomDom.getChild("artifactId").getValue();
            String groupId = this.resolveFromRootThenParent(pluginPomDom, "groupId");
            String version = this.resolveFromRootThenParent(pluginPomDom, "version");
            Mojo mojo = this.lookupMojo(groupId, artifactId, version, goal, null);
            return mojo;
        }
        finally {
            IOUtil.close((Reader)reader);
        }
    }

    protected Mojo lookupMojo(String groupId, String artifactId, String version, String goal, PlexusConfiguration pluginConfiguration) throws Exception {
        this.validateContainerStatus();
        Mojo mojo = (Mojo)this.lookup(Mojo.ROLE, groupId + ":" + artifactId + ":" + version + ":" + goal);
        DefaultLog mojoLogger = new DefaultLog(this.getContainer().getLoggerManager().getLoggerForComponent(Mojo.ROLE));
        mojo.setLog((Log)mojoLogger);
        if (pluginConfiguration != null) {
            ResolverExpressionEvaluatorStub evaluator = new ResolverExpressionEvaluatorStub();
            this.configurator.configureComponent((Object)mojo, pluginConfiguration, (ExpressionEvaluator)evaluator, this.getContainer().getContainerRealm());
        }
        return mojo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PlexusConfiguration extractPluginConfiguration(String artifactId, File pom) throws Exception {
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader((File)pom);
            Xpp3Dom pomDom = Xpp3DomBuilder.build((Reader)reader);
            PlexusConfiguration plexusConfiguration = this.extractPluginConfiguration(artifactId, pomDom);
            return plexusConfiguration;
        }
        finally {
            IOUtil.close((Reader)reader);
        }
    }

    protected PlexusConfiguration extractPluginConfiguration(String artifactId, Xpp3Dom pomDom) throws Exception {
        Xpp3Dom pluginsRootElement;
        Xpp3Dom pluginConfigurationElement = null;
        Xpp3Dom buildElement = pomDom.getChild("build");
        if (buildElement != null && (pluginsRootElement = buildElement.getChild("plugins")) != null) {
            Xpp3Dom[] pluginElements = pluginsRootElement.getChildren();
            for (int i = 0; i < pluginElements.length; ++i) {
                Xpp3Dom pluginElement = pluginElements[i];
                String pluginElementArtifactId = pluginElement.getChild("artifactId").getValue();
                if (!pluginElementArtifactId.equals(artifactId)) continue;
                pluginConfigurationElement = pluginElement.getChild("configuration");
                break;
            }
            if (pluginConfigurationElement == null) {
                throw new ConfigurationException("Cannot find a configuration element for a plugin with an artifactId of " + artifactId + ".");
            }
        }
        if (pluginConfigurationElement == null) {
            throw new ConfigurationException("Cannot find a configuration element for a plugin with an artifactId of " + artifactId + ".");
        }
        return new XmlPlexusConfiguration(pluginConfigurationElement);
    }

    protected Mojo configureMojo(Mojo mojo, String artifactId, File pom) throws Exception {
        this.validateContainerStatus();
        PlexusConfiguration pluginConfiguration = this.extractPluginConfiguration(artifactId, pom);
        ResolverExpressionEvaluatorStub evaluator = new ResolverExpressionEvaluatorStub();
        this.configurator.configureComponent((Object)mojo, pluginConfiguration, (ExpressionEvaluator)evaluator, this.getContainer().getContainerRealm());
        return mojo;
    }

    protected Mojo configureMojo(Mojo mojo, PlexusConfiguration pluginConfiguration) throws Exception {
        this.validateContainerStatus();
        ResolverExpressionEvaluatorStub evaluator = new ResolverExpressionEvaluatorStub();
        this.configurator.configureComponent((Object)mojo, pluginConfiguration, (ExpressionEvaluator)evaluator, this.getContainer().getContainerRealm());
        return mojo;
    }

    protected Object getVariableValueFromObject(Object object, String variable) throws IllegalAccessException {
        Field field = ReflectionUtils.getFieldByNameIncludingSuperclasses((String)variable, object.getClass());
        field.setAccessible(true);
        return field.get(object);
    }

    protected Map getVariablesAndValuesFromObject(Object object) throws IllegalAccessException {
        return this.getVariablesAndValuesFromObject(object.getClass(), object);
    }

    protected Map getVariablesAndValuesFromObject(Class clazz, Object object) throws IllegalAccessException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        AccessibleObject[] fields = clazz.getDeclaredFields();
        AccessibleObject.setAccessible(fields, true);
        for (int i = 0; i < fields.length; ++i) {
            AccessibleObject field = fields[i];
            map.put(((Field)field).getName(), ((Field)field).get(object));
        }
        Class superclass = clazz.getSuperclass();
        if (!Object.class.equals(superclass)) {
            map.putAll(this.getVariablesAndValuesFromObject(superclass, object));
        }
        return map;
    }

    protected void setVariableValueToObject(Object object, String variable, Object value) throws IllegalAccessException {
        Field field = ReflectionUtils.getFieldByNameIncludingSuperclasses((String)variable, object.getClass());
        field.setAccessible(true);
        field.set(object, value);
    }

    private String resolveFromRootThenParent(Xpp3Dom pluginPomDom, String element) throws Exception {
        Xpp3Dom elementDom = pluginPomDom.getChild(element);
        if (elementDom == null) {
            Xpp3Dom pluginParentDom = pluginPomDom.getChild("parent");
            if (pluginParentDom != null) {
                elementDom = pluginParentDom.getChild(element);
                if (elementDom == null) {
                    throw new Exception("unable to determine " + element);
                }
                return elementDom.getValue();
            }
            throw new Exception("unable to determine " + element);
        }
        return elementDom.getValue();
    }

    private void validateContainerStatus() throws Exception {
        if (this.getContainer() != null) {
            return;
        }
        throw new Exception("container is null, make sure super.setUp() is called");
    }
}

