/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.test.jobs;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.livy.Job;
import org.apache.livy.JobContext;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.hive.HiveContext;

public class SQLGetTweets
implements Job<List<String>> {
    private final boolean useHiveContext;

    public SQLGetTweets(boolean useHiveContext) {
        this.useHiveContext = useHiveContext;
    }

    public List<String> call(JobContext jc) throws Exception {
        Row[] result;
        URI input;
        InputStream source = this.getClass().getResourceAsStream("/testweet.json");
        File local = File.createTempFile("tweets", ".json", jc.getLocalTmpDir());
        Files.copy(source, local.toPath(), StandardCopyOption.REPLACE_EXISTING);
        FileSystem fs = FileSystem.get((Configuration)jc.sc().sc().hadoopConfiguration());
        if ("file".equals(fs.getUri().getScheme())) {
            input = local.toURI();
        } else {
            String uuid = UUID.randomUUID().toString();
            Path target = new Path("/tmp/" + uuid + "-tweets.json");
            fs.copyFromLocalFile(new Path(local.toURI()), target);
            input = target.toUri();
        }
        HiveContext sqlctx = this.useHiveContext ? jc.hivectx() : jc.sqlctx();
        sqlctx.jsonFile(input.toString()).registerTempTable("tweets");
        ArrayList<String> tweetList = new ArrayList<String>();
        for (Row r : result = sqlctx.sql("SELECT text, retweetCount FROM tweets ORDER BY retweetCount LIMIT 10").collect()) {
            tweetList.add(r.toString());
        }
        return tweetList;
    }
}

