/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.test.jobs;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.livy.Job;
import org.apache.livy.JobContext;
import org.apache.spark.SparkFiles;
import org.apache.spark.api.java.function.Function;

public class FileReader
implements Job<String> {
    private final boolean isResource;
    private final String fileName;

    public FileReader(String fileName, boolean isResource) {
        this.fileName = fileName;
        this.isResource = isResource;
    }

    public String call(JobContext jc) {
        return (String)jc.sc().parallelize(Arrays.asList(1)).map((Function)new Reader()).collect().get(0);
    }

    private class Reader
    implements Function<Integer, String> {
        private Reader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String call(Integer i) throws Exception {
            InputStream in;
            if (FileReader.this.isResource) {
                ClassLoader ccl = Thread.currentThread().getContextClassLoader();
                in = ccl.getResourceAsStream(FileReader.this.fileName);
                if (in == null) {
                    throw new IOException("Resource not found: " + FileReader.this.fileName);
                }
            } else {
                in = new FileInputStream(SparkFiles.get((String)FileReader.this.fileName));
            }
            try {
                int read;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buf = new byte[1024];
                while ((read = in.read(buf)) >= 0) {
                    out.write(buf, 0, read);
                }
                byte[] bytes = out.toByteArray();
                String string = new String(bytes, 0, bytes.length, StandardCharsets.UTF_8);
                return string;
            }
            finally {
                in.close();
            }
        }
    }
}

