/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages.entity;

import java.util.List;
import org.apache.isis.applib.NonRecoverableException;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.version.ConcurrencyException;
import org.apache.isis.core.metamodel.consent.InteractionInvocationMethod;
import org.apache.isis.core.metamodel.consent.InteractionResult;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.interactions.InteractionUtils;
import org.apache.isis.core.metamodel.interactions.ObjectVisibilityContext;
import org.apache.isis.core.metamodel.interactions.VisibilityContext;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.runtime.system.DeploymentType;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.model.common.PageParametersUtils;
import org.apache.isis.viewer.wicket.model.hints.IsisUiHintEvent;
import org.apache.isis.viewer.wicket.model.hints.UiHintContainer;
import org.apache.isis.viewer.wicket.model.models.BookmarkableModel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.components.widgets.breadcrumbs.BreadcrumbModel;
import org.apache.isis.viewer.wicket.ui.components.widgets.breadcrumbs.BreadcrumbModelProvider;
import org.apache.isis.viewer.wicket.ui.pages.PageAbstract;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.string.Strings;

@AuthorizeInstantiation(value={"org.apache.isis.viewer.wicket.roles.USER"})
public class EntityPage
extends PageAbstract {
    private static final long serialVersionUID = 1L;
    private final EntityModel model;

    public EntityPage(PageParameters pageParameters) {
        this(pageParameters, EntityPage.createEntityModel(pageParameters));
    }

    private static EntityModel createEntityModel(PageParameters parameters) {
        String oid = EntityModel.oidStr((PageParameters)parameters);
        if (Strings.isEmpty((CharSequence)oid)) {
            throw new RestartResponseException(Application.get().getHomePage());
        }
        return new EntityModel(parameters);
    }

    private EntityPage(PageParameters pageParameters, EntityModel entityModel) {
        this(pageParameters, entityModel, null);
    }

    public EntityPage(ObjectAdapter adapter) {
        this(adapter, null);
    }

    public EntityPage(ObjectAdapter adapter, ConcurrencyException exIfAny) {
        this(PageParametersUtils.newPageParameters(), EntityPage.newEntityModel(adapter, exIfAny));
    }

    private static EntityModel newEntityModel(ObjectAdapter adapter, ConcurrencyException exIfAny) {
        EntityModel model = new EntityModel(adapter);
        model.setException(exIfAny);
        return model;
    }

    private EntityPage(PageParameters pageParameters, final EntityModel entityModel, String titleString) {
        super(pageParameters, titleString, ComponentType.ENTITY);
        ObjectAdapter objectAdapter;
        this.model = entityModel;
        try {
            objectAdapter = (ObjectAdapter)entityModel.getObject();
        }
        catch (RuntimeException ex) {
            this.removeAnyBookmark(this.model);
            this.removeAnyBreadcrumb(this.model);
            throw new ObjectMember.AuthorizationException(ex);
        }
        if (!this.isVisible(objectAdapter)) {
            throw new ObjectMember.AuthorizationException();
        }
        AuthenticationSession session = this.getAuthenticationSession();
        ObjectSpecification specification = objectAdapter.getSpecification();
        List visibleAssociation = specification.getAssociations(Contributed.INCLUDED, ObjectAssociation.Filters.dynamicallyVisible((AuthenticationSession)session, (ObjectAdapter)objectAdapter, (Where)Where.NOWHERE));
        if (visibleAssociation.isEmpty()) {
            List anyAssociations = specification.getAssociations(Contributed.INCLUDED);
            if (anyAssociations.isEmpty()) {
                throw new NonRecoverableException(String.format("No properties are defined for this entity type (%s); this is probably a programming error", specification.getFullIdentifier()));
            }
            throw new ObjectMember.AuthorizationException();
        }
        if (!this.getDeploymentType().isProduction()) {
            this.getSpecificationLoader().invalidateCacheFor(objectAdapter.getObject());
        }
        if (titleString == null) {
            String titleStr = objectAdapter.titleString(null);
            this.setTitle(titleStr);
        }
        WebMarkupContainer entityPageContainer = new WebMarkupContainer("entityPageContainer");
        entityPageContainer.add(new Behavior[]{new CssClassAppender((IModel<String>)new AbstractReadOnlyModel<String>(){

            public String getObject() {
                ObjectAdapter adapter = (ObjectAdapter)entityModel.getObject();
                return adapter.getObject().getClass().getSimpleName();
            }
        })});
        this.themeDiv.addOrReplace(new Component[]{entityPageContainer});
        this.addChildComponents((MarkupContainer)entityPageContainer, (IModel<?>)this.model);
        this.bookmarkPage((BookmarkableModel<?>)this.model);
        this.addBreadcrumb(entityModel);
        this.addBookmarkedPages((MarkupContainer)entityPageContainer);
        this.send((IEventSink)this, Broadcast.BREADTH, new IsisUiHintEvent((UiHintContainer)entityModel, null));
    }

    private boolean isVisible(ObjectAdapter input) {
        InteractionResult visibleResult = InteractionUtils.isVisibleResult((FacetHolder)input.getSpecification(), this.createVisibleInteractionContext(input));
        return visibleResult.isNotVetoing();
    }

    private VisibilityContext<?> createVisibleInteractionContext(ObjectAdapter objectAdapter) {
        return new ObjectVisibilityContext(this.getDeploymentCategory(), this.getAuthenticationSession(), InteractionInvocationMethod.BY_USER, objectAdapter, objectAdapter.getSpecification().getIdentifier(), Where.OBJECT_FORMS);
    }

    private void addBreadcrumb(EntityModel entityModel) {
        BreadcrumbModelProvider session = (BreadcrumbModelProvider)this.getSession();
        BreadcrumbModel breadcrumbModel = session.getBreadcrumbModel();
        breadcrumbModel.visited(entityModel);
    }

    private void removeAnyBreadcrumb(EntityModel entityModel) {
        BreadcrumbModelProvider session = (BreadcrumbModelProvider)this.getSession();
        BreadcrumbModel breadcrumbModel = session.getBreadcrumbModel();
        breadcrumbModel.remove(entityModel);
    }

    protected void onBeforeRender() {
        this.model.load(AdapterManager.ConcurrencyChecking.NO_CHECK);
        super.onBeforeRender();
    }

    private DeploymentType getDeploymentType() {
        return IsisContext.getDeploymentType();
    }

    protected DeploymentCategory getDeploymentCategory() {
        return this.getDeploymentType().getDeploymentCategory();
    }
}

