/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages.accmngt.password_reset;

import de.agilecoders.wicket.core.markup.html.bootstrap.common.INotificationMessage;
import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationMessage;
import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.apache.isis.applib.services.userreg.UserRegistrationService;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.model.models.PageType;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.isis.viewer.wicket.ui.pages.accmngt.AccountConfirmationMap;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.StatelessForm;
import org.apache.wicket.markup.html.form.validation.EqualPasswordInputValidator;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;

public class PasswordResetPanel
extends Panel {
    @Inject
    private PageClassRegistry pageClassRegistry;

    public PasswordResetPanel(String id, final String uuid) {
        super(id);
        StatelessForm form = new StatelessForm("passwordResetForm");
        this.addOrReplace(new Component[]{form});
        PasswordTextField passwordField = new PasswordTextField("password", (IModel)Model.of((Serializable)((Object)"")));
        passwordField.setLabel((IModel)new ResourceModel("passwordLabel"));
        form.add(new Component[]{passwordField});
        final PasswordTextField confirmPasswordField = new PasswordTextField("confirmPassword", (IModel)Model.of((Serializable)((Object)"")));
        confirmPasswordField.setLabel((IModel)new ResourceModel("confirmPasswordLabel"));
        form.add(new Component[]{confirmPasswordField});
        form.add((IFormValidator)new EqualPasswordInputValidator((FormComponent)passwordField, (FormComponent)confirmPasswordField));
        Button signUpButton = new Button("passwordResetSubmit"){

            public void onSubmit() {
                super.onSubmit();
                final String password = (String)confirmPasswordField.getModelObject();
                final AccountConfirmationMap accountConfirmationMap = (AccountConfirmationMap)((Object)this.getApplication().getMetaData(AccountConfirmationMap.KEY));
                Boolean passwordUpdated = (Boolean)IsisContext.doInSession((Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        String email = accountConfirmationMap.get(uuid);
                        UserRegistrationService userRegistrationService = (UserRegistrationService)IsisContext.getPersistenceSession().getServicesInjector().lookupService(UserRegistrationService.class);
                        return userRegistrationService.updatePasswordByEmail(email, password);
                    }
                });
                if (passwordUpdated.booleanValue()) {
                    accountConfirmationMap.remove(uuid);
                    this.success((Serializable)PasswordResetPanel.this.createPasswordChangeSuccessfulMessage());
                } else {
                    this.error((Serializable)((Object)this.getString("passwordChangeUnsuccessful")));
                }
            }
        };
        form.add(new Component[]{signUpButton});
    }

    private INotificationMessage createPasswordChangeSuccessfulMessage() {
        Class<? extends Page> signInPage = this.pageClassRegistry.getPageClass(PageType.SIGN_IN);
        CharSequence signInUrl = this.urlFor(signInPage, null);
        HashMap<String, CharSequence> map = new HashMap<String, CharSequence>();
        map.put("signInUrl", signInUrl);
        String passwordChangeSuccessful = this.getString("passwordChangeSuccessful", Model.ofMap(map));
        NotificationMessage message = new NotificationMessage((IModel)Model.of((Serializable)((Object)passwordChangeSuccessful)));
        message.escapeModelStrings(false);
        return message;
    }
}

