/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages.accmngt;

import java.util.Map;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.util.collections.MostRecentlyUsedMap;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.util.time.Time;
import org.apache.wicket.util.value.LongValue;

public class AccountConfirmationMap
extends MostRecentlyUsedMap<String, Object> {
    private static final long serialVersionUID = 1L;
    public static final MetaDataKey<AccountConfirmationMap> KEY = new MetaDataKey<AccountConfirmationMap>(){};
    private final Duration lifetime;

    public AccountConfirmationMap(int maxEntries, Duration lifetime) {
        super(maxEntries);
        this.lifetime = lifetime;
    }

    protected synchronized boolean removeEldestEntry(Map.Entry<String, Object> eldest) {
        Duration elapsedTime;
        Value value;
        boolean removed = super.removeEldestEntry(eldest);
        if (!removed && (value = (Value)eldest.getValue()) != null && this.lifetime.lessThanOrEqual((LongValue)(elapsedTime = Time.now().subtract(value.creationTime)))) {
            this.removedValue = value.email;
            removed = true;
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String put(String key, Object email) {
        Value oldValue;
        if (!(email instanceof String)) {
            throw new IllegalArgumentException(AccountConfirmationMap.class.getSimpleName() + " can store only instances of " + String.class.getSimpleName() + ": " + email);
        }
        Value value = new Value();
        value.creationTime = Time.now();
        value.email = (String)email;
        AccountConfirmationMap accountConfirmationMap = this;
        synchronized (accountConfirmationMap) {
            oldValue = (Value)super.put((Object)key, (Object)value);
        }
        return oldValue != null ? oldValue.email : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(Object key) {
        Value value;
        String result = null;
        AccountConfirmationMap accountConfirmationMap = this;
        synchronized (accountConfirmationMap) {
            value = (Value)super.get(key);
        }
        if (value != null) {
            Duration elapsedTime = Time.now().subtract(value.creationTime);
            if (this.lifetime.greaterThan((LongValue)elapsedTime)) {
                result = value.email;
            } else {
                this.remove(key);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String remove(Object key) {
        Value removedValue;
        AccountConfirmationMap accountConfirmationMap = this;
        synchronized (accountConfirmationMap) {
            removedValue = (Value)super.remove(key);
        }
        return removedValue != null ? removedValue.email : null;
    }

    public void putAll(Map<? extends String, ?> m) {
        throw new UnsupportedOperationException();
    }

    private static class Value {
        private String email;
        private Time creationTime;

        private Value() {
        }
    }
}

