/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.errors;

import org.apache.isis.core.commons.authentication.MessageBroker;
import org.apache.wicket.util.string.Strings;

public class JGrowlUtil {
    private JGrowlUtil() {
    }

    public static String asJGrowlCalls(MessageBroker messageBroker) {
        StringBuilder buf = new StringBuilder();
        for (String info : messageBroker.getMessages()) {
            JGrowlUtil.addJGrowlCall(info, "info", false, buf);
        }
        for (String warning : messageBroker.getWarnings()) {
            JGrowlUtil.addJGrowlCall(warning, "warning", true, buf);
        }
        String error = messageBroker.getApplicationError();
        if (error != null) {
            JGrowlUtil.addJGrowlCall(error, "danger", true, buf);
        }
        return buf.toString();
    }

    private static void addJGrowlCall(String origMsg, String cssClassSuffix, boolean sticky, StringBuilder buf) {
        String escapedMsg = JGrowlUtil.escape(origMsg);
        buf.append("$.growl(\"").append((CharSequence)escapedMsg).append("&#160;&#160;&#160;").append('\"');
        buf.append(", {");
        buf.append("type: \"").append(cssClassSuffix).append('\"');
        buf.append(", delay: " + (sticky ? "0" : "2000"));
        buf.append(", placement: { from: 'top', align: 'right' }");
        buf.append(", offset: 50");
        buf.append('}');
        buf.append(");\n");
    }

    static String escape(String origMsg) {
        String escaped = Strings.escapeMarkup((CharSequence)origMsg).toString();
        return escaped.replace("&quot;", "'").replace("&#039;", "'");
    }
}

