/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.entitysimplelink;

import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.components.widgets.formcomponent.CancelHintRequired;
import org.apache.isis.viewer.wicket.ui.components.widgets.formcomponent.FormComponentPanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;

public class EntityLinkSimplePanel
extends FormComponentPanelAbstract<ObjectAdapter>
implements CancelHintRequired {
    private static final long serialVersionUID = 1L;
    private static final String ID_ENTITY_ICON_AND_TITLE = "entityIconAndTitle";
    private static final String ID_ENTITY_TITLE_NULL = "entityTitleNull";

    public EntityLinkSimplePanel(String id, EntityModel entityModel) {
        super(id, entityModel);
        this.setType(ObjectAdapter.class);
        this.buildGui();
    }

    public EntityModel getEntityModel() {
        return (EntityModel)this.getModel();
    }

    private void buildGui() {
        this.syncWithInput();
    }

    protected void onBeforeRender() {
        this.syncWithInput();
        super.onBeforeRender();
    }

    private void syncWithInput() {
        ObjectAdapter adapter = this.getPendingElseCurrentAdapter();
        if (adapter != null) {
            EntityModel entityModelForLink = new EntityModel(adapter);
            entityModelForLink.setContextAdapterIfAny(this.getEntityModel().getContextAdapterIfAny());
            entityModelForLink.setRenderingHint(this.getEntityModel().getRenderingHint());
            ComponentFactory componentFactory = this.getComponentFactoryRegistry().findComponentFactory(ComponentType.ENTITY_ICON_AND_TITLE, (IModel<?>)entityModelForLink);
            Component component = componentFactory.createComponent((IModel<?>)entityModelForLink);
            this.addOrReplace(new Component[]{component});
            this.permanentlyHide(ID_ENTITY_TITLE_NULL);
        } else {
            this.addOrReplace(new Component[]{new Label(ID_ENTITY_TITLE_NULL, "(none)")});
            this.permanentlyHide(ID_ENTITY_ICON_AND_TITLE);
        }
    }

    @Override
    public void onCancel() {
    }

    public void validate() {
    }

    private ObjectAdapter getPendingElseCurrentAdapter() {
        return this.getEntityModel().getPendingElseCurrentAdapter();
    }
}

