/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.unknown;

import java.io.Serializable;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class UnknownModelPanel
extends PanelAbstract<IModel<?>> {
    private static final long serialVersionUID = 1L;

    public UnknownModelPanel(String id, IModel<?> model) {
        super(id, model);
        this.buildGui(id);
    }

    private void buildGui(String id) {
        this.addOrReplace(new Component[]{new Label("unknown", (IModel)Model.of((Serializable)((Object)this.buildMessage())))});
    }

    private String buildMessage() {
        StringBuilder buf = new StringBuilder();
        buf.append("??? ");
        if (this.getModel() != null) {
            this.buildMessageForModel(buf, (IModel<?>)this.getModel());
        } else {
            buf.append("model is NULL");
        }
        return buf.toString();
    }

    private void buildMessageForModel(StringBuilder buf, IModel<?> model) {
        buf.append(model.getClass().getSimpleName()).append(" ");
        if (model instanceof EntityModel) {
            EntityModel entityModel = (EntityModel)model;
            ObjectAdapter objectAdapter = (ObjectAdapter)entityModel.getObject();
            if (objectAdapter != null) {
                buf.append("objectAdapter oid: " + objectAdapter.getOid());
            } else {
                buf.append("objectAdapter is NULL");
            }
        }
    }
}

