/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.jodatime;

import java.util.Locale;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.ui.components.scalars.jodatime.DateConverterForJodaAbstract;
import org.apache.wicket.util.convert.ConversionException;
import org.joda.time.LocalDate;

public class DateConverterForJodaLocalDate
extends DateConverterForJodaAbstract<LocalDate> {
    private static final long serialVersionUID = 1L;

    public DateConverterForJodaLocalDate(WicketViewerSettings settings, int adjustBy) {
        this(settings.getDatePattern(), settings.getDatePattern(), adjustBy);
    }

    private DateConverterForJodaLocalDate(String datePattern, String datePickerPattern, int adjustBy) {
        super(LocalDate.class, datePattern, datePattern, datePickerPattern, adjustBy);
    }

    @Override
    protected LocalDate doConvertToObject(String value, Locale locale) throws ConversionException {
        LocalDate date = this.convert(value);
        LocalDate adjustedDate = date.minusDays(this.adjustBy);
        return adjustedDate;
    }

    private LocalDate convert(String value) throws ConversionException {
        try {
            LocalDate date = this.getFormatterForDatePattern().parseLocalDate(value);
            return date;
        }
        catch (IllegalArgumentException ex) {
            throw new ConversionException("Cannot convert into a date", (Throwable)ex);
        }
    }

    @Override
    protected String doConvertToString(LocalDate value, Locale locale) {
        return value.plusDays(this.adjustBy).toString(this.getFormatterForDatePattern());
    }
}

