/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.jdkmath;

import java.math.BigDecimal;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.scalars.ComponentFactoryScalarAbstract;
import org.apache.isis.viewer.wicket.ui.components.scalars.jdkmath.BigDecimalConverterWithScale;
import org.apache.isis.viewer.wicket.ui.components.scalars.jdkmath.JavaMathBigDecimalPanel;
import org.apache.wicket.Component;

public class JavaMathBigDecimalPanelFactory
extends ComponentFactoryScalarAbstract {
    private static final long serialVersionUID = 1L;
    private final BigDecimalConverterWithScale converterForNullScale = new BigDecimalConverterWithScale(null);
    private final Map<Integer, BigDecimalConverterWithScale> converterByScale = new ConcurrentHashMap<Integer, BigDecimalConverterWithScale>();

    public JavaMathBigDecimalPanelFactory() {
        super(JavaMathBigDecimalPanel.class, BigDecimal.class);
    }

    @Override
    public Component createComponent(String id, ScalarModel scalarModel) {
        BigDecimalConverterWithScale converter = this.getConverter(scalarModel);
        return new JavaMathBigDecimalPanel(id, scalarModel, converter);
    }

    private BigDecimalConverterWithScale getConverter(ScalarModel scalarModel) {
        Integer scale = scalarModel.getScale();
        if (scale == null) {
            return this.converterForNullScale;
        }
        BigDecimalConverterWithScale bigDecimalConverter = this.converterByScale.get(scale);
        if (bigDecimalConverter == null) {
            bigDecimalConverter = new BigDecimalConverterWithScale(scale);
            this.converterByScale.put(scale, bigDecimalConverter);
        }
        return bigDecimalConverter;
    }
}

