/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.jdkdates;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.ui.components.scalars.jdkdates.DateConverterForJavaAbstract;
import org.apache.wicket.util.convert.ConversionException;

public class DateConverterForJavaSqlDate
extends DateConverterForJavaAbstract<java.sql.Date> {
    private static final long serialVersionUID = 1L;

    public DateConverterForJavaSqlDate(WicketViewerSettings settings, int adjustBy) {
        this(settings.getDatePattern(), settings.getDatePattern(), adjustBy);
    }

    private DateConverterForJavaSqlDate(String datePattern, String datePickerPattern, int adjustBy) {
        super(java.sql.Date.class, datePattern, datePattern, datePickerPattern, adjustBy);
    }

    @Override
    protected java.sql.Date doConvertToObject(String value, Locale locale) throws ConversionException {
        Date date = this.convert(value);
        Date adjustedDate = DateConverterForJavaSqlDate.addDays(date, 0 - this.adjustBy);
        return new java.sql.Date(adjustedDate.getTime());
    }

    private Date convert(String value) {
        try {
            return this.newSimpleDateFormatUsingDatePattern().parse(value);
        }
        catch (ParseException e) {
            throw new ConversionException("Cannot convert into a date", (Throwable)e);
        }
    }

    @Override
    protected String doConvertToString(java.sql.Date value, Locale locale) {
        return this.newSimpleDateFormatUsingDatePattern().format(DateConverterForJavaSqlDate.addDays(value, this.adjustBy));
    }

    private static Date addDays(Date value, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(value);
        cal.add(5, days);
        Date adjusted = cal.getTime();
        return adjusted;
    }
}

