/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.isisapplib;

import java.util.List;
import org.apache.isis.applib.value.Blob;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.scalars.isisapplib.IsisBlobOrClobPanelAbstract;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.request.resource.ByteArrayResource;
import org.apache.wicket.request.resource.IResource;

public class IsisBlobPanel
extends IsisBlobOrClobPanelAbstract<Blob> {
    private static final long serialVersionUID = 1L;

    public IsisBlobPanel(String id, ScalarModel model) {
        super(id, model);
    }

    @Override
    protected Blob getBlobOrClobFrom(List<FileUpload> fileUploads) {
        FileUpload fileUpload = fileUploads.get(0);
        String contentType = fileUpload.getContentType();
        String clientFileName = fileUpload.getClientFileName();
        byte[] bytes = fileUpload.getBytes();
        Blob blob = new Blob(clientFileName, contentType, bytes);
        return blob;
    }

    @Override
    protected IResource newResource(Blob blob) {
        return new ByteArrayResource(blob.getMimeType().getBaseType(), blob.getBytes(), blob.getName());
    }
}

