/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.image;

import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import java.awt.Graphics2D;
import java.awt.Image;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facets.value.image.ImageValueFacet;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.feedback.ComponentFeedbackMessageFilter;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.resource.RenderedDynamicImageResource;
import org.apache.wicket.request.resource.IResource;

public class JavaAwtImagePanel
extends PanelAbstract<ScalarModel> {
    private static final long serialVersionUID = 1L;
    private static final String ID_SCALAR_NAME = "scalarName";
    private static final String ID_SCALAR_VALUE = "scalarValue";
    private static final String ID_FEEDBACK = "feedback";

    public JavaAwtImagePanel(String id, ScalarModel scalarModel) {
        super(id, scalarModel);
        this.buildGui();
    }

    private void buildGui() {
        String name = ((ScalarModel)this.getModel()).getName();
        Label scalarName = new Label(ID_SCALAR_NAME, name);
        this.addOrReplace(new Component[]{scalarName});
        ImageValueFacet imageValueFacet = (ImageValueFacet)((ScalarModel)this.getModel()).getTypeOfSpecification().getFacet(ImageValueFacet.class);
        ObjectAdapter adapter = (ObjectAdapter)((ScalarModel)this.getModel()).getObject();
        if (adapter != null) {
            final Image imageValue = imageValueFacet.getImage(adapter);
            RenderedDynamicImageResource imageResource = new RenderedDynamicImageResource(imageValue.getWidth(null), imageValue.getHeight(null)){
                private static final long serialVersionUID = 1L;

                protected boolean render(Graphics2D graphics, IResource.Attributes attributes) {
                    graphics.drawImage(imageValue, 0, 0, null);
                    return true;
                }
            };
            org.apache.wicket.markup.html.image.Image image = new org.apache.wicket.markup.html.image.Image(ID_SCALAR_VALUE, (IResource)imageResource);
            this.addOrReplace(new Component[]{image});
            this.addOrReplace(new Component[]{new NotificationPanel(ID_FEEDBACK, (Component)image, (IFeedbackMessageFilter)new ComponentFeedbackMessageFilter((Component)image))});
        } else {
            this.permanentlyHide(ID_SCALAR_VALUE, ID_FEEDBACK);
        }
    }
}

