/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.datepicker;

import de.agilecoders.wicket.core.util.Attributes;
import de.agilecoders.wicket.jquery.Config;
import de.agilecoders.wicket.jquery.JQuery;
import java.util.Locale;
import org.apache.isis.viewer.wicket.ui.components.scalars.DateConverter;
import org.apache.isis.viewer.wicket.ui.components.scalars.datepicker.DateTimeConfig;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.convert.IConverter;

public class TextFieldWithDatePicker<T>
extends TextField<T>
implements IConverter<T> {
    private static final long serialVersionUID = 1L;
    protected final DateConverter<T> converter;
    private final DateTimeConfig config;

    public TextFieldWithDatePicker(String id, IModel<T> model, Class<T> type, DateConverter<T> converter) {
        this(id, model, type, converter, new DateTimeConfig());
    }

    public TextFieldWithDatePicker(String id, IModel<T> model, Class<T> type, DateConverter<T> converter, DateTimeConfig config) {
        super(id, model, type);
        this.setOutputMarkupId(true);
        this.converter = converter;
        String datePickerPattern = this.getPattern(converter, this.getLocale());
        datePickerPattern = datePickerPattern.replace('d', 'D');
        datePickerPattern = datePickerPattern.replace('y', 'Y');
        config.withFormat(datePickerPattern);
        config.calendarWeeks(true);
        if (datePickerPattern.contains("HH")) {
            config.sideBySide(true);
        }
        this.config = config;
    }

    protected String getPattern(DateConverter<T> converter, Locale locale) {
        return converter.getDatePickerPattern(locale);
    }

    public T convertToObject(String value, Locale locale) {
        return (T)this.converter.convertToObject(value, locale);
    }

    public String convertToString(T value, Locale locale) {
        return this.converter.convertToString(value, locale);
    }

    public <C> IConverter<C> getConverter(Class<C> type) {
        if (this.converter.getConvertableClass().isAssignableFrom(type)) {
            return this;
        }
        return super.getConverter(type);
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        this.checkComponentTag(tag, "input");
        Attributes.set((ComponentTag)tag, (String)"type", (String)"text");
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)new CssResourceReference(TextFieldWithDatePicker.class, "css/bootstrap-datetimepicker.css")));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(TextFieldWithDatePicker.class, "js/moment.js")));
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(TextFieldWithDatePicker.class, "js/bootstrap-datetimepicker.js")));
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)this.createScript(this.config)));
    }

    private CharSequence createScript(DateTimeConfig config) {
        return JQuery.$((Component)this).chain((CharSequence)"datetimepicker", (Config)config, new Config[0]).get();
    }
}

