/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.datepicker;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.agilecoders.wicket.jquery.AbstractConfig;
import de.agilecoders.wicket.jquery.IKey;
import java.io.IOException;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateTimeConfig
extends AbstractConfig {
    private static final IKey<String> StartDate = DateTimeConfig.newKey((String)"startDate", null);
    private static final IKey<String> EndDate = DateTimeConfig.newKey((String)"endDate", null);
    private static final IKey<String> _ViewMode = DateTimeConfig.newKey((String)"viewMode", (Object)ViewMode.days.name());
    private static final IKey<TodayButton> ShowTodayButton = DateTimeConfig.newKey((String)"todayBtn", (Object)((Object)TodayButton.FALSE));
    private static final IKey<Boolean> KeyboardNavigation = DateTimeConfig.newKey((String)"keyboardNavigation", (Object)true);
    private static final IKey<Boolean> SideBySide = DateTimeConfig.newKey((String)"sideBySide", (Object)false);
    private static final IKey<String> Language = DateTimeConfig.newKey((String)"language", (Object)"en");
    private static final IKey<String> Format = DateTimeConfig.newKey((String)"format", null);
    private static final IKey<Integer> WeekStart = DateTimeConfig.newKey((String)"weekStart", (Object)0);
    private static final IKey<Boolean> HighlightToday = DateTimeConfig.newKey((String)"todayHighlight", (Object)false);
    private static final IKey<Boolean> AutoClose = DateTimeConfig.newKey((String)"autoclose", (Object)false);
    private static final IKey<Boolean> ForceParse = DateTimeConfig.newKey((String)"forceParse", (Object)true);
    private static final IKey<Boolean> ClearButton = DateTimeConfig.newKey((String)"clearBtn", (Object)false);
    private static final IKey<Boolean> CalendarWeeks = DateTimeConfig.newKey((String)"calendarWeeks", (Object)false);

    public String getFormat() {
        return this.getString(Format);
    }

    public String getLanguage() {
        return this.getString(Language);
    }

    public boolean isDefaultLanguageSet() {
        return Language.isDefaultValue((Object)this.getLanguage());
    }

    public DateTimeConfig withStartDate(DateTime value) {
        String startDate;
        String format = this.getFormat();
        if (Strings.isEmpty((CharSequence)format)) {
            startDate = value.toString();
        } else {
            DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)format);
            startDate = dateTimeFormatter.print((ReadableInstant)value);
        }
        this.put(StartDate, startDate);
        return this;
    }

    public DateTimeConfig withEndDate(DateTime value) {
        String endDate;
        Args.notNull((Object)value, (String)"value");
        String format = this.getFormat();
        if (Strings.isEmpty((CharSequence)format)) {
            endDate = value.toString();
        } else {
            DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)format);
            endDate = dateTimeFormatter.print((ReadableInstant)value);
        }
        this.put(EndDate, endDate);
        return this;
    }

    public DateTimeConfig withLanguage(String value) {
        this.put(Language, value);
        return this;
    }

    public DateTimeConfig withView(ViewMode value) {
        this.put(_ViewMode, value.name());
        return this;
    }

    public DateTimeConfig withFormat(String value) {
        this.put(Format, value);
        return this;
    }

    public DateTimeConfig withWeekStart(Day value) {
        this.put(WeekStart, value.ordinal());
        return this;
    }

    public DateTimeConfig allowKeyboardNavigation(boolean value) {
        this.put(KeyboardNavigation, value);
        return this;
    }

    public DateTimeConfig sideBySide(boolean value) {
        this.put(SideBySide, value);
        return this;
    }

    public DateTimeConfig highlightToday(boolean value) {
        this.put(HighlightToday, value);
        return this;
    }

    public DateTimeConfig showTodayButton(TodayButton value) {
        this.put(ShowTodayButton, (Object)value);
        return this;
    }

    public DateTimeConfig forceParse(boolean value) {
        this.put(ForceParse, value);
        return this;
    }

    public DateTimeConfig clearButton(boolean value) {
        this.put(ClearButton, value);
        return this;
    }

    public DateTimeConfig calendarWeeks(boolean value) {
        this.put(CalendarWeeks, value);
        return this;
    }

    public DateTimeConfig autoClose(boolean value) {
        this.put(AutoClose, value);
        return this;
    }

    private static class TodayButtonSerializer
    extends JsonSerializer<TodayButton> {
        private TodayButtonSerializer() {
        }

        public void serialize(TodayButton value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            switch (value) {
                case TRUE: {
                    jgen.writeBoolean(true);
                    break;
                }
                case FALSE: {
                    jgen.writeBoolean(false);
                    break;
                }
                case LINKED: {
                    jgen.writeString("linked");
                }
            }
        }
    }

    @JsonSerialize(using=TodayButtonSerializer.class)
    public static enum TodayButton {
        TRUE,
        FALSE,
        LINKED;

    }

    public static enum ViewMode {
        months,
        years,
        days;

    }

    public static enum Day {
        Sunday,
        Monday,
        Tuesday,
        Wednesday,
        Thursday,
        Friday,
        Saturday;

    }
}

