/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collectioncontents.summary;

import java.io.Serializable;
import java.util.List;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.core.metamodel.facets.value.bigdecimal.BigDecimalValueFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.ui.CollectionContentsAsFactory;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.ComponentFactoryAbstract;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.summary.CollectionContentsAsSummary;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.resource.CssResourceReference;

public class CollectionContentsAsSummaryFactory
extends ComponentFactoryAbstract
implements CollectionContentsAsFactory {
    private static final long serialVersionUID = 1L;
    private static final String NAME = "summary";
    static final Filter<ObjectAssociation> OF_TYPE_BIGDECIMAL = new Filter<ObjectAssociation>(){

        public boolean accept(ObjectAssociation objectAssoc) {
            ObjectSpecification objectSpec = objectAssoc.getSpecification();
            return objectSpec.containsDoOpFacet(BigDecimalValueFacet.class);
        }
    };

    public CollectionContentsAsSummaryFactory() {
        super(ComponentType.COLLECTION_CONTENTS, NAME, CollectionContentsAsSummary.class);
    }

    @Override
    public ComponentFactory.ApplicationAdvice appliesTo(IModel<?> model) {
        if (!(model instanceof EntityCollectionModel)) {
            return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
        }
        EntityCollectionModel entityCollectionModel = (EntityCollectionModel)model;
        ObjectSpecification elementSpec = entityCollectionModel.getTypeOfSpecification();
        List associations = elementSpec.getAssociations(Contributed.EXCLUDED, OF_TYPE_BIGDECIMAL);
        return this.appliesIf(!associations.isEmpty());
    }

    @Override
    public Component createComponent(String id, IModel<?> model) {
        EntityCollectionModel collectionModel = (EntityCollectionModel)model;
        return new CollectionContentsAsSummary(id, collectionModel);
    }

    @Override
    public CssResourceReference getCssResourceReference() {
        return null;
    }

    @Override
    public IModel<String> getTitleLabel() {
        return new ResourceModel("CollectionContentsAsSummaryFactory.Summary", "Summary");
    }

    @Override
    public IModel<String> getCssClass() {
        return Model.of((Serializable)((Object)"fa fa-fw fa-usd"));
    }
}

