/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collectioncontents.icons;

import org.apache.isis.core.metamodel.facets.object.icon.IconFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.ComponentFactoryAbstract;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.icons.CollectionContentsAsIconsPanel;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;

public class CollectionContentsAsIconsPanelFactory
extends ComponentFactoryAbstract {
    private static final long serialVersionUID = 1L;
    private static final String NAME = "icons";

    public CollectionContentsAsIconsPanelFactory() {
        super(ComponentType.COLLECTION_CONTENTS, NAME, CollectionContentsAsIconsPanel.class);
    }

    @Override
    public ComponentFactory.ApplicationAdvice appliesTo(IModel<?> model) {
        if (!(model instanceof EntityCollectionModel)) {
            return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
        }
        EntityCollectionModel entityCollectionModel = (EntityCollectionModel)model;
        ObjectSpecification typeOfSpec = entityCollectionModel.getTypeOfSpecification();
        if (typeOfSpec.getFacet(IconFacet.class) == null) {
            return ComponentFactory.ApplicationAdvice.DOES_NOT_APPLY;
        }
        return ComponentFactory.ApplicationAdvice.APPLIES;
    }

    @Override
    public Component createComponent(String id, IModel<?> model) {
        EntityCollectionModel collectionModel = (EntityCollectionModel)model;
        return new CollectionContentsAsIconsPanel(id, collectionModel);
    }
}

