/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collection.selector;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.applib.annotation.Render;
import org.apache.isis.core.metamodel.facets.members.render.RenderFacet;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.viewer.wicket.model.hints.UiHintContainer;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.app.registry.ComponentFactoryRegistry;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.ajaxtable.CollectionContentsAsAjaxTablePanelFactory;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.multiple.CollectionContentsMultipleViewsPanelFactory;
import org.apache.isis.viewer.wicket.ui.components.collectioncontents.unresolved.CollectionContentsAsUnresolvedPanelFactory;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;

public class CollectionSelectorHelper
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final String UIHINT_EVENT_VIEW_KEY = "view";
    private final EntityCollectionModel model;
    private final List<ComponentFactory> componentFactories;

    public CollectionSelectorHelper(EntityCollectionModel model, ComponentFactoryRegistry componentFactoryRegistry) {
        this.model = model;
        this.componentFactories = this.locateComponentFactories(componentFactoryRegistry);
    }

    private List<ComponentFactory> locateComponentFactories(ComponentFactoryRegistry componentFactoryRegistry) {
        List<ComponentFactory> componentFactories = componentFactoryRegistry.findComponentFactories(ComponentType.COLLECTION_CONTENTS, (IModel<?>)this.model);
        ArrayList otherFactories = Lists.newArrayList((Iterable)Collections2.filter(componentFactories, (Predicate)new Predicate<ComponentFactory>(){

            public boolean apply(ComponentFactory input) {
                return input.getClass() != CollectionContentsMultipleViewsPanelFactory.class;
            }
        }));
        return CollectionSelectorHelper.ordered(otherFactories);
    }

    public List<ComponentFactory> getComponentFactories() {
        return this.componentFactories;
    }

    public int honourViewHintElseDefault(Component component) {
        String viewStr;
        UiHintContainer hintContainer = CollectionSelectorHelper.getUiHintContainer(component);
        if (hintContainer != null && (viewStr = hintContainer.getHint(component, UIHINT_EVENT_VIEW_KEY)) != null) {
            try {
                int view = Integer.parseInt(viewStr);
                if (view >= 0 && view < this.componentFactories.size()) {
                    return view;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int initialFactory = this.determineInitialFactory();
        if (hintContainer != null) {
            hintContainer.setHint(component, UIHINT_EVENT_VIEW_KEY, "" + initialFactory);
        }
        return initialFactory;
    }

    private int determineInitialFactory() {
        int ajaxTableIdx;
        if (!CollectionSelectorHelper.hasRenderEagerlyFacet(this.model)) {
            for (int i = 0; i < this.componentFactories.size(); ++i) {
                if (!(this.componentFactories.get(i) instanceof CollectionContentsAsUnresolvedPanelFactory)) continue;
                return i;
            }
        }
        if ((ajaxTableIdx = CollectionSelectorHelper.findAjaxTable(this.componentFactories)) >= 0) {
            return ajaxTableIdx;
        }
        return 0;
    }

    private static List<ComponentFactory> ordered(List<ComponentFactory> componentFactories) {
        return CollectionSelectorHelper.orderAjaxTableToEnd(componentFactories);
    }

    static List<ComponentFactory> orderAjaxTableToEnd(List<ComponentFactory> componentFactories) {
        int ajaxTableIdx = CollectionSelectorHelper.findAjaxTable(componentFactories);
        if (ajaxTableIdx >= 0) {
            ArrayList orderedFactories = Lists.newArrayList(componentFactories);
            ComponentFactory ajaxTableFactory = (ComponentFactory)orderedFactories.remove(ajaxTableIdx);
            orderedFactories.add(ajaxTableFactory);
            return orderedFactories;
        }
        return componentFactories;
    }

    private static int findAjaxTable(List<ComponentFactory> componentFactories) {
        for (int i = 0; i < componentFactories.size(); ++i) {
            if (!(componentFactories.get(i) instanceof CollectionContentsAsAjaxTablePanelFactory)) continue;
            return i;
        }
        return -1;
    }

    private static UiHintContainer getUiHintContainer(Component component) {
        return UiHintContainer.Util.hintContainerOf((Component)component, EntityModel.class);
    }

    private static boolean hasRenderEagerlyFacet(IModel<?> model) {
        if (!(model instanceof EntityCollectionModel)) {
            return false;
        }
        EntityCollectionModel entityCollectionModel = (EntityCollectionModel)model;
        if (!entityCollectionModel.isParented()) {
            return false;
        }
        OneToManyAssociation collection = entityCollectionModel.getCollectionMemento().getCollection();
        RenderFacet renderFacet = (RenderFacet)collection.getFacet(RenderFacet.class);
        return renderFacet != null && renderFacet.value() == Render.Type.EAGERLY;
    }
}

