/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.collection;

import com.google.common.collect.Lists;
import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.isis.core.runtime.system.DeploymentType;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.EntityActionUtil;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionSelectorPanel;
import org.apache.isis.viewer.wicket.ui.components.collection.selector.CollectionSelectorProvider;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.feedback.ComponentFeedbackMessageFilter;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;

public class CollectionPanel
extends PanelAbstract<EntityCollectionModel>
implements CollectionSelectorProvider {
    private static final long serialVersionUID = 1L;
    private static final String ID_FEEDBACK = "feedback";
    private Component collectionContents;
    private Label label;
    private CollectionSelectorPanel selectorDropdownPanel;

    public CollectionPanel(String id, EntityModel entityModel, OneToManyAssociation otma) {
        this(id, CollectionPanel.newEntityCollectionModel(entityModel, otma), entityModel, otma);
    }

    private static EntityCollectionModel newEntityCollectionModel(EntityModel entityModel, OneToManyAssociation otma) {
        EntityCollectionModel collectionModel = EntityCollectionModel.createParented((EntityModel)entityModel, (OneToManyAssociation)otma);
        return collectionModel;
    }

    CollectionPanel(String id, EntityCollectionModel collectionModel) {
        this(id, collectionModel, new EntityModel(collectionModel.getParentObjectAdapterMemento()), collectionModel.getCollectionMemento().getCollection());
    }

    CollectionPanel(String id, EntityCollectionModel collectionModel, EntityModel entityModel, OneToManyAssociation otma) {
        super(id, collectionModel);
        ArrayList entityActionLinks = Lists.newArrayList();
        List<ObjectAction> associatedActions = EntityActionUtil.getObjectActionsForAssociation(entityModel, (ObjectAssociation)otma, this.getDeploymentType());
        entityActionLinks.addAll(EntityActionUtil.asLinkAndLabelsForAdditionalLinksPanel(entityModel, associatedActions));
        collectionModel.addEntityActions((List)entityActionLinks);
    }

    protected void onInitialize() {
        super.onInitialize();
        this.buildGui();
    }

    private void buildGui() {
        this.collectionContents = this.getComponentFactoryRegistry().addOrReplaceComponent((MarkupContainer)this, ComponentType.COLLECTION_CONTENTS, (IModel<?>)this.getModel());
        this.addOrReplace(new Component[]{new NotificationPanel(ID_FEEDBACK, this.collectionContents, (IFeedbackMessageFilter)new ComponentFeedbackMessageFilter(this.collectionContents))});
    }

    public Label createLabel(String id, String collectionName) {
        this.label = new Label(id, collectionName);
        this.label.setOutputMarkupId(true);
        return this.label;
    }

    @Override
    public CollectionSelectorPanel getSelectorDropdownPanel() {
        return this.selectorDropdownPanel;
    }

    public void setSelectorDropdownPanel(CollectionSelectorPanel selectorDropdownPanel) {
        this.selectorDropdownPanel = selectorDropdownPanel;
    }

    protected DeploymentType getDeploymentType() {
        return IsisContext.getDeploymentType();
    }
}

