/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.about;

import org.apache.isis.viewer.wicket.ui.components.about.JarManifestListView;
import org.apache.isis.viewer.wicket.ui.components.about.JarManifestModel;
import org.apache.isis.viewer.wicket.ui.panels.PanelUtil;
import org.apache.wicket.Component;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptReferenceHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public class JarManifestPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final String ID_ABOUT_MESSAGE = "aboutMessage";
    private static final String ID_MANIFEST_ATTRIBUTES = "manifestAttributes";
    private static final String ID_MANIFEST_ATTRIBUTE = "manifestAttribute";
    private static final String ID_LINE = "manifestAttributeLine";
    private static final JavaScriptResourceReference DIV_TOGGLE_JS = new JavaScriptResourceReference(JarManifestPanel.class, "div-toggle.js");

    public JarManifestPanel(String id, JarManifestModel manifestModel) {
        super(id, (IModel)manifestModel);
        String aboutMessage = manifestModel.getAboutMessage();
        Label label = new Label(ID_ABOUT_MESSAGE, aboutMessage);
        label.setEscapeModelStrings(false);
        this.add(new Component[]{label});
        WebMarkupContainer container = new WebMarkupContainer(ID_MANIFEST_ATTRIBUTES){
            private static final long serialVersionUID = 1L;

            public void renderHead(IHeaderResponse response) {
                response.render((HeaderItem)JavaScriptReferenceHeaderItem.forReference((ResourceReference)DIV_TOGGLE_JS));
            }
        };
        container.add(new Component[]{new JarManifestListView(ID_MANIFEST_ATTRIBUTE, ID_LINE, manifestModel.getDetail())});
        this.add(new Component[]{container});
    }

    public void renderHead(IHeaderResponse response) {
        PanelUtil.renderHead(response, ((Object)((Object)this)).getClass());
    }
}

