/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.actionresponse;

import com.google.common.collect.Lists;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import org.apache.isis.applib.value.Blob;
import org.apache.isis.applib.value.Clob;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.version.ConcurrencyException;
import org.apache.isis.core.metamodel.facets.object.value.ValueFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.model.models.EntityCollectionModel;
import org.apache.isis.viewer.wicket.model.models.ValueModel;
import org.apache.isis.viewer.wicket.model.models.VoidModel;
import org.apache.isis.viewer.wicket.ui.actionresponse.ActionResultResponse;
import org.apache.isis.viewer.wicket.ui.pages.entity.EntityPage;
import org.apache.isis.viewer.wicket.ui.pages.standalonecollection.StandaloneCollectionPage;
import org.apache.isis.viewer.wicket.ui.pages.value.ValuePage;
import org.apache.isis.viewer.wicket.ui.pages.voidreturn.VoidReturnPage;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.request.IRequestHandler;

public enum ActionResultResponseType {
    OBJECT{

        @Override
        public ActionResultResponse interpretResult(ActionModel model, AjaxRequestTarget target, ObjectAdapter resultAdapter) {
            ObjectAdapter actualAdapter = ActionResultResponseType.determineActualAdapter(resultAdapter);
            return ActionResultResponseType.toEntityPage(model, actualAdapter, null);
        }

        @Override
        public ActionResultResponse interpretResult(ActionModel model, ObjectAdapter targetAdapter, ConcurrencyException ex) {
            return ActionResultResponseType.toEntityPage(model, targetAdapter, ex);
        }
    }
    ,
    COLLECTION{

        @Override
        public ActionResultResponse interpretResult(ActionModel actionModel, AjaxRequestTarget target, ObjectAdapter resultAdapter) {
            EntityCollectionModel collectionModel = EntityCollectionModel.createStandalone((ObjectAdapter)resultAdapter);
            ActionModel actionModelCopy = actionModel.copy();
            collectionModel.setActionHint(actionModelCopy);
            return ActionResultResponse.toPage(new StandaloneCollectionPage(collectionModel));
        }
    }
    ,
    VALUE{

        @Override
        public ActionResultResponse interpretResult(ActionModel model, AjaxRequestTarget target, ObjectAdapter resultAdapter) {
            ValueModel valueModel = new ValueModel(resultAdapter);
            valueModel.setActionHint(model);
            ValuePage valuePage = new ValuePage(valueModel);
            return ActionResultResponse.toPage(valuePage);
        }
    }
    ,
    VALUE_CLOB{

        @Override
        public ActionResultResponse interpretResult(ActionModel model, AjaxRequestTarget target, ObjectAdapter resultAdapter) {
            Object value = resultAdapter.getObject();
            IRequestHandler handler = ActionModel.downloadHandler((Object)value);
            return ActionResultResponse.withHandler(handler);
        }
    }
    ,
    VALUE_BLOB{

        @Override
        public ActionResultResponse interpretResult(ActionModel model, AjaxRequestTarget target, ObjectAdapter resultAdapter) {
            Object value = resultAdapter.getObject();
            IRequestHandler handler = ActionModel.downloadHandler((Object)value);
            return ActionResultResponse.withHandler(handler);
        }
    }
    ,
    VALUE_URL_AJAX{

        @Override
        public ActionResultResponse interpretResult(ActionModel model, AjaxRequestTarget target, ObjectAdapter resultAdapter) {
            URL url = (URL)resultAdapter.getObject();
            return ActionResultResponse.openUrlInBrowser(target, url);
        }
    }
    ,
    VALUE_URL_NOAJAX{

        @Override
        public ActionResultResponse interpretResult(ActionModel model, AjaxRequestTarget target, ObjectAdapter resultAdapter) {
            Object value = resultAdapter.getObject();
            IRequestHandler handler = ActionModel.redirectHandler((Object)value);
            return ActionResultResponse.withHandler(handler);
        }
    }
    ,
    VOID{

        @Override
        public ActionResultResponse interpretResult(ActionModel model, AjaxRequestTarget target, ObjectAdapter resultAdapter) {
            VoidModel voidModel = new VoidModel();
            voidModel.setActionHint(model);
            return ActionResultResponse.toPage(new VoidReturnPage(voidModel));
        }
    };


    public abstract ActionResultResponse interpretResult(ActionModel var1, AjaxRequestTarget var2, ObjectAdapter var3);

    public ActionResultResponse interpretResult(ActionModel model, ObjectAdapter targetAdapter, ConcurrencyException ex) {
        throw new UnsupportedOperationException("Cannot render concurrency exception for any result type other than OBJECT");
    }

    private static ObjectAdapter determineActualAdapter(ObjectAdapter resultAdapter) {
        if (resultAdapter.getSpecification().isNotCollection()) {
            return resultAdapter;
        }
        List<Object> pojoList = ActionResultResponseType.asList(resultAdapter);
        Object pojo = pojoList.get(0);
        return ActionResultResponseType.adapterFor(pojo);
    }

    private static ObjectAdapter adapterFor(Object pojo) {
        return IsisContext.getPersistenceSession().getAdapterManager().adapterFor(pojo);
    }

    private static ActionResultResponse toEntityPage(ActionModel model, ObjectAdapter actualAdapter, ConcurrencyException exIfAny) {
        EntityPage entityPage = new EntityPage(actualAdapter, exIfAny);
        return ActionResultResponse.toPage(entityPage);
    }

    public static ActionResultResponse determineAndInterpretResult(ActionModel model, AjaxRequestTarget target, ObjectAdapter resultAdapter) {
        ActionResultResponseType arrt = ActionResultResponseType.determineFor(resultAdapter, target);
        return arrt.interpretResult(model, target, resultAdapter);
    }

    private static ActionResultResponseType determineFor(ObjectAdapter resultAdapter, AjaxRequestTarget target) {
        if (resultAdapter == null) {
            return VOID;
        }
        ObjectSpecification resultSpec = resultAdapter.getSpecification();
        if (resultSpec.isNotCollection()) {
            if (resultSpec.getFacet(ValueFacet.class) != null) {
                Object value = resultAdapter.getObject();
                if (value instanceof Clob) {
                    return VALUE_CLOB;
                }
                if (value instanceof Blob) {
                    return VALUE_BLOB;
                }
                if (value instanceof URL) {
                    return target != null ? VALUE_URL_AJAX : VALUE_URL_NOAJAX;
                }
                return VALUE;
            }
            return OBJECT;
        }
        List<Object> pojoList = ActionResultResponseType.asList(resultAdapter);
        switch (pojoList.size()) {
            case 1: {
                return OBJECT;
            }
        }
        return COLLECTION;
    }

    private static List<Object> asList(ObjectAdapter resultAdapter) {
        Collection coll = (Collection)resultAdapter.getObject();
        return coll instanceof List ? (List)coll : Lists.newArrayList((Iterable)coll);
    }
}

