/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.viewer.integration.wicket;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizer;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizerComposite;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizerForType;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.metamodel.runtimecontext.ServicesInjector;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.session.IsisSession;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.apache.isis.viewer.wicket.model.models.PageType;
import org.apache.isis.viewer.wicket.ui.errors.ExceptionModel;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.isis.viewer.wicket.ui.pages.error.ErrorPage;
import org.apache.isis.viewer.wicket.ui.pages.login.WicketSignInPage;
import org.apache.isis.viewer.wicket.ui.pages.mmverror.MmvErrorPage;
import org.apache.isis.viewer.wicket.viewer.IsisWicketApplication;
import org.apache.isis.viewer.wicket.viewer.integration.wicket.AuthenticatedWebSessionForIsis;
import org.apache.wicket.Application;
import org.apache.wicket.IPageFactory;
import org.apache.wicket.Page;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.authroles.authentication.AuthenticatedWebSession;
import org.apache.wicket.core.request.handler.IPageProvider;
import org.apache.wicket.core.request.handler.PageProvider;
import org.apache.wicket.core.request.handler.RenderPageRequestHandler;
import org.apache.wicket.model.Model;
import org.apache.wicket.protocol.http.PageExpiredException;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.AbstractRequestCycleListener;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebRequestCycleForIsis
extends AbstractRequestCycleListener {
    private static final Logger LOG = LoggerFactory.getLogger(WebRequestCycleForIsis.class);
    private PageClassRegistry pageClassRegistry;
    private static final ExceptionRecognizerForType pageExpiredExceptionRecognizer = new ExceptionRecognizerForType(PageExpiredException.class, (Function)new Function<String, String>(){

        public String apply(String input) {
            return "Requested page is no longer available. Please navigate back to the home page or select an object from the bookmark bar.";
        }
    });

    public synchronized void onBeginRequest(RequestCycle requestCycle) {
        if (!Session.exists()) {
            return;
        }
        AuthenticatedWebSessionForIsis wicketSession = AuthenticatedWebSessionForIsis.get();
        AuthenticationSession authenticationSession = wicketSession.getAuthenticationSession();
        if (authenticationSession == null) {
            return;
        }
        this.getIsisContext().openSessionInstance(authenticationSession);
        this.getTransactionManager().startTransaction();
    }

    public void onRequestHandlerExecuted(RequestCycle cycle, IRequestHandler handler) {
        IsisSession session;
        if (LOG.isDebugEnabled()) {
            LOG.debug("onRequestHandlerExecuted: handler: " + handler);
        }
        if ((session = this.getIsisContext().getSessionInstance()) != null) {
            try {
                this.getTransactionManager().endTransaction();
            }
            catch (Exception ex) {
                RenderPageRequestHandler requestHandler;
                if (this.getTransactionManager().getTransaction().getState().isComplete()) {
                    this.getTransactionManager().startTransaction();
                }
                if (handler instanceof RenderPageRequestHandler && (requestHandler = (RenderPageRequestHandler)handler).getPage() instanceof ErrorPage) {
                    return;
                }
                PageProvider errorPageProvider = this.errorPageProviderFor(ex);
                throw new RestartResponseException((IPageProvider)errorPageProvider, RenderPageRequestHandler.RedirectPolicy.ALWAYS_REDIRECT);
            }
        }
    }

    public synchronized void onEndRequest(RequestCycle cycle) {
        IsisSession session = this.getIsisContext().getSessionInstance();
        if (session != null) {
            try {
                this.getTransactionManager().endTransaction();
            }
            finally {
                this.getIsisContext().closeSessionInstance();
            }
        }
    }

    public IRequestHandler onException(RequestCycle cycle, Exception ex) {
        PageProvider errorPageProvider = this.errorPageProviderFor(ex);
        RenderPageRequestHandler.RedirectPolicy redirectPolicy = ex instanceof PageExpiredException ? RenderPageRequestHandler.RedirectPolicy.NEVER_REDIRECT : RenderPageRequestHandler.RedirectPolicy.ALWAYS_REDIRECT;
        return errorPageProvider != null ? new RenderPageRequestHandler((IPageProvider)errorPageProvider, redirectPolicy) : null;
    }

    protected PageProvider errorPageProviderFor(Exception ex) {
        IRequestablePage errorPage = this.errorPageFor(ex);
        return errorPage != null ? new PageProvider(errorPage) : null;
    }

    protected IRequestablePage errorPageFor(Exception ex) {
        ArrayList exceptionRecognizers = Lists.newArrayList();
        exceptionRecognizers.add(pageExpiredExceptionRecognizer);
        if (this.inIsisSession()) {
            exceptionRecognizers.addAll(this.getServicesInjector().lookupServices(ExceptionRecognizer.class));
        } else {
            List<String> validationErrors = IsisWicketApplication.get().getValidationErrors();
            if (!validationErrors.isEmpty()) {
                return new MmvErrorPage(Model.ofList(validationErrors));
            }
            LOG.warn("Unable to obtain exceptionRecognizers (no session), will be treated as unrecognized exception");
        }
        String recognizedMessageIfAny = new ExceptionRecognizerComposite((List)exceptionRecognizers).recognize((Throwable)ex);
        ExceptionModel exceptionModel = ExceptionModel.create((String)recognizedMessageIfAny, (Exception)ex);
        return this.isSignedIn() ? new ErrorPage(exceptionModel) : this.newSignInPage(exceptionModel);
    }

    private IRequestablePage newSignInPage(ExceptionModel exceptionModel) {
        Page signInPage;
        Class signInPageClass = null;
        if (this.pageClassRegistry != null) {
            signInPageClass = this.pageClassRegistry.getPageClass(PageType.SIGN_IN);
        }
        if (signInPageClass == null) {
            signInPageClass = WicketSignInPage.class;
        }
        PageParameters parameters = new PageParameters();
        try {
            Constructor constructor = signInPageClass.getConstructor(PageParameters.class, ExceptionModel.class);
            signInPage = (Page)constructor.newInstance(parameters, exceptionModel);
        }
        catch (Exception _) {
            try {
                IPageFactory pageFactory = Application.get().getPageFactory();
                signInPage = (Page)pageFactory.newPage(signInPageClass, parameters);
            }
            catch (Exception x) {
                throw new WicketRuntimeException("Cannot instantiate the configured sign in page", (Throwable)x);
            }
        }
        return signInPage;
    }

    protected boolean isSignedIn() {
        if (!this.inIsisSession()) {
            return false;
        }
        if (this.getAuthenticationSession() == null) {
            return false;
        }
        return this.getWicketAuthenticationSession().isSignedIn();
    }

    public void setPageClassRegistry(PageClassRegistry pageClassRegistry) {
        this.pageClassRegistry = pageClassRegistry;
    }

    protected ServicesInjector getServicesInjector() {
        return IsisContext.getPersistenceSession().getServicesInjector();
    }

    protected IsisContext getIsisContext() {
        return IsisContext.getInstance();
    }

    protected IsisTransactionManager getTransactionManager() {
        return IsisContext.getTransactionManager();
    }

    protected boolean inIsisSession() {
        return IsisContext.inSession();
    }

    protected AuthenticationSession getAuthenticationSession() {
        return IsisContext.getAuthenticationSession();
    }

    protected AuthenticatedWebSession getWicketAuthenticationSession() {
        return AuthenticatedWebSession.get();
    }
}

