/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.calcite.avatica.AvaticaParameter;
import org.apache.calcite.avatica.ColumnMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Meta {
    public String getSqlKeywords();

    public String getNumericFunctions();

    public String getStringFunctions();

    public String getSystemFunctions();

    public String getTimeDateFunctions();

    public MetaResultSet getTables(String var1, Pat var2, Pat var3, List<String> var4);

    public MetaResultSet getColumns(String var1, Pat var2, Pat var3, Pat var4);

    public MetaResultSet getSchemas(String var1, Pat var2);

    public MetaResultSet getCatalogs();

    public MetaResultSet getTableTypes();

    public MetaResultSet getProcedures(String var1, Pat var2, Pat var3);

    public MetaResultSet getProcedureColumns(String var1, Pat var2, Pat var3, Pat var4);

    public MetaResultSet getColumnPrivileges(String var1, String var2, String var3, Pat var4);

    public MetaResultSet getTablePrivileges(String var1, Pat var2, Pat var3);

    public MetaResultSet getBestRowIdentifier(String var1, String var2, String var3, int var4, boolean var5);

    public MetaResultSet getVersionColumns(String var1, String var2, String var3);

    public MetaResultSet getPrimaryKeys(String var1, String var2, String var3);

    public MetaResultSet getImportedKeys(String var1, String var2, String var3);

    public MetaResultSet getExportedKeys(String var1, String var2, String var3);

    public MetaResultSet getCrossReference(String var1, String var2, String var3, String var4, String var5, String var6);

    public MetaResultSet getTypeInfo();

    public MetaResultSet getIndexInfo(String var1, String var2, String var3, boolean var4, boolean var5);

    public MetaResultSet getUDTs(String var1, Pat var2, Pat var3, int[] var4);

    public MetaResultSet getSuperTypes(String var1, Pat var2, Pat var3);

    public MetaResultSet getSuperTables(String var1, Pat var2, Pat var3);

    public MetaResultSet getAttributes(String var1, Pat var2, Pat var3, Pat var4);

    public MetaResultSet getClientInfoProperties();

    public MetaResultSet getFunctions(String var1, Pat var2, Pat var3);

    public MetaResultSet getFunctionColumns(String var1, Pat var2, Pat var3, Pat var4);

    public MetaResultSet getPseudoColumns(String var1, Pat var2, Pat var3, Pat var4);

    public Iterable<Object> createIterable(StatementHandle var1, Signature var2, Iterable<Object> var3);

    public Signature prepare(StatementHandle var1, String var2, int var3);

    public MetaResultSet prepareAndExecute(StatementHandle var1, String var2, int var3, PrepareCallback var4);

    public StatementHandle createStatement(ConnectionHandle var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PrepareCallback {
        public Object getMonitor();

        public void clear() throws SQLException;

        public void assign(Signature var1, Iterable<Object> var2) throws SQLException;

        public void execute() throws SQLException;
    }

    public static class StatementHandle {
        public final int id;

        public String toString() {
            return Integer.toString(this.id);
        }

        @JsonCreator
        public StatementHandle(@JsonProperty(value="id") int id) {
            this.id = id;
        }
    }

    public static class ConnectionHandle {
        public final int id;

        public String toString() {
            return Integer.toString(this.id);
        }

        @JsonCreator
        public ConnectionHandle(@JsonProperty(value="id") int id) {
            this.id = id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Signature {
        public final List<ColumnMetaData> columns;
        public final String sql;
        public final List<AvaticaParameter> parameters;
        public final Map<String, Object> internalParameters;
        public final CursorFactory cursorFactory;

        @JsonCreator
        public Signature(@JsonProperty(value="columns") List<ColumnMetaData> columns, @JsonProperty(value="sql") String sql, @JsonProperty(value="parameters") List<AvaticaParameter> parameters, @JsonProperty(value="internalParameters") Map<String, Object> internalParameters, @JsonProperty(value="cursorFactory") CursorFactory cursorFactory) {
            this.columns = columns;
            this.sql = sql;
            this.parameters = parameters;
            this.internalParameters = internalParameters;
            this.cursorFactory = cursorFactory;
        }

        public Signature setCursorFactory(CursorFactory cursorFactory) {
            return new Signature(this.columns, this.sql, this.parameters, this.internalParameters, cursorFactory);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        OBJECT,
        RECORD,
        RECORD_PROJECTION,
        ARRAY,
        LIST,
        MAP;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CursorFactory {
        public final Style style;
        public final Class clazz;
        @JsonIgnore
        public final List<Field> fields;
        public final List<String> fieldNames;
        public static final CursorFactory OBJECT = new CursorFactory(Style.OBJECT, null, null, null);
        public static final CursorFactory ARRAY = new CursorFactory(Style.ARRAY, null, null, null);
        public static final CursorFactory LIST = new CursorFactory(Style.LIST, null, null, null);

        private CursorFactory(Style style, Class clazz, List<Field> fields, List<String> fieldNames) {
            assert (fieldNames != null == (style == Style.RECORD_PROJECTION || style == Style.MAP));
            assert (fields != null == (style == Style.RECORD_PROJECTION));
            this.style = style;
            this.clazz = clazz;
            this.fields = fields;
            this.fieldNames = fieldNames;
        }

        @JsonCreator
        public static CursorFactory create(@JsonProperty(value="style") Style style, @JsonProperty(value="clazz") Class clazz, @JsonProperty(value="fieldNames") List<String> fieldNames) {
            switch (style) {
                case OBJECT: {
                    return OBJECT;
                }
                case ARRAY: {
                    return ARRAY;
                }
                case LIST: {
                    return LIST;
                }
                case RECORD: {
                    return CursorFactory.record(clazz);
                }
                case RECORD_PROJECTION: {
                    return CursorFactory.record(clazz, null, fieldNames);
                }
                case MAP: {
                    return CursorFactory.map(fieldNames);
                }
            }
            throw new AssertionError((Object)("unknown style: " + (Object)((Object)style)));
        }

        public static CursorFactory record(Class resultClazz) {
            return new CursorFactory(Style.RECORD, resultClazz, null, null);
        }

        public static CursorFactory record(Class resultClass, List<Field> fields, List<String> fieldNames) {
            if (fields == null) {
                fields = new ArrayList<Field>();
                for (String fieldName : fieldNames) {
                    try {
                        fields.add(resultClass.getField(fieldName));
                    }
                    catch (NoSuchFieldException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            return new CursorFactory(Style.RECORD_PROJECTION, resultClass, fields, fieldNames);
        }

        public static CursorFactory map(List<String> fieldNames) {
            return new CursorFactory(Style.MAP, null, null, fieldNames);
        }

        public static CursorFactory deduce(List<ColumnMetaData> columns, Class resultClazz) {
            if (columns.size() == 1) {
                return OBJECT;
            }
            if (resultClazz != null && !resultClazz.isArray()) {
                return CursorFactory.record(resultClazz);
            }
            return ARRAY;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MetaResultSet {
        public final int statementId;
        public final boolean ownStatement;
        public final Iterable<Object> iterable;
        public final Signature signature;

        public MetaResultSet(int statementId, boolean ownStatement, Signature signature, Iterable<Object> iterable) {
            this.signature = signature;
            this.statementId = statementId;
            this.ownStatement = ownStatement;
            this.iterable = iterable;
        }
    }

    public static class Pat {
        public final String s;

        private Pat(String s) {
            this.s = s;
        }

        @JsonCreator
        public static Pat of(@JsonProperty(value="s") String name) {
            return new Pat(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Factory {
        public Meta create(List<String> var1);
    }
}

