/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.util;

import com.ccb.core.bean.BeanUtil;
import com.ccb.core.collection.CollUtil;
import com.ccb.core.exceptions.UtilException;
import com.ccb.core.io.FileUtil;
import com.ccb.core.io.IORuntimeException;
import com.ccb.core.io.IoUtil;
import com.ccb.core.lang.Assert;
import com.ccb.core.map.MapUtil;
import com.ccb.core.util.EscapeUtil;
import com.ccb.core.util.StrUtil;
import com.ccb.core.util.XmlUtil$UniversalNamespaceCache;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XmlUtil {
    public static final String INVALID_REGEX = "[\\x00-\\x08\\x0b-\\x0c\\x0e-\\x1f]";
    public static final String COMMENT_REGEX = "(?s)<!--.+?-->";
    public static final int INDENT_DEFAULT = 2;
    private static String defaultDocumentBuilderFactory = "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl";
    private static boolean namespaceAware = true;
    private static SAXParserFactory factory;

    public static synchronized void disableDefaultDocumentBuilderFactory() {
        defaultDocumentBuilderFactory = null;
    }

    public static synchronized void setNamespaceAware(boolean bl) {
        namespaceAware = bl;
    }

    public static Document readXML(File file) {
        Assert.notNull(file, "Xml file is null !", new Object[0]);
        if (!file.exists()) {
            throw new UtilException("File [{}] not a exist!", file.getAbsolutePath());
        }
        if (!file.isFile()) {
            throw new UtilException("[{}] not a file!", file.getAbsolutePath());
        }
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = FileUtil.getInputStream(file);
            Document document = XmlUtil.readXML(bufferedInputStream);
            return document;
        }
        finally {
            IoUtil.close(bufferedInputStream);
        }
    }

    public static Document readXML(String string) {
        if (StrUtil.startWith((CharSequence)string, '<')) {
            return XmlUtil.parseXml(string);
        }
        return XmlUtil.readXML(FileUtil.file(string));
    }

    public static Document readXML(InputStream inputStream) {
        return XmlUtil.readXML(new InputSource(inputStream));
    }

    public static Document readXML(Reader reader) {
        return XmlUtil.readXML(new InputSource(reader));
    }

    public static Document readXML(InputSource inputSource) {
        DocumentBuilder documentBuilder = XmlUtil.createDocumentBuilder();
        try {
            return documentBuilder.parse(inputSource);
        }
        catch (Exception exception) {
            throw new UtilException(exception, "Parse XML from stream error!", new Object[0]);
        }
    }

    public static void readBySax(File file, ContentHandler contentHandler) {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = FileUtil.getInputStream(file);
            XmlUtil.readBySax(new InputSource(bufferedInputStream), contentHandler);
        }
        finally {
            IoUtil.close(bufferedInputStream);
        }
    }

    public static void readBySax(Reader reader, ContentHandler contentHandler) {
        try {
            XmlUtil.readBySax(new InputSource(reader), contentHandler);
        }
        finally {
            IoUtil.close(reader);
        }
    }

    public static void readBySax(InputStream inputStream, ContentHandler contentHandler) {
        try {
            XmlUtil.readBySax(new InputSource(inputStream), contentHandler);
        }
        finally {
            IoUtil.close(inputStream);
        }
    }

    public static void readBySax(InputSource inputSource, ContentHandler contentHandler) {
        if (null == factory) {
            factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(namespaceAware);
        }
        try {
            SAXParser sAXParser = factory.newSAXParser();
            if (contentHandler instanceof DefaultHandler) {
                sAXParser.parse(inputSource, (DefaultHandler)contentHandler);
                return;
            }
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setContentHandler(contentHandler);
            xMLReader.parse(inputSource);
        }
        catch (ParserConfigurationException | SAXException exception) {
            throw new UtilException(exception);
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    public static Document parseXml(String string) {
        if (StrUtil.isBlank(string)) {
            throw new IllegalArgumentException("XML content string is empty !");
        }
        string = XmlUtil.cleanInvalid(string);
        return XmlUtil.readXML(StrUtil.getReader(string));
    }

    public static Object readObjectFromXml(File file) {
        return XmlUtil.readObjectFromXml(new InputSource(FileUtil.getInputStream(file)));
    }

    public static Object readObjectFromXml(String string) {
        return XmlUtil.readObjectFromXml(new InputSource(StrUtil.getReader(string)));
    }

    public static Object readObjectFromXml(InputSource inputSource) {
        Object object;
        XMLDecoder xMLDecoder = null;
        try {
            xMLDecoder = new XMLDecoder(inputSource);
            object = xMLDecoder.readObject();
        }
        catch (Throwable throwable) {
            IoUtil.close(xMLDecoder);
            throw throwable;
        }
        IoUtil.close(xMLDecoder);
        return object;
    }

    public static String toStr(Node node) {
        return XmlUtil.toStr(node, false);
    }

    public static String toStr(Document document) {
        return XmlUtil.toStr((Node)document);
    }

    public static String toStr(Node node, boolean bl) {
        return XmlUtil.toStr(node, "UTF-8", bl);
    }

    public static String toStr(Document document, boolean bl) {
        return XmlUtil.toStr((Node)document, bl);
    }

    public static String toStr(Node node, String string, boolean bl) {
        return XmlUtil.toStr(node, string, bl, false);
    }

    public static String toStr(Document document, String string, boolean bl) {
        return XmlUtil.toStr((Node)document, string, bl);
    }

    public static String toStr(Node node, String string, boolean bl, boolean bl2) {
        StringWriter stringWriter = StrUtil.getWriter();
        try {
            XmlUtil.write(node, stringWriter, string, bl ? 2 : 0, bl2);
        }
        catch (Exception exception) {
            throw new UtilException(exception, "Trans xml document to string error!", new Object[0]);
        }
        return stringWriter.toString();
    }

    public static String format(Document document) {
        return XmlUtil.toStr(document, true);
    }

    public static String format(String string) {
        return XmlUtil.format(XmlUtil.parseXml(string));
    }

    public static void toFile(Document document, String string) {
        XmlUtil.toFile(document, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toFile(Document document, String string, String string2) {
        if (StrUtil.isBlank(string2)) {
            string2 = document.getXmlEncoding();
        }
        if (StrUtil.isBlank(string2)) {
            string2 = "UTF-8";
        }
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = FileUtil.getWriter(string, string2, false);
            XmlUtil.write((Node)document, bufferedWriter, string2, 2);
        }
        catch (Throwable throwable) {
            IoUtil.close(bufferedWriter);
            throw throwable;
        }
        IoUtil.close(bufferedWriter);
    }

    public static void write(Node node, Writer writer, String string, int n2) {
        XmlUtil.transform(new DOMSource(node), new StreamResult(writer), string, n2);
    }

    public static void write(Node node, Writer writer, String string, int n2, boolean bl) {
        XmlUtil.transform(new DOMSource(node), new StreamResult(writer), string, n2, bl);
    }

    public static void write(Node node, OutputStream outputStream, String string, int n2) {
        XmlUtil.transform(new DOMSource(node), new StreamResult(outputStream), string, n2);
    }

    public static void write(Node node, OutputStream outputStream, String string, int n2, boolean bl) {
        XmlUtil.transform(new DOMSource(node), new StreamResult(outputStream), string, n2, bl);
    }

    public static void transform(Source source, Result result, String string, int n2) {
        XmlUtil.transform(source, result, string, n2, false);
    }

    public static void transform(Source source, Result result, String string, int n2, boolean bl) {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            if (n2 > 0) {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(n2));
            }
            if (StrUtil.isNotBlank(string)) {
                transformer.setOutputProperty("encoding", string);
            }
            if (bl) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            transformer.transform(source, result);
        }
        catch (Exception exception) {
            throw new UtilException(exception, "Trans xml document to string error!", new Object[0]);
        }
    }

    public static Document createXml() {
        return XmlUtil.createDocumentBuilder().newDocument();
    }

    public static DocumentBuilder createDocumentBuilder() {
        DocumentBuilder documentBuilder;
        try {
            documentBuilder = XmlUtil.createDocumentBuilderFactory().newDocumentBuilder();
        }
        catch (Exception exception) {
            throw new UtilException(exception, "Create xml document error!", new Object[0]);
        }
        return documentBuilder;
    }

    public static DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory documentBuilderFactory = StrUtil.isNotEmpty(defaultDocumentBuilderFactory) ? DocumentBuilderFactory.newInstance(defaultDocumentBuilderFactory, null) : DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(namespaceAware);
        return XmlUtil.disableXXE(documentBuilderFactory);
    }

    public static Document createXml(String string) {
        return XmlUtil.createXml(string, null);
    }

    public static Document createXml(String string, String string2) {
        Document document = XmlUtil.createXml();
        document.appendChild(null == string2 ? document.createElement(string) : document.createElementNS(string2, string));
        return document;
    }

    public static Element getRootElement(Document document) {
        return null == document ? null : document.getDocumentElement();
    }

    public static Document getOwnerDocument(Node node) {
        return node instanceof Document ? (Document)node : node.getOwnerDocument();
    }

    public static String cleanInvalid(String string) {
        if (string == null) {
            return null;
        }
        return string.replaceAll(INVALID_REGEX, "");
    }

    public static String cleanComment(String string) {
        if (string == null) {
            return null;
        }
        return string.replaceAll(COMMENT_REGEX, "");
    }

    public static List getElements(Element element, String string) {
        NodeList nodeList = StrUtil.isBlank(string) ? element.getChildNodes() : element.getElementsByTagName(string);
        return XmlUtil.transElements(element, nodeList);
    }

    public static Element getElement(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList == null || nodeList.getLength() < 1) {
            return null;
        }
        int n2 = nodeList.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            Element element2 = (Element)nodeList.item(i2);
            if (element2 != null && element2.getParentNode() != element) continue;
            return element2;
        }
        return null;
    }

    public static String elementText(Element element, String string) {
        Element element2 = XmlUtil.getElement(element, string);
        return element2 == null ? null : element2.getTextContent();
    }

    public static String elementText(Element element, String string, String string2) {
        Element element2 = XmlUtil.getElement(element, string);
        return element2 == null ? string2 : element2.getTextContent();
    }

    public static List transElements(NodeList nodeList) {
        return XmlUtil.transElements(null, nodeList);
    }

    public static List transElements(Element element, NodeList nodeList) {
        int n2 = nodeList.getLength();
        ArrayList<Element> arrayList = new ArrayList<Element>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = nodeList.item(i2);
            if (1 != node.getNodeType()) continue;
            Element element2 = (Element)nodeList.item(i2);
            if (element != null && element2.getParentNode() != element) continue;
            arrayList.add(element2);
        }
        return arrayList;
    }

    public static void writeObjectAsXml(File file, Object object) {
        XMLEncoder xMLEncoder = null;
        try {
            xMLEncoder = new XMLEncoder(FileUtil.getOutputStream(file));
            xMLEncoder.writeObject(object);
        }
        catch (Throwable throwable) {
            IoUtil.close(xMLEncoder);
            throw throwable;
        }
        IoUtil.close(xMLEncoder);
    }

    public static XPath createXPath() {
        return XPathFactory.newInstance().newXPath();
    }

    public static Element getElementByXPath(String string, Object object) {
        return (Element)XmlUtil.getNodeByXPath(string, object);
    }

    public static NodeList getNodeListByXPath(String string, Object object) {
        return (NodeList)XmlUtil.getByXPath(string, object, XPathConstants.NODESET);
    }

    public static Node getNodeByXPath(String string, Object object) {
        return (Node)XmlUtil.getByXPath(string, object, XPathConstants.NODE);
    }

    public static Object getByXPath(String string, Object object, QName qName) {
        XmlUtil$UniversalNamespaceCache xmlUtil$UniversalNamespaceCache = null;
        if (object instanceof Node) {
            xmlUtil$UniversalNamespaceCache = new XmlUtil$UniversalNamespaceCache((Node)object, false);
        }
        return XmlUtil.getByXPath(string, object, qName, xmlUtil$UniversalNamespaceCache);
    }

    public static Object getByXPath(String string, Object object, QName qName, NamespaceContext namespaceContext) {
        XPath xPath = XmlUtil.createXPath();
        if (null != namespaceContext) {
            xPath.setNamespaceContext(namespaceContext);
        }
        try {
            if (object instanceof InputSource) {
                return xPath.evaluate(string, (InputSource)object, qName);
            }
            return xPath.evaluate(string, object, qName);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new UtilException(xPathExpressionException);
        }
    }

    public static String escape(String string) {
        return EscapeUtil.escape(string);
    }

    public static String unescape(String string) {
        return EscapeUtil.unescape(string);
    }

    public static Map xmlToMap(String string) {
        return XmlUtil.xmlToMap(string, new HashMap());
    }

    public static Object xmlToBean(Node node, Class clazz) {
        Map map = XmlUtil.xmlToMap(node);
        if (null != map && map.size() == 1) {
            return BeanUtil.toBean(map.get(clazz.getSimpleName()), clazz);
        }
        return BeanUtil.toBean(map, clazz);
    }

    public static Map xmlToMap(Node node) {
        return XmlUtil.xmlToMap(node, new HashMap());
    }

    public static Map xmlToMap(String string, Map map) {
        Document document = XmlUtil.parseXml(string);
        Element element = XmlUtil.getRootElement(document);
        element.normalize();
        return XmlUtil.xmlToMap(element, map);
    }

    public static Map xmlToMap(Node node, Map hashMap) {
        if (null == hashMap) {
            hashMap = new HashMap<String, Object>();
        }
        NodeList nodeList = node.getChildNodes();
        int n2 = nodeList.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            Map map;
            Node node2 = nodeList.item(i2);
            if (!XmlUtil.isElement(node2)) continue;
            Element element = (Element)node2;
            Object v2 = hashMap.get(element.getNodeName());
            Object object = element.hasChildNodes() ? (MapUtil.isNotEmpty(map = XmlUtil.xmlToMap(element)) ? map : element.getTextContent()) : element.getTextContent();
            if (null == object) continue;
            if (null != v2) {
                if (v2 instanceof List) {
                    ((List)v2).add(object);
                    continue;
                }
                hashMap.put(element.getNodeName(), CollUtil.newArrayList(v2, object));
                continue;
            }
            hashMap.put(element.getNodeName(), object);
        }
        return hashMap;
    }

    public static String mapToXmlStr(Map map) {
        return XmlUtil.toStr(XmlUtil.mapToXml(map, "xml"));
    }

    public static String mapToXmlStr(Map map, boolean bl) {
        return XmlUtil.toStr(XmlUtil.mapToXml(map, "xml"), "UTF-8", false, bl);
    }

    public static String mapToXmlStr(Map map, String string) {
        return XmlUtil.toStr(XmlUtil.mapToXml(map, string));
    }

    public static String mapToXmlStr(Map map, String string, String string2) {
        return XmlUtil.toStr(XmlUtil.mapToXml(map, string, string2));
    }

    public static String mapToXmlStr(Map map, String string, String string2, boolean bl) {
        return XmlUtil.toStr(XmlUtil.mapToXml(map, string, string2), "UTF-8", false, bl);
    }

    public static String mapToXmlStr(Map map, String string, String string2, boolean bl, boolean bl2) {
        return XmlUtil.toStr(XmlUtil.mapToXml(map, string, string2), "UTF-8", bl);
    }

    public static String mapToXmlStr(Map map, String string, String string2, String string3, boolean bl, boolean bl2) {
        return XmlUtil.toStr(XmlUtil.mapToXml(map, string, string2), string3, bl, bl2);
    }

    public static Document mapToXml(Map map, String string) {
        return XmlUtil.mapToXml(map, string, null);
    }

    public static Document mapToXml(Map map, String string, String string2) {
        Document document = XmlUtil.createXml();
        Element element = XmlUtil.appendChild(document, string, string2);
        XmlUtil.appendMap(document, element, map);
        return document;
    }

    public static Document beanToXml(Object object) {
        return XmlUtil.beanToXml(object, null);
    }

    public static Document beanToXml(Object object, String string) {
        if (null == object) {
            return null;
        }
        return XmlUtil.mapToXml(BeanUtil.beanToMap(object), object.getClass().getSimpleName(), string);
    }

    public static boolean isElement(Node node) {
        return null != node && 1 == node.getNodeType();
    }

    public static Element appendChild(Node node, String string) {
        return XmlUtil.appendChild(node, string, null);
    }

    public static Element appendChild(Node node, String string, String string2) {
        Document document = XmlUtil.getOwnerDocument(node);
        Element element = null == string2 ? document.createElement(string) : document.createElementNS(string2, string);
        node.appendChild(element);
        return element;
    }

    public static Node appendText(Node node, CharSequence charSequence) {
        return XmlUtil.appendText(XmlUtil.getOwnerDocument(node), node, charSequence);
    }

    private static void append(Document document, Node node, Object object) {
        if (object instanceof Map) {
            XmlUtil.appendMap(document, node, (Map)object);
        } else if (object instanceof Iterator) {
            XmlUtil.appendIterator(document, node, (Iterator)object);
        } else if (object instanceof Iterable) {
            XmlUtil.appendIterator(document, node, ((Iterable)object).iterator());
        } else {
            XmlUtil.appendText(document, node, object.toString());
        }
    }

    private static void appendMap(Document document, Node node, Map map) {
        map.forEach((object, object2) -> {
            if (null != object) {
                Element element = XmlUtil.appendChild(node, object.toString());
                if (null != object2) {
                    XmlUtil.append(document, element, object2);
                }
            }
        });
    }

    private static void appendIterator(Document document, Node node, Iterator iterator) {
        Node node2 = node.getParentNode();
        boolean bl = true;
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (bl) {
                XmlUtil.append(document, node, e2);
                bl = false;
                continue;
            }
            Node node3 = node.cloneNode(false);
            node2.appendChild(node3);
            XmlUtil.append(document, node3, e2);
        }
    }

    private static Node appendText(Document document, Node node, CharSequence charSequence) {
        return node.appendChild(document.createTextNode(StrUtil.str(charSequence)));
    }

    private static DocumentBuilderFactory disableXXE(DocumentBuilderFactory documentBuilderFactory) {
        try {
            String string = "http://apache.org/xml/features/disallow-doctype-decl";
            documentBuilderFactory.setFeature(string, true);
            string = "http://xml.org/sax/features/external-general-entities";
            documentBuilderFactory.setFeature(string, false);
            string = "http://xml.org/sax/features/external-parameter-entities";
            documentBuilderFactory.setFeature(string, false);
            string = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
            documentBuilderFactory.setFeature(string, false);
            documentBuilderFactory.setXIncludeAware(false);
            documentBuilderFactory.setExpandEntityReferences(false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return documentBuilderFactory;
    }
}

