/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.util;

import com.ccb.core.comparator.VersionComparator;
import com.ccb.core.convert.Convert;
import com.ccb.core.lang.Assert;
import com.ccb.core.lang.Filter;
import com.ccb.core.lang.Matcher;
import com.ccb.core.lang.func.Func1;
import com.ccb.core.text.StrBuilder;
import com.ccb.core.text.StrFormatter;
import com.ccb.core.text.StrSpliter;
import com.ccb.core.text.TextSimilarity;
import com.ccb.core.util.ArrayUtil;
import com.ccb.core.util.CharUtil;
import com.ccb.core.util.CharsetUtil;
import com.ccb.core.util.IdUtil;
import com.ccb.core.util.NumberUtil;
import com.ccb.core.util.ReUtil;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class StrUtil {
    public static final int INDEX_NOT_FOUND = -1;
    public static final char C_SPACE = ' ';
    public static final char C_TAB = '\t';
    public static final char C_DOT = '.';
    public static final char C_SLASH = '/';
    public static final char C_BACKSLASH = '\\';
    public static final char C_CR = '\r';
    public static final char C_LF = '\n';
    public static final char C_UNDERLINE = '_';
    public static final char C_COMMA = ',';
    public static final char C_DELIM_START = '{';
    public static final char C_DELIM_END = '}';
    public static final char C_BRACKET_START = '[';
    public static final char C_BRACKET_END = ']';
    public static final char C_COLON = ':';
    public static final char C_AT = '@';
    public static final String SPACE = " ";
    public static final String TAB = "\t";
    public static final String DOT = ".";
    public static final String DOUBLE_DOT = "..";
    public static final String SLASH = "/";
    public static final String BACKSLASH = "\\";
    public static final String EMPTY = "";
    public static final String NULL = "null";
    public static final String CR = "\r";
    public static final String LF = "\n";
    public static final String CRLF = "\r\n";
    public static final String UNDERLINE = "_";
    public static final String DASHED = "-";
    public static final String COMMA = ",";
    public static final String DELIM_START = "{";
    public static final String DELIM_END = "}";
    public static final String BRACKET_START = "[";
    public static final String BRACKET_END = "]";
    public static final String COLON = ":";
    public static final String AT = "@";
    public static final String HTML_NBSP = "&nbsp;";
    public static final String HTML_AMP = "&amp;";
    public static final String HTML_QUOTE = "&quot;";
    public static final String HTML_APOS = "&apos;";
    public static final String HTML_LT = "&lt;";
    public static final String HTML_GT = "&gt;";
    public static final String EMPTY_JSON = "{}";

    public static boolean isBlank(CharSequence charSequence) {
        int n2;
        if (charSequence == null || (n2 = charSequence.length()) == 0) {
            return true;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (CharUtil.isBlankChar(charSequence.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlankIfStr(Object object) {
        if (null == object) {
            return true;
        }
        if (object instanceof CharSequence) {
            return StrUtil.isBlank((CharSequence)object);
        }
        return false;
    }

    public static boolean isNotBlank(CharSequence charSequence) {
        return false == StrUtil.isBlank(charSequence);
    }

    public static boolean hasBlank(CharSequence ... charSequenceArray) {
        if (ArrayUtil.isEmpty(charSequenceArray)) {
            return true;
        }
        for (CharSequence charSequence : charSequenceArray) {
            if (!StrUtil.isBlank(charSequence)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllBlank(CharSequence ... charSequenceArray) {
        if (ArrayUtil.isEmpty(charSequenceArray)) {
            return true;
        }
        for (CharSequence charSequence : charSequenceArray) {
            if (!StrUtil.isNotBlank(charSequence)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(CharSequence charSequence) {
        return charSequence == null || charSequence.length() == 0;
    }

    public static boolean isEmptyIfStr(Object object) {
        if (null == object) {
            return true;
        }
        if (object instanceof CharSequence) {
            return 0 == ((CharSequence)object).length();
        }
        return false;
    }

    public static boolean isNotEmpty(CharSequence charSequence) {
        return false == StrUtil.isEmpty(charSequence);
    }

    public static String emptyIfNull(CharSequence charSequence) {
        return StrUtil.nullToEmpty(charSequence);
    }

    public static String nullToEmpty(CharSequence charSequence) {
        return StrUtil.nullToDefault(charSequence, EMPTY);
    }

    public static String nullToDefault(CharSequence charSequence, String string) {
        return charSequence == null ? string : charSequence.toString();
    }

    public static String emptyToDefault(CharSequence charSequence, String string) {
        return StrUtil.isEmpty(charSequence) ? string : charSequence.toString();
    }

    public static String blankToDefault(CharSequence charSequence, String string) {
        return StrUtil.isBlank(charSequence) ? string : charSequence.toString();
    }

    public static String emptyToNull(CharSequence charSequence) {
        return StrUtil.isEmpty(charSequence) ? null : charSequence.toString();
    }

    public static boolean hasEmpty(CharSequence ... charSequenceArray) {
        if (ArrayUtil.isEmpty(charSequenceArray)) {
            return true;
        }
        for (CharSequence charSequence : charSequenceArray) {
            if (!StrUtil.isEmpty(charSequence)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllEmpty(CharSequence ... charSequenceArray) {
        if (ArrayUtil.isEmpty(charSequenceArray)) {
            return true;
        }
        for (CharSequence charSequence : charSequenceArray) {
            if (!StrUtil.isNotEmpty(charSequence)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllNotEmpty(CharSequence ... charSequenceArray) {
        return false == StrUtil.hasEmpty(charSequenceArray);
    }

    public static boolean isAllNotBlank(CharSequence ... charSequenceArray) {
        return false == StrUtil.hasBlank(charSequenceArray);
    }

    public static boolean isNullOrUndefined(CharSequence charSequence) {
        if (null == charSequence) {
            return true;
        }
        return StrUtil.isNullOrUndefinedStr(charSequence);
    }

    public static boolean isEmptyOrUndefined(CharSequence charSequence) {
        if (StrUtil.isEmpty(charSequence)) {
            return true;
        }
        return StrUtil.isNullOrUndefinedStr(charSequence);
    }

    public static boolean isBlankOrUndefined(CharSequence charSequence) {
        if (StrUtil.isBlank(charSequence)) {
            return true;
        }
        return StrUtil.isNullOrUndefinedStr(charSequence);
    }

    private static boolean isNullOrUndefinedStr(CharSequence charSequence) {
        String string = charSequence.toString().trim();
        return NULL.equals(string) || "undefined".equals(string);
    }

    public static String trim(CharSequence charSequence) {
        return null == charSequence ? null : StrUtil.trim(charSequence, 0);
    }

    public static void trim(String[] stringArray) {
        if (null == stringArray) {
            return;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            if (null == string) continue;
            stringArray[i2] = string.trim();
        }
    }

    public static String trimToEmpty(CharSequence charSequence) {
        return charSequence == null ? EMPTY : StrUtil.trim(charSequence);
    }

    public static String trimToNull(CharSequence charSequence) {
        String string = StrUtil.trim(charSequence);
        return EMPTY.equals(string) ? null : string;
    }

    public static String trimStart(CharSequence charSequence) {
        return StrUtil.trim(charSequence, -1);
    }

    public static String trimEnd(CharSequence charSequence) {
        return StrUtil.trim(charSequence, 1);
    }

    public static String trim(CharSequence charSequence, int n2) {
        int n3;
        if (charSequence == null) {
            return null;
        }
        int n4 = charSequence.length();
        int n5 = n4;
        if (n2 <= 0) {
            for (n3 = 0; n3 < n5 && CharUtil.isBlankChar(charSequence.charAt(n3)); ++n3) {
            }
        }
        if (n2 >= 0) {
            while (n3 < n5 && CharUtil.isBlankChar(charSequence.charAt(n5 - 1))) {
                --n5;
            }
        }
        if (n3 > 0 || n5 < n4) {
            return charSequence.toString().substring(n3, n5);
        }
        return charSequence.toString();
    }

    public static boolean startWith(CharSequence charSequence, char c2) {
        if (StrUtil.isEmpty(charSequence)) {
            return false;
        }
        return c2 == charSequence.charAt(0);
    }

    public static boolean startWith(CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        return StrUtil.startWith(charSequence, charSequence2, bl, false);
    }

    public static boolean startWith(CharSequence charSequence, CharSequence charSequence2, boolean bl, boolean bl2) {
        if (null == charSequence || null == charSequence2) {
            if (!bl2) {
                return false;
            }
            return null == charSequence && null == charSequence2;
        }
        boolean bl3 = bl ? charSequence.toString().toLowerCase().startsWith(charSequence2.toString().toLowerCase()) : charSequence.toString().startsWith(charSequence2.toString());
        if (bl3) {
            return false == bl2 || false == StrUtil.equals(charSequence, charSequence2, bl);
        }
        return false;
    }

    public static boolean startWith(CharSequence charSequence, CharSequence charSequence2) {
        return StrUtil.startWith(charSequence, charSequence2, false);
    }

    public static boolean startWithIgnoreEquals(CharSequence charSequence, CharSequence charSequence2) {
        return StrUtil.startWith(charSequence, charSequence2, false, true);
    }

    public static boolean startWithIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        return StrUtil.startWith(charSequence, charSequence2, true);
    }

    public static boolean startWithAny(CharSequence charSequence, CharSequence ... charSequenceArray) {
        if (StrUtil.isEmpty(charSequence) || ArrayUtil.isEmpty(charSequenceArray)) {
            return false;
        }
        for (CharSequence charSequence2 : charSequenceArray) {
            if (!StrUtil.startWith(charSequence, charSequence2, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean endWith(CharSequence charSequence, char c2) {
        if (StrUtil.isEmpty(charSequence)) {
            return false;
        }
        return c2 == charSequence.charAt(charSequence.length() - 1);
    }

    public static boolean endWith(CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        if (null == charSequence || null == charSequence2) {
            return null == charSequence && null == charSequence2;
        }
        if (bl) {
            return charSequence.toString().toLowerCase().endsWith(charSequence2.toString().toLowerCase());
        }
        return charSequence.toString().endsWith(charSequence2.toString());
    }

    public static boolean endWith(CharSequence charSequence, CharSequence charSequence2) {
        return StrUtil.endWith(charSequence, charSequence2, false);
    }

    public static boolean endWithIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        return StrUtil.endWith(charSequence, charSequence2, true);
    }

    public static boolean endWithAny(CharSequence charSequence, CharSequence ... charSequenceArray) {
        if (StrUtil.isEmpty(charSequence) || ArrayUtil.isEmpty(charSequenceArray)) {
            return false;
        }
        for (CharSequence charSequence2 : charSequenceArray) {
            if (!StrUtil.endWith(charSequence, charSequence2, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(CharSequence charSequence, char c2) {
        return StrUtil.indexOf(charSequence, c2) > -1;
    }

    public static boolean contains(CharSequence charSequence, CharSequence charSequence2) {
        if (null == charSequence || null == charSequence2) {
            return false;
        }
        return charSequence.toString().contains(charSequence2);
    }

    public static boolean containsAny(CharSequence charSequence, CharSequence ... charSequenceArray) {
        return null != StrUtil.getContainsStr(charSequence, charSequenceArray);
    }

    public static boolean containsAny(CharSequence charSequence, char ... cArray) {
        if (!StrUtil.isEmpty(charSequence)) {
            int n2 = charSequence.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!ArrayUtil.contains(cArray, charSequence.charAt(i2))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsOnly(CharSequence charSequence, char ... cArray) {
        if (!StrUtil.isEmpty(charSequence)) {
            int n2 = charSequence.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (ArrayUtil.contains(cArray, charSequence.charAt(i2))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean containsBlank(CharSequence charSequence) {
        if (null == charSequence) {
            return false;
        }
        int n2 = charSequence.length();
        if (0 == n2) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!CharUtil.isBlankChar(charSequence.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    public static String getContainsStr(CharSequence charSequence, CharSequence ... charSequenceArray) {
        if (StrUtil.isEmpty(charSequence) || ArrayUtil.isEmpty(charSequenceArray)) {
            return null;
        }
        for (CharSequence charSequence2 : charSequenceArray) {
            if (!charSequence.toString().contains(charSequence2)) continue;
            return charSequence2.toString();
        }
        return null;
    }

    public static boolean containsIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        if (null == charSequence) {
            return null == charSequence2;
        }
        return charSequence.toString().toLowerCase().contains(charSequence2.toString().toLowerCase());
    }

    public static boolean containsAnyIgnoreCase(CharSequence charSequence, CharSequence ... charSequenceArray) {
        return null != StrUtil.getContainsStrIgnoreCase(charSequence, charSequenceArray);
    }

    public static String getContainsStrIgnoreCase(CharSequence charSequence, CharSequence ... charSequenceArray) {
        if (StrUtil.isEmpty(charSequence) || ArrayUtil.isEmpty(charSequenceArray)) {
            return null;
        }
        for (CharSequence charSequence2 : charSequenceArray) {
            if (!StrUtil.containsIgnoreCase(charSequence, charSequence2)) continue;
            return charSequence2.toString();
        }
        return null;
    }

    public static String getGeneralField(CharSequence charSequence) {
        String string = charSequence.toString();
        if (string.startsWith("get") || string.startsWith("set")) {
            return StrUtil.removePreAndLowerFirst(charSequence, 3);
        }
        if (string.startsWith("is")) {
            return StrUtil.removePreAndLowerFirst(charSequence, 2);
        }
        return null;
    }

    public static String genSetter(CharSequence charSequence) {
        return StrUtil.upperFirstAndAddPre(charSequence, "set");
    }

    public static String genGetter(CharSequence charSequence) {
        return StrUtil.upperFirstAndAddPre(charSequence, "get");
    }

    public static String removeAll(CharSequence charSequence, CharSequence charSequence2) {
        if (StrUtil.isEmpty(charSequence) || StrUtil.isEmpty(charSequence2)) {
            return StrUtil.str(charSequence);
        }
        return charSequence.toString().replace(charSequence2, EMPTY);
    }

    public static String removeAny(CharSequence charSequence, CharSequence ... charSequenceArray) {
        String string = StrUtil.str(charSequence);
        if (StrUtil.isNotEmpty(charSequence)) {
            for (CharSequence charSequence2 : charSequenceArray) {
                string = StrUtil.removeAll((CharSequence)string, charSequence2);
            }
        }
        return string;
    }

    public static String removeAll(CharSequence charSequence, char ... cArray) {
        if (null == charSequence || ArrayUtil.isEmpty(cArray)) {
            return StrUtil.str(charSequence);
        }
        int n2 = charSequence.length();
        if (0 == n2) {
            return StrUtil.str(charSequence);
        }
        StringBuilder stringBuilder = StrUtil.builder(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (ArrayUtil.contains(cArray, c2)) continue;
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static String removeAllLineBreaks(CharSequence charSequence) {
        return StrUtil.removeAll(charSequence, '\r', '\n');
    }

    public static String removePreAndLowerFirst(CharSequence charSequence, int n2) {
        if (charSequence == null) {
            return null;
        }
        if (charSequence.length() > n2) {
            char c2 = Character.toLowerCase(charSequence.charAt(n2));
            if (charSequence.length() > n2 + 1) {
                return c2 + charSequence.toString().substring(n2 + 1);
            }
            return String.valueOf(c2);
        }
        return charSequence.toString();
    }

    public static String removePreAndLowerFirst(CharSequence charSequence, CharSequence charSequence2) {
        return StrUtil.lowerFirst(StrUtil.removePrefix(charSequence, charSequence2));
    }

    public static String upperFirstAndAddPre(CharSequence charSequence, String string) {
        if (charSequence == null || string == null) {
            return null;
        }
        return string + StrUtil.upperFirst(charSequence);
    }

    public static String upperFirst(CharSequence charSequence) {
        char c2;
        if (null == charSequence) {
            return null;
        }
        if (charSequence.length() > 0 && Character.isLowerCase(c2 = charSequence.charAt(0))) {
            return Character.toUpperCase(c2) + StrUtil.subSuf(charSequence, 1);
        }
        return charSequence.toString();
    }

    public static String lowerFirst(CharSequence charSequence) {
        char c2;
        if (null == charSequence) {
            return null;
        }
        if (charSequence.length() > 0 && Character.isUpperCase(c2 = charSequence.charAt(0))) {
            return Character.toLowerCase(c2) + StrUtil.subSuf(charSequence, 1);
        }
        return charSequence.toString();
    }

    public static String removePrefix(CharSequence charSequence, CharSequence charSequence2) {
        if (StrUtil.isEmpty(charSequence) || StrUtil.isEmpty(charSequence2)) {
            return StrUtil.str(charSequence);
        }
        String string = charSequence.toString();
        if (string.startsWith(charSequence2.toString())) {
            return StrUtil.subSuf(string, charSequence2.length());
        }
        return string;
    }

    public static String removePrefixIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        if (StrUtil.isEmpty(charSequence) || StrUtil.isEmpty(charSequence2)) {
            return StrUtil.str(charSequence);
        }
        String string = charSequence.toString();
        if (string.toLowerCase().startsWith(charSequence2.toString().toLowerCase())) {
            return StrUtil.subSuf(string, charSequence2.length());
        }
        return string;
    }

    public static String removeSuffix(CharSequence charSequence, CharSequence charSequence2) {
        if (StrUtil.isEmpty(charSequence) || StrUtil.isEmpty(charSequence2)) {
            return StrUtil.str(charSequence);
        }
        String string = charSequence.toString();
        if (string.endsWith(charSequence2.toString())) {
            return StrUtil.subPre(string, string.length() - charSequence2.length());
        }
        return string;
    }

    public static String removeSufAndLowerFirst(CharSequence charSequence, CharSequence charSequence2) {
        return StrUtil.lowerFirst(StrUtil.removeSuffix(charSequence, charSequence2));
    }

    public static String removeSuffixIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        if (StrUtil.isEmpty(charSequence) || StrUtil.isEmpty(charSequence2)) {
            return StrUtil.str(charSequence);
        }
        String string = charSequence.toString();
        if (string.toLowerCase().endsWith(charSequence2.toString().toLowerCase())) {
            return StrUtil.subPre(string, string.length() - charSequence2.length());
        }
        return string;
    }

    public static String strip(CharSequence charSequence, CharSequence charSequence2) {
        if (StrUtil.equals(charSequence, charSequence2)) {
            return EMPTY;
        }
        return StrUtil.strip(charSequence, charSequence2, charSequence2);
    }

    public static String strip(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3) {
        if (StrUtil.isEmpty(charSequence)) {
            return StrUtil.str(charSequence);
        }
        int n2 = 0;
        int n3 = charSequence.length();
        String string = charSequence.toString();
        if (StrUtil.startWith((CharSequence)string, charSequence2)) {
            n2 = charSequence2.length();
        }
        if (StrUtil.endWith((CharSequence)string, charSequence3)) {
            n3 -= charSequence3.length();
        }
        return string.substring(Math.min(n2, n3), Math.max(n2, n3));
    }

    public static String stripIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        return StrUtil.stripIgnoreCase(charSequence, charSequence2, charSequence2);
    }

    public static String stripIgnoreCase(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3) {
        if (StrUtil.isEmpty(charSequence)) {
            return StrUtil.str(charSequence);
        }
        int n2 = 0;
        int n3 = charSequence.length();
        String string = charSequence.toString();
        if (StrUtil.startWithIgnoreCase(string, charSequence2)) {
            n2 = charSequence2.length();
        }
        if (StrUtil.endWithIgnoreCase(string, charSequence3)) {
            n3 -= charSequence3.length();
        }
        return string.substring(n2, n3);
    }

    public static String addPrefixIfNot(CharSequence charSequence, CharSequence charSequence2) {
        String string;
        if (StrUtil.isEmpty(charSequence) || StrUtil.isEmpty(charSequence2)) {
            return StrUtil.str(charSequence);
        }
        String string2 = charSequence.toString();
        if (!string2.startsWith(string = charSequence2.toString())) {
            return string.concat(string2);
        }
        return string2;
    }

    public static String addSuffixIfNot(CharSequence charSequence, CharSequence charSequence2) {
        String string;
        if (StrUtil.isEmpty(charSequence) || StrUtil.isEmpty(charSequence2)) {
            return StrUtil.str(charSequence);
        }
        String string2 = charSequence.toString();
        if (!string2.endsWith(string = charSequence2.toString())) {
            return string2.concat(string);
        }
        return string2;
    }

    public static String cleanBlank(CharSequence charSequence) {
        return StrUtil.filter(charSequence, c2 -> false == CharUtil.isBlankChar(c2.charValue()));
    }

    public static String[] splitToArray(CharSequence charSequence, char c2) {
        return StrUtil.splitToArray(charSequence, c2, 0);
    }

    public static long[] splitToLong(CharSequence charSequence, char c2) {
        return (long[])Convert.convert(long[].class, (Object)StrUtil.splitTrim(charSequence, c2));
    }

    public static long[] splitToLong(CharSequence charSequence, CharSequence charSequence2) {
        return (long[])Convert.convert(long[].class, (Object)StrUtil.splitTrim(charSequence, charSequence2));
    }

    public static int[] splitToInt(CharSequence charSequence, char c2) {
        return (int[])Convert.convert(int[].class, (Object)StrUtil.splitTrim(charSequence, c2));
    }

    public static int[] splitToInt(CharSequence charSequence, CharSequence charSequence2) {
        return (int[])Convert.convert(int[].class, (Object)StrUtil.splitTrim(charSequence, charSequence2));
    }

    public static List split(CharSequence charSequence, char c2) {
        return StrUtil.split(charSequence, c2, 0);
    }

    public static String[] splitToArray(CharSequence charSequence, char c2, int n2) {
        if (null == charSequence) {
            return new String[0];
        }
        return StrSpliter.splitToArray(charSequence.toString(), c2, n2, false, false);
    }

    public static List split(CharSequence charSequence, char c2, int n2) {
        return StrUtil.split(charSequence, c2, n2, false, false);
    }

    public static List splitTrim(CharSequence charSequence, char c2) {
        return StrUtil.splitTrim(charSequence, c2, -1);
    }

    public static List splitTrim(CharSequence charSequence, CharSequence charSequence2) {
        return StrUtil.splitTrim(charSequence, charSequence2, -1);
    }

    public static List splitTrim(CharSequence charSequence, char c2, int n2) {
        return StrUtil.split(charSequence, c2, n2, true, true);
    }

    public static List splitTrim(CharSequence charSequence, CharSequence charSequence2, int n2) {
        return StrUtil.split(charSequence, charSequence2, n2, true, true);
    }

    public static List split(CharSequence charSequence, char c2, boolean bl, boolean bl2) {
        return StrUtil.split(charSequence, c2, 0, bl, bl2);
    }

    public static List split(CharSequence charSequence, char c2, int n2, boolean bl, boolean bl2) {
        if (null == charSequence) {
            return new ArrayList(0);
        }
        return StrSpliter.split(charSequence.toString(), c2, n2, bl, bl2);
    }

    public static List split(CharSequence charSequence, CharSequence charSequence2, int n2, boolean bl, boolean bl2) {
        if (null == charSequence) {
            return new ArrayList(0);
        }
        String string = null == charSequence2 ? null : charSequence2.toString();
        return StrSpliter.split(charSequence.toString(), string, n2, bl, bl2);
    }

    public static String[] split(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == null) {
            return new String[0];
        }
        String string = null == charSequence2 ? null : charSequence2.toString();
        return StrSpliter.splitToArray(charSequence.toString(), string, 0, false, false);
    }

    public static String[] split(CharSequence charSequence, int n2) {
        if (null == charSequence) {
            return new String[0];
        }
        return StrSpliter.splitByLength(charSequence.toString(), n2);
    }

    public static String sub(CharSequence charSequence, int n2, int n3) {
        if (StrUtil.isEmpty(charSequence)) {
            return StrUtil.str(charSequence);
        }
        int n4 = charSequence.length();
        if (n2 < 0) {
            if ((n2 = n4 + n2) < 0) {
                n2 = 0;
            }
        } else if (n2 > n4) {
            n2 = n4;
        }
        if (n3 < 0) {
            if ((n3 = n4 + n3) < 0) {
                n3 = n4;
            }
        } else if (n3 > n4) {
            n3 = n4;
        }
        if (n3 < n2) {
            int n5 = n2;
            n2 = n3;
            n3 = n5;
        }
        if (n2 == n3) {
            return EMPTY;
        }
        return charSequence.toString().substring(n2, n3);
    }

    public static String subByCodePoint(CharSequence charSequence, int n3, int n4) {
        if (StrUtil.isEmpty(charSequence)) {
            return StrUtil.str(charSequence);
        }
        if (n3 < 0 || n3 > n4) {
            throw new IllegalArgumentException();
        }
        if (n3 == n4) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n5 = n4 - n3;
        charSequence.toString().codePoints().skip(n3).limit(n5).forEach(n2 -> stringBuilder.append(Character.toChars(n2)));
        return stringBuilder.toString();
    }

    public static String subPreGbk(CharSequence charSequence, int n2, CharSequence charSequence2) {
        if (StrUtil.isEmpty(charSequence)) {
            return StrUtil.str(charSequence);
        }
        int n3 = 0;
        byte[] byArray = charSequence.toString().getBytes(CharsetUtil.CHARSET_GBK);
        if (byArray.length <= n2) {
            return charSequence.toString();
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (byArray[i2] >= 0) continue;
            ++n3;
        }
        if (n3 % 2 != 0) {
            ++n2;
        }
        return new String(byArray, 0, n2, CharsetUtil.CHARSET_GBK) + charSequence2;
    }

    public static String maxLength(CharSequence charSequence, int n2) {
        Assert.isTrue(n2 > 0);
        if (null == charSequence) {
            return null;
        }
        if (charSequence.length() <= n2) {
            return charSequence.toString();
        }
        return StrUtil.sub(charSequence, 0, n2) + "...";
    }

    public static String subPre(CharSequence charSequence, int n2) {
        return StrUtil.sub(charSequence, 0, n2);
    }

    public static String subSuf(CharSequence charSequence, int n2) {
        if (StrUtil.isEmpty(charSequence)) {
            return null;
        }
        return StrUtil.sub(charSequence, n2, charSequence.length());
    }

    public static String subSufByLength(CharSequence charSequence, int n2) {
        if (StrUtil.isEmpty(charSequence)) {
            return null;
        }
        if (n2 <= 0) {
            return EMPTY;
        }
        return StrUtil.sub(charSequence, -n2, charSequence.length());
    }

    public static String subWithLength(String string, int n2, int n3) {
        return StrUtil.sub(string, n2, n2 + n3);
    }

    public static String subBefore(CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        int n2;
        if (StrUtil.isEmpty(charSequence) || charSequence2 == null) {
            return null == charSequence ? null : charSequence.toString();
        }
        String string = charSequence.toString();
        String string2 = charSequence2.toString();
        if (string2.isEmpty()) {
            return EMPTY;
        }
        int n3 = n2 = bl ? string.lastIndexOf(string2) : string.indexOf(string2);
        if (-1 == n2) {
            return string;
        }
        if (0 == n2) {
            return EMPTY;
        }
        return string.substring(0, n2);
    }

    public static String subBefore(CharSequence charSequence, char c2, boolean bl) {
        int n2;
        if (StrUtil.isEmpty(charSequence)) {
            return null == charSequence ? null : EMPTY;
        }
        String string = charSequence.toString();
        int n3 = n2 = bl ? string.lastIndexOf(c2) : string.indexOf(c2);
        if (-1 == n2) {
            return string;
        }
        if (0 == n2) {
            return EMPTY;
        }
        return string.substring(0, n2);
    }

    public static String subAfter(CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        int n2;
        if (StrUtil.isEmpty(charSequence)) {
            return null == charSequence ? null : EMPTY;
        }
        if (charSequence2 == null) {
            return EMPTY;
        }
        String string = charSequence.toString();
        String string2 = charSequence2.toString();
        int n3 = n2 = bl ? string.lastIndexOf(string2) : string.indexOf(string2);
        if (-1 == n2 || charSequence.length() - 1 == n2) {
            return EMPTY;
        }
        return string.substring(n2 + charSequence2.length());
    }

    public static String subAfter(CharSequence charSequence, char c2, boolean bl) {
        int n2;
        if (StrUtil.isEmpty(charSequence)) {
            return null == charSequence ? null : EMPTY;
        }
        String string = charSequence.toString();
        int n3 = n2 = bl ? string.lastIndexOf(c2) : string.indexOf(c2);
        if (-1 == n2) {
            return EMPTY;
        }
        return string.substring(n2 + 1);
    }

    public static String subBetween(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3) {
        int n2;
        if (charSequence == null || charSequence2 == null || charSequence3 == null) {
            return null;
        }
        String string = charSequence.toString();
        String string2 = charSequence2.toString();
        String string3 = charSequence3.toString();
        int n3 = string.indexOf(string2);
        if (n3 != -1 && (n2 = string.indexOf(string3, n3 + string2.length())) != -1) {
            return string.substring(n3 + string2.length(), n2);
        }
        return null;
    }

    public static String subBetween(CharSequence charSequence, CharSequence charSequence2) {
        return StrUtil.subBetween(charSequence, charSequence2, charSequence2);
    }

    public static String[] subBetweenAll(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3) {
        if (StrUtil.hasEmpty(charSequence, charSequence2, charSequence3) || !StrUtil.contains(charSequence, charSequence2)) {
            return new String[0];
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string : StrUtil.split(charSequence, charSequence2)) {
            int n2 = string.indexOf(charSequence3.toString());
            if (n2 <= 0) continue;
            linkedList.add(string.substring(0, n2));
        }
        return linkedList.toArray(new String[0]);
    }

    public static boolean isSurround(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3) {
        if (StrUtil.isBlank(charSequence)) {
            return false;
        }
        if (charSequence.length() < charSequence2.length() + charSequence3.length()) {
            return false;
        }
        String string = charSequence.toString();
        return string.startsWith(charSequence2.toString()) && string.endsWith(charSequence3.toString());
    }

    public static boolean isSurround(CharSequence charSequence, char c2, char c3) {
        if (StrUtil.isBlank(charSequence)) {
            return false;
        }
        if (charSequence.length() < 2) {
            return false;
        }
        return charSequence.charAt(0) == c2 && charSequence.charAt(charSequence.length() - 1) == c3;
    }

    public static String repeat(char c2, int n2) {
        if (n2 <= 0) {
            return EMPTY;
        }
        char[] cArray = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[i2] = c2;
        }
        return new String(cArray);
    }

    public static String repeat(CharSequence charSequence, int n2) {
        int n3;
        if (null == charSequence) {
            return null;
        }
        if (n2 <= 0 || charSequence.length() == 0) {
            return EMPTY;
        }
        if (n2 == 1) {
            return charSequence.toString();
        }
        int n4 = charSequence.length();
        long l2 = (long)n4 * (long)n2;
        int n5 = (int)l2;
        if ((long)n5 != l2) {
            throw new ArrayIndexOutOfBoundsException("Required String length is too large: " + l2);
        }
        char[] cArray = new char[n5];
        charSequence.toString().getChars(0, n4, cArray, 0);
        for (n3 = n4; n3 < n5 - n3; n3 <<= 1) {
            System.arraycopy(cArray, 0, cArray, n3, n3);
        }
        System.arraycopy(cArray, 0, cArray, n3, n5 - n3);
        return new String(cArray);
    }

    public static String repeatByLength(CharSequence charSequence, int n2) {
        if (null == charSequence) {
            return null;
        }
        if (n2 <= 0) {
            return EMPTY;
        }
        int n3 = charSequence.length();
        if (n3 == n2) {
            return charSequence.toString();
        }
        if (n3 > n2) {
            return StrUtil.subPre(charSequence, n2);
        }
        char[] cArray = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[i2] = charSequence.charAt(i2 % n3);
        }
        return new String(cArray);
    }

    public static String repeatAndJoin(CharSequence charSequence, int n2, CharSequence charSequence2) {
        if (n2 <= 0) {
            return EMPTY;
        }
        StrBuilder strBuilder = StrBuilder.create();
        boolean bl = true;
        while (n2-- > 0) {
            if (bl) {
                bl = false;
            } else if (StrUtil.isNotEmpty(charSequence2)) {
                strBuilder.append(charSequence2);
            }
            strBuilder.append(charSequence);
        }
        return strBuilder.toString();
    }

    public static boolean equals(CharSequence charSequence, CharSequence charSequence2) {
        return StrUtil.equals(charSequence, charSequence2, false);
    }

    public static boolean equalsIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        return StrUtil.equals(charSequence, charSequence2, true);
    }

    public static boolean equals(CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        if (null == charSequence) {
            return charSequence2 == null;
        }
        if (null == charSequence2) {
            return false;
        }
        if (bl) {
            return charSequence.toString().equalsIgnoreCase(charSequence2.toString());
        }
        return charSequence.toString().contentEquals(charSequence2);
    }

    public static boolean equalsAnyIgnoreCase(CharSequence charSequence, CharSequence ... charSequenceArray) {
        return StrUtil.equalsAny(charSequence, true, charSequenceArray);
    }

    public static boolean equalsAny(CharSequence charSequence, CharSequence ... charSequenceArray) {
        return StrUtil.equalsAny(charSequence, false, charSequenceArray);
    }

    public static boolean equalsAny(CharSequence charSequence, boolean bl, CharSequence ... charSequenceArray) {
        if (ArrayUtil.isEmpty(charSequenceArray)) {
            return false;
        }
        for (CharSequence charSequence2 : charSequenceArray) {
            if (!StrUtil.equals(charSequence, charSequence2, bl)) continue;
            return true;
        }
        return false;
    }

    public static String format(CharSequence charSequence, Object ... objectArray) {
        if (null == charSequence) {
            return NULL;
        }
        if (ArrayUtil.isEmpty(objectArray) || StrUtil.isBlank(charSequence)) {
            return charSequence.toString();
        }
        return StrFormatter.format(charSequence.toString(), objectArray);
    }

    public static String indexedFormat(CharSequence charSequence, Object ... objectArray) {
        return MessageFormat.format(charSequence.toString(), objectArray);
    }

    public static String format(CharSequence charSequence, Map map) {
        return StrUtil.format(charSequence, map, true);
    }

    public static String format(CharSequence charSequence, Map map, boolean bl) {
        if (null == charSequence) {
            return null;
        }
        if (null == map || map.isEmpty()) {
            return charSequence.toString();
        }
        String string = charSequence.toString();
        for (Map.Entry entry : map.entrySet()) {
            String string2 = StrUtil.utf8Str(entry.getValue());
            if (null == string2 && bl) continue;
            string = StrUtil.replace((CharSequence)string, (CharSequence)(DELIM_START + entry.getKey() + DELIM_END), string2);
        }
        return string;
    }

    public static byte[] utf8Bytes(CharSequence charSequence) {
        return StrUtil.bytes(charSequence, CharsetUtil.CHARSET_UTF_8);
    }

    public static byte[] bytes(CharSequence charSequence) {
        return StrUtil.bytes(charSequence, Charset.defaultCharset());
    }

    public static byte[] bytes(CharSequence charSequence, String string) {
        return StrUtil.bytes(charSequence, StrUtil.isBlank(string) ? Charset.defaultCharset() : Charset.forName(string));
    }

    public static byte[] bytes(CharSequence charSequence, Charset charset) {
        if (charSequence == null) {
            return null;
        }
        if (null == charset) {
            return charSequence.toString().getBytes();
        }
        return charSequence.toString().getBytes(charset);
    }

    public static String utf8Str(Object object) {
        return StrUtil.str(object, CharsetUtil.CHARSET_UTF_8);
    }

    public static String str(Object object, String string) {
        return StrUtil.str(object, Charset.forName(string));
    }

    public static String str(Object object, Charset charset) {
        if (null == object) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof byte[]) {
            return StrUtil.str((byte[])object, charset);
        }
        if (object instanceof Byte[]) {
            return StrUtil.str((Byte[])object, charset);
        }
        if (object instanceof ByteBuffer) {
            return StrUtil.str((ByteBuffer)object, charset);
        }
        if (ArrayUtil.isArray(object)) {
            return ArrayUtil.toString(object);
        }
        return object.toString();
    }

    public static String str(byte[] byArray, String string) {
        return StrUtil.str(byArray, StrUtil.isBlank(string) ? Charset.defaultCharset() : Charset.forName(string));
    }

    public static String str(byte[] byArray, Charset charset) {
        if (byArray == null) {
            return null;
        }
        if (null == charset) {
            return new String(byArray);
        }
        return new String(byArray, charset);
    }

    public static String str(Byte[] byteArray, String string) {
        return StrUtil.str(byteArray, StrUtil.isBlank(string) ? Charset.defaultCharset() : Charset.forName(string));
    }

    public static String str(Byte[] byteArray, Charset charset) {
        if (byteArray == null) {
            return null;
        }
        byte[] byArray = new byte[byteArray.length];
        for (int i2 = 0; i2 < byteArray.length; ++i2) {
            Byte by = byteArray[i2];
            byArray[i2] = null == by ? -1 : (int)by.byteValue();
        }
        return StrUtil.str(byArray, charset);
    }

    public static String str(ByteBuffer byteBuffer, String string) {
        if (byteBuffer == null) {
            return null;
        }
        return StrUtil.str(byteBuffer, Charset.forName(string));
    }

    public static String str(ByteBuffer byteBuffer, Charset charset) {
        if (null == charset) {
            charset = Charset.defaultCharset();
        }
        return charset.decode(byteBuffer).toString();
    }

    public static String str(CharSequence charSequence) {
        return null == charSequence ? null : charSequence.toString();
    }

    public static String toString(Object object) {
        return null == object ? NULL : object.toString();
    }

    public static ByteBuffer byteBuffer(CharSequence charSequence, String string) {
        return ByteBuffer.wrap(StrUtil.bytes(charSequence, string));
    }

    public static String join(CharSequence charSequence, Object ... objectArray) {
        return ArrayUtil.join(objectArray, charSequence);
    }

    public static String toUnderlineCase(CharSequence charSequence) {
        return StrUtil.toSymbolCase(charSequence, '_');
    }

    public static String toSymbolCase(CharSequence charSequence, char c2) {
        if (charSequence == null) {
            return null;
        }
        int n2 = charSequence.length();
        StrBuilder strBuilder = new StrBuilder();
        for (int i2 = 0; i2 < n2; ++i2) {
            Character c3;
            char c4 = charSequence.charAt(i2);
            Character c5 = c3 = i2 > 0 ? Character.valueOf(charSequence.charAt(i2 - 1)) : null;
            if (Character.isUpperCase(c4)) {
                Character c6;
                Character c7 = c6 = i2 < charSequence.length() - 1 ? Character.valueOf(charSequence.charAt(i2 + 1)) : null;
                if (null != c3 && Character.isUpperCase(c3.charValue())) {
                    strBuilder.append(c4);
                    continue;
                }
                if (null != c6 && !Character.isLowerCase(c6.charValue())) {
                    if (null != c3 && c2 != c3.charValue()) {
                        strBuilder.append(c2);
                    }
                    strBuilder.append(c4);
                    continue;
                }
                if (null != c3 && c2 != c3.charValue()) {
                    strBuilder.append(c2);
                }
                strBuilder.append(Character.toLowerCase(c4));
                continue;
            }
            if (c2 != c4 && strBuilder.length() > 0 && Character.isUpperCase(strBuilder.charAt(-1)) && Character.isLowerCase(c4)) {
                strBuilder.append(c2);
            }
            strBuilder.append(c4);
        }
        return strBuilder.toString();
    }

    public static String toCamelCase(CharSequence charSequence) {
        if (null == charSequence) {
            return null;
        }
        String string = charSequence.toString();
        if (string.contains(UNDERLINE)) {
            StringBuilder stringBuilder = new StringBuilder(string.length());
            boolean bl = false;
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                if (c2 == '_') {
                    bl = true;
                    continue;
                }
                if (bl) {
                    stringBuilder.append(Character.toUpperCase(c2));
                    bl = false;
                    continue;
                }
                stringBuilder.append(Character.toLowerCase(c2));
            }
            return stringBuilder.toString();
        }
        return string;
    }

    public static String wrap(CharSequence charSequence, CharSequence charSequence2) {
        return StrUtil.wrap(charSequence, charSequence2, charSequence2);
    }

    public static String wrap(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3) {
        return StrUtil.nullToEmpty(charSequence2).concat(StrUtil.nullToEmpty(charSequence)).concat(StrUtil.nullToEmpty(charSequence3));
    }

    public static String[] wrapAllWithPair(CharSequence charSequence, CharSequence ... charSequenceArray) {
        return StrUtil.wrapAll(charSequence, charSequence, charSequenceArray);
    }

    public static String[] wrapAll(CharSequence charSequence, CharSequence charSequence2, CharSequence ... charSequenceArray) {
        String[] stringArray = new String[charSequenceArray.length];
        for (int i2 = 0; i2 < charSequenceArray.length; ++i2) {
            stringArray[i2] = StrUtil.wrap(charSequenceArray[i2], charSequence, charSequence2);
        }
        return stringArray;
    }

    public static String wrapIfMissing(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3) {
        int n2 = 0;
        if (StrUtil.isNotEmpty(charSequence)) {
            n2 += charSequence.length();
        }
        if (StrUtil.isNotEmpty(charSequence2)) {
            n2 += charSequence.length();
        }
        if (StrUtil.isNotEmpty(charSequence3)) {
            n2 += charSequence.length();
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        if (StrUtil.isNotEmpty(charSequence2) && !StrUtil.startWith(charSequence, charSequence2)) {
            stringBuilder.append(charSequence2);
        }
        if (StrUtil.isNotEmpty(charSequence)) {
            stringBuilder.append(charSequence);
        }
        if (StrUtil.isNotEmpty(charSequence3) && !StrUtil.endWith(charSequence, charSequence3)) {
            stringBuilder.append(charSequence3);
        }
        return stringBuilder.toString();
    }

    public static String[] wrapAllWithPairIfMissing(CharSequence charSequence, CharSequence ... charSequenceArray) {
        return StrUtil.wrapAllIfMissing(charSequence, charSequence, charSequenceArray);
    }

    public static String[] wrapAllIfMissing(CharSequence charSequence, CharSequence charSequence2, CharSequence ... charSequenceArray) {
        String[] stringArray = new String[charSequenceArray.length];
        for (int i2 = 0; i2 < charSequenceArray.length; ++i2) {
            stringArray[i2] = StrUtil.wrapIfMissing(charSequenceArray[i2], charSequence, charSequence2);
        }
        return stringArray;
    }

    public static String unWrap(CharSequence charSequence, String string, String string2) {
        if (StrUtil.isWrap(charSequence, string, string2)) {
            return StrUtil.sub(charSequence, string.length(), charSequence.length() - string2.length());
        }
        return charSequence.toString();
    }

    public static String unWrap(CharSequence charSequence, char c2, char c3) {
        if (StrUtil.isEmpty(charSequence)) {
            return StrUtil.str(charSequence);
        }
        if (charSequence.charAt(0) == c2 && charSequence.charAt(charSequence.length() - 1) == c3) {
            return StrUtil.sub(charSequence, 1, charSequence.length() - 1);
        }
        return charSequence.toString();
    }

    public static String unWrap(CharSequence charSequence, char c2) {
        return StrUtil.unWrap(charSequence, c2, c2);
    }

    public static boolean isWrap(CharSequence charSequence, String string, String string2) {
        if (ArrayUtil.hasNull(charSequence, string, string2)) {
            return false;
        }
        String string3 = charSequence.toString();
        return string3.startsWith(string) && string3.endsWith(string2);
    }

    public static boolean isWrap(CharSequence charSequence, String string) {
        return StrUtil.isWrap(charSequence, string, string);
    }

    public static boolean isWrap(CharSequence charSequence, char c2) {
        return StrUtil.isWrap(charSequence, c2, c2);
    }

    public static boolean isWrap(CharSequence charSequence, char c2, char c3) {
        if (null == charSequence) {
            return false;
        }
        return charSequence.charAt(0) == c2 && charSequence.charAt(charSequence.length() - 1) == c3;
    }

    public static String padPre(CharSequence charSequence, int n2, CharSequence charSequence2) {
        if (null == charSequence) {
            return null;
        }
        int n3 = charSequence.length();
        if (n3 == n2) {
            return charSequence.toString();
        }
        if (n3 > n2) {
            return StrUtil.subPre(charSequence, n2);
        }
        return StrUtil.repeatByLength(charSequence2, n2 - n3).concat(charSequence.toString());
    }

    public static String padPre(CharSequence charSequence, int n2, char c2) {
        if (null == charSequence) {
            return null;
        }
        int n3 = charSequence.length();
        if (n3 == n2) {
            return charSequence.toString();
        }
        if (n3 > n2) {
            return StrUtil.subPre(charSequence, n2);
        }
        return StrUtil.repeat(c2, n2 - n3).concat(charSequence.toString());
    }

    public static String padAfter(CharSequence charSequence, int n2, char c2) {
        if (null == charSequence) {
            return null;
        }
        int n3 = charSequence.length();
        if (n3 == n2) {
            return charSequence.toString();
        }
        if (n3 > n2) {
            return StrUtil.sub(charSequence, n3 - n2, n3);
        }
        return charSequence.toString().concat(StrUtil.repeat(c2, n2 - n3));
    }

    public static String padAfter(CharSequence charSequence, int n2, CharSequence charSequence2) {
        if (null == charSequence) {
            return null;
        }
        int n3 = charSequence.length();
        if (n3 == n2) {
            return charSequence.toString();
        }
        if (n3 > n2) {
            return StrUtil.subSufByLength(charSequence, n2);
        }
        return charSequence.toString().concat(StrUtil.repeatByLength(charSequence2, n2 - n3));
    }

    public static String center(CharSequence charSequence, int n2) {
        return StrUtil.center(charSequence, n2, ' ');
    }

    public static String center(CharSequence charSequence, int n2, char c2) {
        if (charSequence == null || n2 <= 0) {
            return StrUtil.str(charSequence);
        }
        int n3 = charSequence.length();
        int n4 = n2 - n3;
        if (n4 <= 0) {
            return charSequence.toString();
        }
        charSequence = StrUtil.padPre(charSequence, n3 + n4 / 2, c2);
        charSequence = StrUtil.padAfter(charSequence, n2, c2);
        return charSequence.toString();
    }

    public static String center(CharSequence charSequence, int n2, CharSequence charSequence2) {
        int n3;
        int n4;
        if (charSequence == null || n2 <= 0) {
            return StrUtil.str(charSequence);
        }
        if (StrUtil.isEmpty(charSequence2)) {
            charSequence2 = SPACE;
        }
        if ((n4 = n2 - (n3 = charSequence.length())) <= 0) {
            return charSequence.toString();
        }
        charSequence = StrUtil.padPre(charSequence, n3 + n4 / 2, charSequence2);
        charSequence = StrUtil.padAfter(charSequence, n2, charSequence2);
        return charSequence.toString();
    }

    public static StringBuilder builder() {
        return new StringBuilder();
    }

    public static StrBuilder strBuilder() {
        return StrBuilder.create();
    }

    public static StringBuilder builder(int n2) {
        return new StringBuilder(n2);
    }

    public static StrBuilder strBuilder(int n2) {
        return StrBuilder.create(n2);
    }

    public static StringBuilder builder(CharSequence ... charSequenceArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (CharSequence charSequence : charSequenceArray) {
            stringBuilder.append(charSequence);
        }
        return stringBuilder;
    }

    public static StrBuilder strBuilder(CharSequence ... charSequenceArray) {
        return StrBuilder.create(charSequenceArray);
    }

    public static StringReader getReader(CharSequence charSequence) {
        if (null == charSequence) {
            return null;
        }
        return new StringReader(charSequence.toString());
    }

    public static StringWriter getWriter() {
        return new StringWriter();
    }

    public static int count(CharSequence charSequence, CharSequence charSequence2) {
        if (StrUtil.hasEmpty(charSequence, charSequence2) || charSequence2.length() > charSequence.length()) {
            return 0;
        }
        int n2 = 0;
        int n3 = 0;
        String string = charSequence.toString();
        String string2 = charSequence2.toString();
        while ((n3 = string.indexOf(string2, n3)) > -1) {
            ++n2;
            n3 += charSequence2.length();
        }
        return n2;
    }

    public static int count(CharSequence charSequence, char c2) {
        int n2 = 0;
        if (StrUtil.isEmpty(charSequence)) {
            return 0;
        }
        int n3 = charSequence.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (c2 != charSequence.charAt(i2)) continue;
            ++n2;
        }
        return n2;
    }

    public static String[] cut(CharSequence charSequence, int n2) {
        if (null == charSequence) {
            return null;
        }
        int n3 = charSequence.length();
        if (n3 < n2) {
            return new String[]{charSequence.toString()};
        }
        int n4 = NumberUtil.count(n3, n2);
        String[] stringArray = new String[n4];
        String string = charSequence.toString();
        for (int i2 = 0; i2 < n4; ++i2) {
            stringArray[i2] = string.substring(i2 * n2, i2 == n4 - 1 ? n3 : n2 + i2 * n2);
        }
        return stringArray;
    }

    public static String brief(CharSequence charSequence, int n2) {
        if (null == charSequence) {
            return null;
        }
        if (charSequence.length() <= n2) {
            return charSequence.toString();
        }
        int n3 = n2 / 2;
        int n4 = charSequence.length() + 3;
        String string = charSequence.toString();
        return StrUtil.format((CharSequence)"{}...{}", string.substring(0, n2 - n3), string.substring(n4 - n3));
    }

    public static int compare(CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        if (charSequence == charSequence2) {
            return 0;
        }
        if (charSequence == null) {
            return bl ? -1 : 1;
        }
        if (charSequence2 == null) {
            return bl ? 1 : -1;
        }
        return charSequence.toString().compareTo(charSequence2.toString());
    }

    public static int compareIgnoreCase(CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        if (charSequence == charSequence2) {
            return 0;
        }
        if (charSequence == null) {
            return bl ? -1 : 1;
        }
        if (charSequence2 == null) {
            return bl ? 1 : -1;
        }
        return charSequence.toString().compareToIgnoreCase(charSequence2.toString());
    }

    public static int compareVersion(CharSequence charSequence, CharSequence charSequence2) {
        return VersionComparator.INSTANCE.compare(StrUtil.str(charSequence), StrUtil.str(charSequence2));
    }

    public static int indexOf(CharSequence charSequence, char c2) {
        return StrUtil.indexOf(charSequence, c2, 0);
    }

    public static int indexOf(CharSequence charSequence, char c2, int n2) {
        if (charSequence instanceof String) {
            return ((String)charSequence).indexOf(c2, n2);
        }
        return StrUtil.indexOf(charSequence, c2, n2, -1);
    }

    public static int indexOf(CharSequence charSequence, char c2, int n2, int n3) {
        if (StrUtil.isEmpty(charSequence)) {
            return -1;
        }
        int n4 = charSequence.length();
        if (n2 < 0 || n2 > n4) {
            n2 = 0;
        }
        if (n3 > n4 || n3 < 0) {
            n3 = n4;
        }
        for (int i2 = n2; i2 < n3; ++i2) {
            if (charSequence.charAt(i2) != c2) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        return StrUtil.indexOfIgnoreCase(charSequence, charSequence2, 0);
    }

    public static int indexOfIgnoreCase(CharSequence charSequence, CharSequence charSequence2, int n2) {
        return StrUtil.indexOf(charSequence, charSequence2, n2, true);
    }

    public static int indexOf(CharSequence charSequence, CharSequence charSequence2, int n2, boolean bl) {
        int n3;
        if (charSequence == null || charSequence2 == null) {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > (n3 = charSequence.length() - charSequence2.length() + 1)) {
            return -1;
        }
        if (charSequence2.length() == 0) {
            return n2;
        }
        if (!bl) {
            return charSequence.toString().indexOf(charSequence2.toString(), n2);
        }
        for (int i2 = n2; i2 < n3; ++i2) {
            if (!StrUtil.isSubEquals(charSequence, i2, charSequence2, 0, charSequence2.length(), true)) continue;
            return i2;
        }
        return -1;
    }

    public static int lastIndexOfIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        return StrUtil.lastIndexOfIgnoreCase(charSequence, charSequence2, charSequence.length());
    }

    public static int lastIndexOfIgnoreCase(CharSequence charSequence, CharSequence charSequence2, int n2) {
        return StrUtil.lastIndexOf(charSequence, charSequence2, n2, true);
    }

    public static int lastIndexOf(CharSequence charSequence, CharSequence charSequence2, int n2, boolean bl) {
        if (charSequence == null || charSequence2 == null) {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        n2 = Math.min(n2, charSequence.length());
        if (charSequence2.length() == 0) {
            return n2;
        }
        if (!bl) {
            return charSequence.toString().lastIndexOf(charSequence2.toString(), n2);
        }
        for (int i2 = n2; i2 > 0; --i2) {
            if (!StrUtil.isSubEquals(charSequence, i2, charSequence2, 0, charSequence2.length(), true)) continue;
            return i2;
        }
        return -1;
    }

    public static int ordinalIndexOf(String string, String string2, int n2) {
        if (string == null || string2 == null || n2 <= 0) {
            return -1;
        }
        if (string2.length() == 0) {
            return 0;
        }
        int n3 = 0;
        int n4 = -1;
        do {
            if ((n4 = string.indexOf(string2, n4 + 1)) >= 0) continue;
            return n4;
        } while (++n3 < n2);
        return n4;
    }

    public static String appendIfMissing(CharSequence charSequence, CharSequence charSequence2, CharSequence ... charSequenceArray) {
        return StrUtil.appendIfMissing(charSequence, charSequence2, false, charSequenceArray);
    }

    public static String appendIfMissingIgnoreCase(CharSequence charSequence, CharSequence charSequence2, CharSequence ... charSequenceArray) {
        return StrUtil.appendIfMissing(charSequence, charSequence2, true, charSequenceArray);
    }

    public static String appendIfMissing(CharSequence charSequence, CharSequence charSequence2, boolean bl, CharSequence ... charSequenceArray) {
        if (charSequence == null || StrUtil.isEmpty(charSequence2) || StrUtil.endWith(charSequence, charSequence2, bl)) {
            return StrUtil.str(charSequence);
        }
        if (charSequenceArray != null && charSequenceArray.length > 0) {
            for (CharSequence charSequence3 : charSequenceArray) {
                if (!StrUtil.endWith(charSequence, charSequence3, bl)) continue;
                return charSequence.toString();
            }
        }
        return charSequence.toString().concat(charSequence2.toString());
    }

    public static String prependIfMissing(CharSequence charSequence, CharSequence charSequence2, CharSequence ... charSequenceArray) {
        return StrUtil.prependIfMissing(charSequence, charSequence2, false, charSequenceArray);
    }

    public static String prependIfMissingIgnoreCase(CharSequence charSequence, CharSequence charSequence2, CharSequence ... charSequenceArray) {
        return StrUtil.prependIfMissing(charSequence, charSequence2, true, charSequenceArray);
    }

    public static String prependIfMissing(CharSequence charSequence, CharSequence charSequence2, boolean bl, CharSequence ... charSequenceArray) {
        if (charSequence == null || StrUtil.isEmpty(charSequence2) || StrUtil.startWith(charSequence, charSequence2, bl)) {
            return StrUtil.str(charSequence);
        }
        if (charSequenceArray != null && charSequenceArray.length > 0) {
            for (CharSequence charSequence3 : charSequenceArray) {
                if (!StrUtil.startWith(charSequence, charSequence3, bl)) continue;
                return charSequence.toString();
            }
        }
        return charSequence2.toString().concat(charSequence.toString());
    }

    public static String reverse(String string) {
        return new String(ArrayUtil.reverse(string.toCharArray()));
    }

    public static String fillBefore(String string, char c2, int n2) {
        return StrUtil.fill(string, c2, n2, true);
    }

    public static String fillAfter(String string, char c2, int n2) {
        return StrUtil.fill(string, c2, n2, false);
    }

    public static String fill(String string, char c2, int n2, boolean bl) {
        int n3 = string.length();
        if (n3 > n2) {
            return string;
        }
        String string2 = StrUtil.repeat(c2, n2 - n3);
        return bl ? string2.concat(string) : string.concat(string2);
    }

    public static boolean isSubEquals(CharSequence charSequence, int n2, CharSequence charSequence2, int n3, int n4, boolean bl) {
        if (null == charSequence || null == charSequence2) {
            return false;
        }
        return charSequence.toString().regionMatches(bl, n2, charSequence2.toString(), n3, n4);
    }

    public static boolean isAllCharMatch(CharSequence charSequence, Matcher matcher) {
        if (StrUtil.isBlank(charSequence)) {
            return false;
        }
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (matcher.match(Character.valueOf(charSequence.charAt(i2)))) continue;
            return false;
        }
        return true;
    }

    public static String replaceIgnoreCase(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3) {
        return StrUtil.replace(charSequence, 0, charSequence2, charSequence3, true);
    }

    public static String replace(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3) {
        return StrUtil.replace(charSequence, 0, charSequence2, charSequence3, false);
    }

    public static String replace(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3, boolean bl) {
        return StrUtil.replace(charSequence, 0, charSequence2, charSequence3, bl);
    }

    public static String replace(CharSequence charSequence, int n2, CharSequence charSequence2, CharSequence charSequence3, boolean bl) {
        int n3;
        if (StrUtil.isEmpty(charSequence) || StrUtil.isEmpty(charSequence2)) {
            return StrUtil.str(charSequence);
        }
        if (null == charSequence3) {
            charSequence3 = EMPTY;
        }
        int n4 = charSequence.length();
        int n5 = charSequence2.length();
        if (n2 > n4) {
            return StrUtil.str(charSequence);
        }
        if (n2 < 0) {
            n2 = 0;
        }
        StrBuilder strBuilder = StrBuilder.create(n4 + 16);
        if (0 != n2) {
            strBuilder.append(charSequence.subSequence(0, n2));
        }
        int n6 = n2;
        while ((n3 = StrUtil.indexOf(charSequence, charSequence2, n6, bl)) > -1) {
            strBuilder.append(charSequence.subSequence(n6, n3));
            strBuilder.append(charSequence3);
            n6 = n3 + n5;
        }
        if (n6 < n4) {
            strBuilder.append(charSequence.subSequence(n6, n4));
        }
        return strBuilder.toString();
    }

    public static String replace(CharSequence charSequence, int n2, int n3, char c2) {
        if (StrUtil.isEmpty(charSequence)) {
            return StrUtil.str(charSequence);
        }
        int n4 = charSequence.length();
        if (n2 > n4) {
            return StrUtil.str(charSequence);
        }
        if (n3 > n4) {
            n3 = n4;
        }
        if (n2 > n3) {
            return StrUtil.str(charSequence);
        }
        char[] cArray = new char[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            cArray[i2] = i2 >= n2 && i2 < n3 ? c2 : charSequence.charAt(i2);
        }
        return new String(cArray);
    }

    public static String replace(CharSequence charSequence, Pattern pattern, Func1 func1) {
        return ReUtil.replaceAll(charSequence, pattern, func1);
    }

    public static String replace(CharSequence charSequence, String string, Func1 func1) {
        return ReUtil.replaceAll(charSequence, string, func1);
    }

    public static String hide(CharSequence charSequence, int n2, int n3) {
        return StrUtil.replace(charSequence, n2, n3, '*');
    }

    public static String replaceChars(CharSequence charSequence, String string, CharSequence charSequence2) {
        if (StrUtil.isEmpty(charSequence) || StrUtil.isEmpty(string)) {
            return StrUtil.str(charSequence);
        }
        return StrUtil.replaceChars(charSequence, string.toCharArray(), charSequence2);
    }

    /*
     * WARNING - void declaration
     */
    public static String replaceChars(CharSequence charSequence, char[] cArray, CharSequence charSequence2) {
        void var7_11;
        if (StrUtil.isEmpty(charSequence) || ArrayUtil.isEmpty(cArray)) {
            return StrUtil.str(charSequence);
        }
        HashSet<Character> hashSet = new HashSet<Character>(cArray.length);
        for (char n2 : cArray) {
            hashSet.add(Character.valueOf(n2));
        }
        int n3 = charSequence.length();
        StringBuilder stringBuilder = StrUtil.builder();
        boolean bl = false;
        while (var7_11 < n3) {
            int n4 = charSequence.charAt((int)var7_11);
            stringBuilder.append(hashSet.contains(Character.valueOf((char)n4)) ? charSequence2 : Character.valueOf((char)n4));
            ++var7_11;
        }
        return stringBuilder.toString();
    }

    public static double similar(String string, String string2) {
        return TextSimilarity.similar(string, string2);
    }

    public static String similar(String string, String string2, int n2) {
        return TextSimilarity.similar(string, string2, n2);
    }

    public static boolean equalsCharAt(CharSequence charSequence, int n2, char c2) {
        if (null == charSequence || n2 < 0) {
            return false;
        }
        return charSequence.length() > n2 && c2 == charSequence.charAt(n2);
    }

    public static int totalLength(CharSequence ... charSequenceArray) {
        int n2 = 0;
        for (CharSequence charSequence : charSequenceArray) {
            n2 += null == charSequence ? 0 : charSequence.length();
        }
        return n2;
    }

    public static String move(CharSequence charSequence, int n2, int n3, int n4) {
        if (StrUtil.isEmpty(charSequence)) {
            return StrUtil.str(charSequence);
        }
        int n5 = charSequence.length();
        if (Math.abs(n4) > n5) {
            n4 %= n5;
        }
        StrBuilder strBuilder = StrBuilder.create(n5);
        if (n4 > 0) {
            int n6 = Math.min(n3 + n4, charSequence.length());
            strBuilder.append(charSequence.subSequence(0, n2)).append(charSequence.subSequence(n3, n6)).append(charSequence.subSequence(n2, n3)).append(charSequence.subSequence(n6, charSequence.length()));
        } else if (n4 < 0) {
            int n7 = Math.max(n2 + n4, 0);
            strBuilder.append(charSequence.subSequence(0, n7)).append(charSequence.subSequence(n2, n3)).append(charSequence.subSequence(n7, n2)).append(charSequence.subSequence(n3, charSequence.length()));
        } else {
            return StrUtil.str(charSequence);
        }
        return strBuilder.toString();
    }

    public static String uuid() {
        return IdUtil.randomUUID();
    }

    public static String concat(boolean bl, CharSequence ... charSequenceArray) {
        StrBuilder strBuilder = new StrBuilder();
        for (CharSequence charSequence : charSequenceArray) {
            strBuilder.append(bl ? StrUtil.nullToEmpty(charSequence) : charSequence);
        }
        return strBuilder.toString();
    }

    public static boolean isUpperCase(CharSequence charSequence) {
        if (null == charSequence) {
            return false;
        }
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!Character.isLowerCase(charSequence.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isLowerCase(CharSequence charSequence) {
        if (null == charSequence) {
            return false;
        }
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!Character.isUpperCase(charSequence.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static int length(CharSequence charSequence) {
        return charSequence == null ? 0 : charSequence.length();
    }

    public static int byteLength(CharSequence charSequence, Charset charset) {
        return charSequence == null ? 0 : charSequence.toString().getBytes(charset).length;
    }

    public static String swapCase(String string) {
        if (StrUtil.isEmpty(string)) {
            return string;
        }
        char[] cArray = string.toCharArray();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            char c2 = cArray[i2];
            if (Character.isUpperCase(c2)) {
                cArray[i2] = Character.toLowerCase(c2);
                continue;
            }
            if (Character.isTitleCase(c2)) {
                cArray[i2] = Character.toLowerCase(c2);
                continue;
            }
            if (!Character.isLowerCase(c2)) continue;
            cArray[i2] = Character.toUpperCase(c2);
        }
        return new String(cArray);
    }

    public static String filter(CharSequence charSequence, Filter filter) {
        if (charSequence == null || filter == null) {
            return StrUtil.str(charSequence);
        }
        int n2 = charSequence.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (!filter.accept(Character.valueOf(c2))) continue;
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public CharSequence firstNonNull(CharSequence ... charSequenceArray) {
        return (CharSequence)ArrayUtil.firstNonNull(charSequenceArray);
    }

    public CharSequence firstNonEmpty(CharSequence ... charSequenceArray) {
        return (CharSequence)ArrayUtil.firstMatch(StrUtil::isNotEmpty, charSequenceArray);
    }

    public CharSequence firstNonBlank(CharSequence ... charSequenceArray) {
        return (CharSequence)ArrayUtil.firstMatch(StrUtil::isNotBlank, charSequenceArray);
    }
}

