/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.util;

import com.ccb.core.collection.CollUtil;
import com.ccb.core.convert.Convert;
import com.ccb.core.exceptions.UtilException;
import com.ccb.core.lang.Holder;
import com.ccb.core.lang.PatternPool;
import com.ccb.core.lang.func.Func1;
import com.ccb.core.util.ObjectUtil;
import com.ccb.core.util.StrUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReUtil {
    public static final String RE_CHINESE = "[\u4e00-\u9fff]";
    public static final String RE_CHINESES = "[\u4e00-\u9fff]+";
    public static final Set RE_KEYS = CollUtil.newHashSet(Character.valueOf('$'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf('.'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('?'), Character.valueOf('\\'), Character.valueOf('^'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('|'));

    public static String getGroup0(String string, CharSequence charSequence) {
        return ReUtil.get(string, charSequence, 0);
    }

    public static String getGroup1(String string, CharSequence charSequence) {
        return ReUtil.get(string, charSequence, 1);
    }

    public static String get(String string, CharSequence charSequence, int n2) {
        if (null == charSequence || null == string) {
            return null;
        }
        Pattern pattern = PatternPool.get(string, 32);
        return ReUtil.get(pattern, charSequence, n2);
    }

    public static String getGroup0(Pattern pattern, CharSequence charSequence) {
        return ReUtil.get(pattern, charSequence, 0);
    }

    public static String getGroup1(Pattern pattern, CharSequence charSequence) {
        return ReUtil.get(pattern, charSequence, 1);
    }

    public static String get(Pattern pattern, CharSequence charSequence, int n2) {
        if (null == charSequence || null == pattern) {
            return null;
        }
        Matcher matcher = pattern.matcher(charSequence);
        if (matcher.find()) {
            return matcher.group(n2);
        }
        return null;
    }

    public static List getAllGroups(Pattern pattern, CharSequence charSequence) {
        return ReUtil.getAllGroups(pattern, charSequence, true);
    }

    public static List getAllGroups(Pattern pattern, CharSequence charSequence, boolean bl) {
        if (null == charSequence || null == pattern) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Matcher matcher = pattern.matcher(charSequence);
        if (matcher.find()) {
            int n2 = bl ? 0 : 1;
            int n3 = matcher.groupCount();
            for (int i2 = n2; i2 <= n3; ++i2) {
                arrayList.add(matcher.group(i2));
            }
        }
        return arrayList;
    }

    public static String extractMulti(Pattern pattern, CharSequence charSequence, String string) {
        if (null == charSequence || null == pattern || null == string) {
            return null;
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>((n2, n3) -> ObjectUtil.compare(n3, n2));
        Matcher matcher = PatternPool.GROUP_VAR.matcher(string);
        while (matcher.find()) {
            treeSet.add(Integer.parseInt(matcher.group(1)));
        }
        Matcher matcher2 = pattern.matcher(charSequence);
        if (matcher2.find()) {
            for (Integer n4 : treeSet) {
                string = string.replace("$" + n4, matcher2.group(n4));
            }
            return string;
        }
        return null;
    }

    public static String extractMulti(String string, CharSequence charSequence, String string2) {
        if (null == charSequence || null == string || null == string2) {
            return null;
        }
        Pattern pattern = PatternPool.get(string, 32);
        return ReUtil.extractMulti(pattern, charSequence, string2);
    }

    public static String extractMultiAndDelPre(Pattern pattern, Holder holder, String string) {
        if (null == holder || null == pattern || null == string) {
            return null;
        }
        HashSet hashSet = (HashSet)ReUtil.findAll(PatternPool.GROUP_VAR, (CharSequence)string, 1, new HashSet());
        CharSequence charSequence = (CharSequence)holder.get();
        Matcher matcher = pattern.matcher(charSequence);
        if (matcher.find()) {
            for (String string2 : hashSet) {
                int n2 = Integer.parseInt(string2);
                string = string.replace("$" + string2, matcher.group(n2));
            }
            holder.set(StrUtil.sub(charSequence, matcher.end(), charSequence.length()));
            return string;
        }
        return null;
    }

    public static String extractMultiAndDelPre(String string, Holder holder, String string2) {
        if (null == holder || null == string || null == string2) {
            return null;
        }
        Pattern pattern = PatternPool.get(string, 32);
        return ReUtil.extractMultiAndDelPre(pattern, holder, string2);
    }

    public static String delFirst(String string, CharSequence charSequence) {
        if (StrUtil.hasBlank(string, charSequence)) {
            return StrUtil.str(charSequence);
        }
        Pattern pattern = PatternPool.get(string, 32);
        return ReUtil.delFirst(pattern, charSequence);
    }

    public static String delFirst(Pattern pattern, CharSequence charSequence) {
        if (null == pattern || StrUtil.isBlank(charSequence)) {
            return StrUtil.str(charSequence);
        }
        return pattern.matcher(charSequence).replaceFirst("");
    }

    public static String delAll(String string, CharSequence charSequence) {
        if (StrUtil.hasBlank(string, charSequence)) {
            return StrUtil.str(charSequence);
        }
        Pattern pattern = PatternPool.get(string, 32);
        return ReUtil.delAll(pattern, charSequence);
    }

    public static String delAll(Pattern pattern, CharSequence charSequence) {
        if (null == pattern || StrUtil.isBlank(charSequence)) {
            return StrUtil.str(charSequence);
        }
        return pattern.matcher(charSequence).replaceAll("");
    }

    public static String delPre(String string, CharSequence charSequence) {
        if (null == charSequence || null == string) {
            return StrUtil.str(charSequence);
        }
        Pattern pattern = PatternPool.get(string, 32);
        Matcher matcher = pattern.matcher(charSequence);
        if (matcher.find()) {
            return StrUtil.sub(charSequence, matcher.end(), charSequence.length());
        }
        return StrUtil.str(charSequence);
    }

    public static List findAllGroup0(String string, CharSequence charSequence) {
        return ReUtil.findAll(string, charSequence, 0);
    }

    public static List findAllGroup1(String string, CharSequence charSequence) {
        return ReUtil.findAll(string, charSequence, 1);
    }

    public static List findAll(String string, CharSequence charSequence, int n2) {
        return (List)ReUtil.findAll(string, charSequence, n2, new ArrayList());
    }

    public static Collection findAll(String string, CharSequence charSequence, int n2, Collection collection) {
        if (null == string) {
            return collection;
        }
        return ReUtil.findAll(Pattern.compile(string, 32), charSequence, n2, collection);
    }

    public static List findAllGroup0(Pattern pattern, CharSequence charSequence) {
        return ReUtil.findAll(pattern, charSequence, 0);
    }

    public static List findAllGroup1(Pattern pattern, CharSequence charSequence) {
        return ReUtil.findAll(pattern, charSequence, 1);
    }

    public static List findAll(Pattern pattern, CharSequence charSequence, int n2) {
        return (List)ReUtil.findAll(pattern, charSequence, n2, new ArrayList());
    }

    public static Collection findAll(Pattern pattern, CharSequence charSequence, int n2, Collection collection) {
        if (null == pattern || null == charSequence) {
            return null;
        }
        if (null == collection) {
            throw new NullPointerException("Null collection param provided!");
        }
        Matcher matcher = pattern.matcher(charSequence);
        while (matcher.find()) {
            collection.add(matcher.group(n2));
        }
        return collection;
    }

    public static int count(String string, CharSequence charSequence) {
        if (null == string || null == charSequence) {
            return 0;
        }
        Pattern pattern = PatternPool.get(string, 32);
        return ReUtil.count(pattern, charSequence);
    }

    public static int count(Pattern pattern, CharSequence charSequence) {
        if (null == pattern || null == charSequence) {
            return 0;
        }
        int n2 = 0;
        Matcher matcher = pattern.matcher(charSequence);
        while (matcher.find()) {
            ++n2;
        }
        return n2;
    }

    public static boolean contains(String string, CharSequence charSequence) {
        if (null == string || null == charSequence) {
            return false;
        }
        Pattern pattern = PatternPool.get(string, 32);
        return ReUtil.contains(pattern, charSequence);
    }

    public static boolean contains(Pattern pattern, CharSequence charSequence) {
        if (null == pattern || null == charSequence) {
            return false;
        }
        return pattern.matcher(charSequence).find();
    }

    public static Integer getFirstNumber(CharSequence charSequence) {
        return Convert.toInt(ReUtil.get(PatternPool.NUMBERS, charSequence, 0), null);
    }

    public static boolean isMatch(String string, CharSequence charSequence) {
        if (charSequence == null) {
            return false;
        }
        if (StrUtil.isEmpty(string)) {
            return true;
        }
        Pattern pattern = PatternPool.get(string, 32);
        return ReUtil.isMatch(pattern, charSequence);
    }

    public static boolean isMatch(Pattern pattern, CharSequence charSequence) {
        if (charSequence == null || pattern == null) {
            return false;
        }
        return pattern.matcher(charSequence).matches();
    }

    public static String replaceAll(CharSequence charSequence, String string, String string2) {
        Pattern pattern = Pattern.compile(string, 32);
        return ReUtil.replaceAll(charSequence, pattern, string2);
    }

    public static String replaceAll(CharSequence charSequence, Pattern pattern, String string) {
        if (StrUtil.isEmpty(charSequence)) {
            return StrUtil.str(charSequence);
        }
        Matcher matcher = pattern.matcher(charSequence);
        boolean bl = matcher.find();
        if (bl) {
            Set set = (Set)ReUtil.findAll(PatternPool.GROUP_VAR, (CharSequence)string, 1, new HashSet());
            StringBuffer stringBuffer = new StringBuffer();
            do {
                String string2 = string;
                for (String string3 : set) {
                    int n2 = Integer.parseInt(string3);
                    string2 = string2.replace("$" + string3, matcher.group(n2));
                }
                matcher.appendReplacement(stringBuffer, ReUtil.escape(string2));
            } while (bl = matcher.find());
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
        return StrUtil.str(charSequence);
    }

    public static String replaceAll(CharSequence charSequence, String string, Func1 func1) {
        return ReUtil.replaceAll(charSequence, Pattern.compile(string), func1);
    }

    public static String replaceAll(CharSequence charSequence, Pattern pattern, Func1 func1) {
        if (StrUtil.isEmpty(charSequence)) {
            return StrUtil.str(charSequence);
        }
        Matcher matcher = pattern.matcher(charSequence);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            try {
                matcher.appendReplacement(stringBuffer, (String)func1.call(matcher));
            }
            catch (Exception exception) {
                throw new UtilException(exception);
            }
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public static String escape(char c2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (RE_KEYS.contains(Character.valueOf(c2))) {
            stringBuilder.append('\\');
        }
        stringBuilder.append(c2);
        return stringBuilder.toString();
    }

    public static String escape(CharSequence charSequence) {
        if (StrUtil.isBlank(charSequence)) {
            return StrUtil.str(charSequence);
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (RE_KEYS.contains(Character.valueOf(c2))) {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }
}

