/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.util;

import com.ccb.core.exceptions.UtilException;
import com.ccb.core.lang.Assert;
import com.ccb.core.util.ArrayUtil;
import com.ccb.core.util.CharUtil;
import com.ccb.core.util.ObjectUtil;
import com.ccb.core.util.RandomUtil;
import com.ccb.core.util.StrUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;

public class NumberUtil {
    private static final int DEFAUT_DIV_SCALE = 10;
    private static final long[] FACTORIALS = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L, 20922789888000L, 355687428096000L, 6402373705728000L, 121645100408832000L, 2432902008176640000L};

    public static double add(float f2, float f3) {
        return NumberUtil.add(Float.toString(f2), Float.toString(f3)).doubleValue();
    }

    public static double add(float f2, double d2) {
        return NumberUtil.add(Float.toString(f2), Double.toString(d2)).doubleValue();
    }

    public static double add(double d2, float f2) {
        return NumberUtil.add(Double.toString(d2), Float.toString(f2)).doubleValue();
    }

    public static double add(double d2, double d3) {
        return NumberUtil.add(Double.toString(d2), Double.toString(d3)).doubleValue();
    }

    public static double add(Double d2, Double d3) {
        return NumberUtil.add((Number)d2, (Number)d3).doubleValue();
    }

    public static BigDecimal add(Number number, Number number2) {
        return NumberUtil.add(new Number[]{number, number2});
    }

    public static BigDecimal add(Number ... numberArray) {
        if (ArrayUtil.isEmpty(numberArray)) {
            return BigDecimal.ZERO;
        }
        Number number = numberArray[0];
        BigDecimal bigDecimal = null == number ? BigDecimal.ZERO : new BigDecimal(number.toString());
        for (int i2 = 1; i2 < numberArray.length; ++i2) {
            number = numberArray[i2];
            if (null == number) continue;
            bigDecimal = bigDecimal.add(new BigDecimal(number.toString()));
        }
        return bigDecimal;
    }

    public static BigDecimal add(String ... stringArray) {
        if (ArrayUtil.isEmpty(stringArray)) {
            return BigDecimal.ZERO;
        }
        String string = stringArray[0];
        BigDecimal bigDecimal = null == string ? BigDecimal.ZERO : new BigDecimal(string);
        for (int i2 = 1; i2 < stringArray.length; ++i2) {
            string = stringArray[i2];
            if (null == string) continue;
            bigDecimal = bigDecimal.add(new BigDecimal(string));
        }
        return bigDecimal;
    }

    public static BigDecimal add(BigDecimal ... bigDecimalArray) {
        if (ArrayUtil.isEmpty(bigDecimalArray)) {
            return BigDecimal.ZERO;
        }
        BigDecimal bigDecimal = bigDecimalArray[0];
        BigDecimal bigDecimal2 = null == bigDecimal ? BigDecimal.ZERO : bigDecimal;
        for (int i2 = 1; i2 < bigDecimalArray.length; ++i2) {
            bigDecimal = bigDecimalArray[i2];
            if (null == bigDecimal) continue;
            bigDecimal2 = bigDecimal2.add(bigDecimal);
        }
        return bigDecimal2;
    }

    public static double sub(float f2, float f3) {
        return NumberUtil.sub(Float.toString(f2), Float.toString(f3)).doubleValue();
    }

    public static double sub(float f2, double d2) {
        return NumberUtil.sub(Float.toString(f2), Double.toString(d2)).doubleValue();
    }

    public static double sub(double d2, float f2) {
        return NumberUtil.sub(Double.toString(d2), Float.toString(f2)).doubleValue();
    }

    public static double sub(double d2, double d3) {
        return NumberUtil.sub(Double.toString(d2), Double.toString(d3)).doubleValue();
    }

    public static double sub(Double d2, Double d3) {
        return NumberUtil.sub((Number)d2, (Number)d3).doubleValue();
    }

    public static BigDecimal sub(Number number, Number number2) {
        return NumberUtil.sub(new Number[]{number, number2});
    }

    public static BigDecimal sub(Number ... numberArray) {
        if (ArrayUtil.isEmpty(numberArray)) {
            return BigDecimal.ZERO;
        }
        Number number = numberArray[0];
        BigDecimal bigDecimal = null == number ? BigDecimal.ZERO : new BigDecimal(number.toString());
        for (int i2 = 1; i2 < numberArray.length; ++i2) {
            number = numberArray[i2];
            if (null == number) continue;
            bigDecimal = bigDecimal.subtract(new BigDecimal(number.toString()));
        }
        return bigDecimal;
    }

    public static BigDecimal sub(String ... stringArray) {
        if (ArrayUtil.isEmpty(stringArray)) {
            return BigDecimal.ZERO;
        }
        String string = stringArray[0];
        BigDecimal bigDecimal = null == string ? BigDecimal.ZERO : new BigDecimal(string);
        for (int i2 = 1; i2 < stringArray.length; ++i2) {
            string = stringArray[i2];
            if (null == string) continue;
            bigDecimal = bigDecimal.subtract(new BigDecimal(string));
        }
        return bigDecimal;
    }

    public static BigDecimal sub(BigDecimal ... bigDecimalArray) {
        if (ArrayUtil.isEmpty(bigDecimalArray)) {
            return BigDecimal.ZERO;
        }
        BigDecimal bigDecimal = bigDecimalArray[0];
        BigDecimal bigDecimal2 = null == bigDecimal ? BigDecimal.ZERO : bigDecimal;
        for (int i2 = 1; i2 < bigDecimalArray.length; ++i2) {
            bigDecimal = bigDecimalArray[i2];
            if (null == bigDecimal) continue;
            bigDecimal2 = bigDecimal2.subtract(bigDecimal);
        }
        return bigDecimal2;
    }

    public static double mul(float f2, float f3) {
        return NumberUtil.mul(Float.toString(f2), Float.toString(f3)).doubleValue();
    }

    public static double mul(float f2, double d2) {
        return NumberUtil.mul(Float.toString(f2), Double.toString(d2)).doubleValue();
    }

    public static double mul(double d2, float f2) {
        return NumberUtil.mul(Double.toString(d2), Float.toString(f2)).doubleValue();
    }

    public static double mul(double d2, double d3) {
        return NumberUtil.mul(Double.toString(d2), Double.toString(d3)).doubleValue();
    }

    public static double mul(Double d2, Double d3) {
        return NumberUtil.mul((Number)d2, (Number)d3).doubleValue();
    }

    public static BigDecimal mul(Number number, Number number2) {
        return NumberUtil.mul(new Number[]{number, number2});
    }

    public static BigDecimal mul(Number ... numberArray) {
        if (ArrayUtil.isEmpty(numberArray) || ArrayUtil.hasNull(numberArray)) {
            return BigDecimal.ZERO;
        }
        Number number = numberArray[0];
        BigDecimal bigDecimal = new BigDecimal(number.toString());
        for (int i2 = 1; i2 < numberArray.length; ++i2) {
            number = numberArray[i2];
            bigDecimal = bigDecimal.multiply(new BigDecimal(number.toString()));
        }
        return bigDecimal;
    }

    public static BigDecimal mul(String string, String string2) {
        return NumberUtil.mul((Number)new BigDecimal(string), (Number)new BigDecimal(string2));
    }

    public static BigDecimal mul(String ... stringArray) {
        if (ArrayUtil.isEmpty(stringArray) || ArrayUtil.hasNull(stringArray)) {
            return BigDecimal.ZERO;
        }
        BigDecimal bigDecimal = new BigDecimal(stringArray[0]);
        for (int i2 = 1; i2 < stringArray.length; ++i2) {
            bigDecimal = bigDecimal.multiply(new BigDecimal(stringArray[i2]));
        }
        return bigDecimal;
    }

    public static BigDecimal mul(BigDecimal ... bigDecimalArray) {
        if (ArrayUtil.isEmpty(bigDecimalArray) || ArrayUtil.hasNull(bigDecimalArray)) {
            return BigDecimal.ZERO;
        }
        BigDecimal bigDecimal = bigDecimalArray[0];
        for (int i2 = 1; i2 < bigDecimalArray.length; ++i2) {
            bigDecimal = bigDecimal.multiply(bigDecimalArray[i2]);
        }
        return bigDecimal;
    }

    public static double div(float f2, float f3) {
        return NumberUtil.div(f2, f3, 10);
    }

    public static double div(float f2, double d2) {
        return NumberUtil.div(f2, d2, 10);
    }

    public static double div(double d2, float f2) {
        return NumberUtil.div(d2, f2, 10);
    }

    public static double div(double d2, double d3) {
        return NumberUtil.div(d2, d3, 10);
    }

    public static double div(Double d2, Double d3) {
        return NumberUtil.div(d2, d3, 10);
    }

    public static BigDecimal div(Number number, Number number2) {
        return NumberUtil.div(number, number2, 10);
    }

    public static BigDecimal div(String string, String string2) {
        return NumberUtil.div(string, string2, 10);
    }

    public static double div(float f2, float f3, int n2) {
        return NumberUtil.div(f2, f3, n2, RoundingMode.HALF_UP);
    }

    public static double div(float f2, double d2, int n2) {
        return NumberUtil.div(f2, d2, n2, RoundingMode.HALF_UP);
    }

    public static double div(double d2, float f2, int n2) {
        return NumberUtil.div(d2, f2, n2, RoundingMode.HALF_UP);
    }

    public static double div(double d2, double d3, int n2) {
        return NumberUtil.div(d2, d3, n2, RoundingMode.HALF_UP);
    }

    public static double div(Double d2, Double d3, int n2) {
        return NumberUtil.div(d2, d3, n2, RoundingMode.HALF_UP);
    }

    public static BigDecimal div(Number number, Number number2, int n2) {
        return NumberUtil.div(number, number2, n2, RoundingMode.HALF_UP);
    }

    public static BigDecimal div(String string, String string2, int n2) {
        return NumberUtil.div(string, string2, n2, RoundingMode.HALF_UP);
    }

    public static double div(float f2, float f3, int n2, RoundingMode roundingMode) {
        return NumberUtil.div(Float.toString(f2), Float.toString(f3), n2, roundingMode).doubleValue();
    }

    public static double div(float f2, double d2, int n2, RoundingMode roundingMode) {
        return NumberUtil.div(Float.toString(f2), Double.toString(d2), n2, roundingMode).doubleValue();
    }

    public static double div(double d2, float f2, int n2, RoundingMode roundingMode) {
        return NumberUtil.div(Double.toString(d2), Float.toString(f2), n2, roundingMode).doubleValue();
    }

    public static double div(double d2, double d3, int n2, RoundingMode roundingMode) {
        return NumberUtil.div(Double.toString(d2), Double.toString(d3), n2, roundingMode).doubleValue();
    }

    public static double div(Double d2, Double d3, int n2, RoundingMode roundingMode) {
        return NumberUtil.div((Number)d2, (Number)d3, n2, roundingMode).doubleValue();
    }

    public static BigDecimal div(Number number, Number number2, int n2, RoundingMode roundingMode) {
        return NumberUtil.div(number.toString(), number2.toString(), n2, roundingMode);
    }

    public static BigDecimal div(String string, String string2, int n2, RoundingMode roundingMode) {
        return NumberUtil.div(new BigDecimal(string), new BigDecimal(string2), n2, roundingMode);
    }

    public static BigDecimal div(BigDecimal bigDecimal, BigDecimal bigDecimal2, int n2, RoundingMode roundingMode) {
        Assert.notNull(bigDecimal2, "Divisor must be not null !", new Object[0]);
        if (null == bigDecimal) {
            return BigDecimal.ZERO;
        }
        if (n2 < 0) {
            n2 = -n2;
        }
        return bigDecimal.divide(bigDecimal2, n2, roundingMode);
    }

    public static int ceilDiv(int n2, int n3) {
        return (int)Math.ceil((double)n2 / (double)n3);
    }

    public static BigDecimal round(double d2, int n2) {
        return NumberUtil.round(d2, n2, RoundingMode.HALF_UP);
    }

    public static String roundStr(double d2, int n2) {
        return NumberUtil.round(d2, n2).toString();
    }

    public static BigDecimal round(String string, int n2) {
        return NumberUtil.round(string, n2, RoundingMode.HALF_UP);
    }

    public static BigDecimal round(BigDecimal bigDecimal, int n2) {
        return NumberUtil.round(bigDecimal, n2, RoundingMode.HALF_UP);
    }

    public static String roundStr(String string, int n2) {
        return NumberUtil.round(string, n2).toString();
    }

    public static BigDecimal round(double d2, int n2, RoundingMode roundingMode) {
        return NumberUtil.round(Double.toString(d2), n2, roundingMode);
    }

    public static String roundStr(double d2, int n2, RoundingMode roundingMode) {
        return NumberUtil.round(d2, n2, roundingMode).toString();
    }

    public static BigDecimal round(String string, int n2, RoundingMode roundingMode) {
        Assert.notBlank(string);
        if (n2 < 0) {
            n2 = 0;
        }
        return NumberUtil.round(NumberUtil.toBigDecimal(string), n2, roundingMode);
    }

    public static BigDecimal round(BigDecimal bigDecimal, int n2, RoundingMode roundingMode) {
        if (null == bigDecimal) {
            bigDecimal = BigDecimal.ZERO;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (null == roundingMode) {
            roundingMode = RoundingMode.HALF_UP;
        }
        return bigDecimal.setScale(n2, roundingMode);
    }

    public static String roundStr(String string, int n2, RoundingMode roundingMode) {
        return NumberUtil.round(string, n2, roundingMode).toString();
    }

    public static BigDecimal roundHalfEven(Number number, int n2) {
        return NumberUtil.roundHalfEven(NumberUtil.toBigDecimal(number), n2);
    }

    public static BigDecimal roundHalfEven(BigDecimal bigDecimal, int n2) {
        return NumberUtil.round(bigDecimal, n2, RoundingMode.HALF_EVEN);
    }

    public static BigDecimal roundDown(Number number, int n2) {
        return NumberUtil.roundDown(NumberUtil.toBigDecimal(number), n2);
    }

    public static BigDecimal roundDown(BigDecimal bigDecimal, int n2) {
        return NumberUtil.round(bigDecimal, n2, RoundingMode.DOWN);
    }

    public static String decimalFormat(String string, double d2) {
        return new DecimalFormat(string).format(d2);
    }

    public static String decimalFormat(String string, long l2) {
        return new DecimalFormat(string).format(l2);
    }

    public static String decimalFormat(String string, Object object) {
        return new DecimalFormat(string).format(object);
    }

    public static String decimalFormatMoney(double d2) {
        return NumberUtil.decimalFormat(",##0.00", d2);
    }

    public static String formatPercent(double d2, int n2) {
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        numberFormat.setMaximumFractionDigits(n2);
        return numberFormat.format(d2);
    }

    public static boolean isNumber(CharSequence charSequence) {
        int n2;
        int n3;
        if (StrUtil.isBlank(charSequence)) {
            return false;
        }
        char[] cArray = charSequence.toString().toCharArray();
        int n4 = cArray.length;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n5 = n3 = cArray[0] == '-' || cArray[0] == '+' ? 1 : 0;
        if (n4 > n3 + 1 && cArray[n3] == '0' && (cArray[n3 + 1] == 'x' || cArray[n3 + 1] == 'X')) {
            int n6 = n3 + 2;
            if (n6 == n4) {
                return false;
            }
            while (n6 < cArray.length) {
                if (!(cArray[n6] >= '0' && cArray[n6] <= '9' || cArray[n6] >= 'a' && cArray[n6] <= 'f' || cArray[n6] >= 'A' && cArray[n6] <= 'F')) {
                    return false;
                }
                ++n6;
            }
            return true;
        }
        --n4;
        for (n2 = n3; n2 < n4 || n2 < n4 + 1 && bl3 && !bl4; ++n2) {
            if (cArray[n2] >= '0' && cArray[n2] <= '9') {
                bl4 = true;
                bl3 = false;
                continue;
            }
            if (cArray[n2] == '.') {
                if (bl2 || bl) {
                    return false;
                }
                bl2 = true;
                continue;
            }
            if (cArray[n2] == 'e' || cArray[n2] == 'E') {
                if (bl) {
                    return false;
                }
                if (!bl4) {
                    return false;
                }
                bl = true;
                bl3 = true;
                continue;
            }
            if (cArray[n2] == '+' || cArray[n2] == '-') {
                if (!bl3) {
                    return false;
                }
                bl3 = false;
                bl4 = false;
                continue;
            }
            return false;
        }
        if (n2 < cArray.length) {
            if (cArray[n2] >= '0' && cArray[n2] <= '9') {
                return true;
            }
            if (cArray[n2] == 'e' || cArray[n2] == 'E') {
                return false;
            }
            if (cArray[n2] == '.') {
                if (bl2 || bl) {
                    return false;
                }
                return bl4;
            }
            if (!(bl3 || cArray[n2] != 'd' && cArray[n2] != 'D' && cArray[n2] != 'f' && cArray[n2] != 'F')) {
                return bl4;
            }
            if (cArray[n2] == 'l' || cArray[n2] == 'L') {
                return bl4 && !bl;
            }
            return false;
        }
        return false == bl3 && bl4;
    }

    public static boolean isInteger(String string) {
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static boolean isLong(String string) {
        try {
            Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static boolean isDouble(String string) {
        try {
            Double.parseDouble(string);
            return string.contains(".");
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isPrimes(int n2) {
        Assert.isTrue(n2 > 1, "The number must be > 1", new Object[0]);
        int n3 = 2;
        while ((double)n3 <= Math.sqrt(n2)) {
            if (n2 % n3 == 0) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static int[] generateRandomNumber(int n2, int n3, int n4) {
        int[] nArray = ArrayUtil.range(n2, n3);
        return NumberUtil.generateRandomNumber(n2, n3, n4, nArray);
    }

    public static int[] generateRandomNumber(int n2, int n3, int n4, int[] nArray) {
        if (n2 > n3) {
            int n5 = n2;
            n2 = n3;
            n3 = n5;
        }
        Assert.isTrue(n3 - n2 > n4, "Size is larger than range between begin and end!", new Object[0]);
        Assert.isTrue(nArray.length > n4, "Size is larger than seed size!", new Object[0]);
        int[] nArray2 = new int[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            int n6 = RandomUtil.randomInt(nArray.length - i2);
            nArray2[i2] = nArray[n6];
            nArray[n6] = nArray[nArray.length - 1 - i2];
        }
        return nArray2;
    }

    public static Integer[] generateBySet(int n2, int n3, int n4) {
        if (n2 > n3) {
            int n5 = n2;
            n2 = n3;
            n3 = n5;
        }
        if (n3 - n2 < n4) {
            throw new UtilException("Size is larger than range between begin and end!");
        }
        Random random = new Random();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        while (hashSet.size() < n4) {
            hashSet.add(n2 + random.nextInt(n3 - n2));
        }
        return hashSet.toArray(new Integer[n4]);
    }

    public static int[] range(int n2) {
        return NumberUtil.range(0, n2);
    }

    public static int[] range(int n2, int n3) {
        return NumberUtil.range(n2, n3, 1);
    }

    public static int[] range(int n2, int n3, int n4) {
        if (n2 < n3) {
            n4 = Math.abs(n4);
        } else if (n2 > n3) {
            n4 = -Math.abs(n4);
        } else {
            return new int[]{n2};
        }
        int n5 = Math.abs((n3 - n2) / n4) + 1;
        int[] nArray = new int[n5];
        int n6 = 0;
        int n7 = n2;
        while (n4 > 0 ? n7 <= n3 : n7 >= n3) {
            nArray[n6] = n7;
            ++n6;
            n7 += n4;
        }
        return nArray;
    }

    public static Collection appendRange(int n2, int n3, Collection collection) {
        return NumberUtil.appendRange(n2, n3, 1, collection);
    }

    public static Collection appendRange(int n2, int n3, int n4, Collection collection) {
        if (n2 < n3) {
            n4 = Math.abs(n4);
        } else if (n2 > n3) {
            n4 = -Math.abs(n4);
        } else {
            collection.add(n2);
            return collection;
        }
        int n5 = n2;
        while (n4 > 0 ? n5 <= n3 : n5 >= n3) {
            collection.add(n5);
            n5 += n4;
        }
        return collection;
    }

    public static long factorial(long l2, long l3) {
        if (l2 < 0L || l3 < 0L) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)"Factorial start and end both must be >= 0, but got start={}, end={}", l2, l3));
        }
        if (0L == l2 || l2 == l3) {
            return 1L;
        }
        if (l2 < l3) {
            return 0L;
        }
        return NumberUtil.factorialMultiplyAndCheck(l2, NumberUtil.factorial(l2 - 1L, l3));
    }

    private static long factorialMultiplyAndCheck(long l2, long l3) {
        if (l2 <= Long.MAX_VALUE / l3) {
            return l2 * l3;
        }
        throw new IllegalArgumentException(StrUtil.format((CharSequence)"Overflow in multiplication: {} * {}", l2, l3));
    }

    public static long factorial(long l2) {
        if (l2 < 0L || l2 > 20L) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)"Factorial must have n >= 0 and n <= 20 for n!, but got n = {}", l2));
        }
        return FACTORIALS[(int)l2];
    }

    public static long sqrt(long l2) {
        long l3 = 0L;
        for (long i2 = 0x4000000000000000L; i2 > 0L; i2 >>= 2) {
            if (l2 >= l3 + i2) {
                l2 -= l3 + i2;
                l3 >>= 1;
                l3 += i2;
                continue;
            }
            l3 >>= 1;
        }
        return l3;
    }

    public static int processMultiple(int n2, int n3) {
        int n4 = NumberUtil.mathSubnode(n2, n3) / NumberUtil.mathNode(n2 - n3);
        return n4;
    }

    public static int divisor(int n2, int n3) {
        while (n2 % n3 != 0) {
            int n4 = n2 % n3;
            n2 = n3;
            n3 = n4;
        }
        return n3;
    }

    public static int multiple(int n2, int n3) {
        return n2 * n3 / NumberUtil.divisor(n2, n3);
    }

    public static String getBinaryStr(Number number) {
        if (number instanceof Long) {
            return Long.toBinaryString((Long)number);
        }
        if (number instanceof Integer) {
            return Integer.toBinaryString((Integer)number);
        }
        return Long.toBinaryString(number.longValue());
    }

    public static int binaryToInt(String string) {
        return Integer.parseInt(string, 2);
    }

    public static long binaryToLong(String string) {
        return Long.parseLong(string, 2);
    }

    public static int compare(char c2, char c3) {
        return c2 - c3;
    }

    public static int compare(double d2, double d3) {
        return Double.compare(d2, d3);
    }

    public static int compare(int n2, int n3) {
        return Integer.compare(n2, n3);
    }

    public static int compare(long l2, long l3) {
        return Long.compare(l2, l3);
    }

    public static int compare(short s2, short s3) {
        return Short.compare(s2, s3);
    }

    public static int compare(byte by, byte by2) {
        return Byte.compare(by, by2);
    }

    public static boolean isGreater(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        Assert.notNull(bigDecimal);
        Assert.notNull(bigDecimal2);
        return bigDecimal.compareTo(bigDecimal2) > 0;
    }

    public static boolean isGreaterOrEqual(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        Assert.notNull(bigDecimal);
        Assert.notNull(bigDecimal2);
        return bigDecimal.compareTo(bigDecimal2) >= 0;
    }

    public static boolean isLess(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        Assert.notNull(bigDecimal);
        Assert.notNull(bigDecimal2);
        return bigDecimal.compareTo(bigDecimal2) < 0;
    }

    public static boolean isLessOrEqual(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        Assert.notNull(bigDecimal);
        Assert.notNull(bigDecimal2);
        return bigDecimal.compareTo(bigDecimal2) <= 0;
    }

    public static boolean equals(double d2, double d3) {
        return Double.doubleToLongBits(d2) == Double.doubleToLongBits(d3);
    }

    public static boolean equals(float f2, float f3) {
        return Float.floatToIntBits(f2) == Float.floatToIntBits(f3);
    }

    public static boolean equals(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        if (bigDecimal == bigDecimal2) {
            return true;
        }
        if (bigDecimal == null || bigDecimal2 == null) {
            return false;
        }
        return 0 == bigDecimal.compareTo(bigDecimal2);
    }

    public static boolean equals(char c2, char c3, boolean bl) {
        return CharUtil.equals(c2, c3, bl);
    }

    public static Comparable min(Comparable[] comparableArray) {
        return ArrayUtil.min(comparableArray);
    }

    public static long min(long ... lArray) {
        return ArrayUtil.min(lArray);
    }

    public static int min(int ... nArray) {
        return ArrayUtil.min(nArray);
    }

    public static short min(short ... sArray) {
        return ArrayUtil.min(sArray);
    }

    public static double min(double ... dArray) {
        return ArrayUtil.min(dArray);
    }

    public static float min(float ... fArray) {
        return ArrayUtil.min(fArray);
    }

    public static BigDecimal min(BigDecimal ... bigDecimalArray) {
        return (BigDecimal)ArrayUtil.min(bigDecimalArray);
    }

    public static Comparable max(Comparable[] comparableArray) {
        return ArrayUtil.max(comparableArray);
    }

    public static long max(long ... lArray) {
        return ArrayUtil.max(lArray);
    }

    public static int max(int ... nArray) {
        return ArrayUtil.max(nArray);
    }

    public static short max(short ... sArray) {
        return ArrayUtil.max(sArray);
    }

    public static double max(double ... dArray) {
        return ArrayUtil.max(dArray);
    }

    public static float max(float ... fArray) {
        return ArrayUtil.max(fArray);
    }

    public static BigDecimal max(BigDecimal ... bigDecimalArray) {
        return (BigDecimal)ArrayUtil.max(bigDecimalArray);
    }

    public static String toStr(Number number, String string) {
        return null == number ? string : NumberUtil.toStr(number);
    }

    public static String toStr(Number number) {
        if (null == number) {
            throw new NullPointerException("Number is null !");
        }
        if (!ObjectUtil.isValidIfNumber(number)) {
            throw new IllegalArgumentException("Number is non-finite!");
        }
        String string = number.toString();
        if (string.indexOf(46) > 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
            while (string.endsWith("0")) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public static BigDecimal toBigDecimal(Number number) {
        if (null == number) {
            return BigDecimal.ZERO;
        }
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof Long) {
            return new BigDecimal((Long)number);
        }
        if (number instanceof Integer) {
            return new BigDecimal((Integer)number);
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number);
        }
        return NumberUtil.toBigDecimal(number.toString());
    }

    public static BigDecimal toBigDecimal(String string) {
        return null == string ? BigDecimal.ZERO : new BigDecimal(string);
    }

    public static BigInteger toBigInteger(Number number) {
        if (null == number) {
            return BigInteger.ZERO;
        }
        if (number instanceof BigInteger) {
            return (BigInteger)number;
        }
        if (number instanceof Long) {
            return BigInteger.valueOf((Long)number);
        }
        return NumberUtil.toBigInteger(number.longValue());
    }

    public static BigInteger toBigInteger(String string) {
        return null == string ? BigInteger.ZERO : new BigInteger(string);
    }

    public static boolean isBlankChar(char c2) {
        return NumberUtil.isBlankChar((int)c2);
    }

    public static boolean isBlankChar(int n2) {
        return Character.isWhitespace(n2) || Character.isSpaceChar(n2) || n2 == 65279 || n2 == 8234;
    }

    public static int count(int n2, int n3) {
        return n2 % n3 == 0 ? n2 / n3 : n2 / n3 + 1;
    }

    public static BigDecimal null2Zero(BigDecimal bigDecimal) {
        return bigDecimal == null ? BigDecimal.ZERO : bigDecimal;
    }

    public static int zero2One(int n2) {
        return 0 == n2 ? 1 : n2;
    }

    public static BigInteger newBigInteger(String string) {
        if (null == (string = StrUtil.trimToNull(string))) {
            return null;
        }
        int n2 = 0;
        int n3 = 10;
        boolean bl = false;
        if (string.startsWith("-")) {
            bl = true;
            n2 = 1;
        }
        if (string.startsWith("0x", n2) || string.startsWith("0X", n2)) {
            n3 = 16;
            n2 += 2;
        } else if (string.startsWith("#", n2)) {
            n3 = 16;
            ++n2;
        } else if (string.startsWith("0", n2) && string.length() > n2 + 1) {
            n3 = 8;
            ++n2;
        }
        if (n2 > 0) {
            string = string.substring(n2);
        }
        BigInteger bigInteger = new BigInteger(string, n3);
        return bl ? bigInteger.negate() : bigInteger;
    }

    public static boolean isBeside(long l2, long l3) {
        return Math.abs(l2 - l3) == 1L;
    }

    public static boolean isBeside(int n2, int n3) {
        return Math.abs(n2 - n3) == 1;
    }

    public static int partValue(int n2, int n3) {
        return NumberUtil.partValue(n2, n3, true);
    }

    public static int partValue(int n2, int n3, boolean bl) {
        int n4 = n2 / n3;
        if (bl && n2 % n3 > 0) {
            ++n4;
        }
        return n4;
    }

    public static BigDecimal pow(Number number, int n2) {
        return NumberUtil.pow(NumberUtil.toBigDecimal(number), n2);
    }

    public static BigDecimal pow(BigDecimal bigDecimal, int n2) {
        return bigDecimal.pow(n2);
    }

    public static boolean isPowerOfTwo(long l2) {
        return l2 > 0L && (l2 & l2 - 1L) == 0L;
    }

    public static int parseInt(String string) {
        if (StrUtil.isBlank(string)) {
            return 0;
        }
        if (StrUtil.isEmpty(string = StrUtil.subBefore((CharSequence)string, '.', false))) {
            return 0;
        }
        if (StrUtil.startWithIgnoreCase(string, "0x")) {
            return Integer.parseInt(string.substring(2), 16);
        }
        return Integer.parseInt(NumberUtil.removeNumberFlag(string));
    }

    public static long parseLong(String string) {
        if (StrUtil.isBlank(string)) {
            return 0L;
        }
        if (StrUtil.isEmpty(string = StrUtil.subBefore((CharSequence)string, '.', false))) {
            return 0L;
        }
        if (string.startsWith("0x")) {
            return Long.parseLong(string.substring(2), 16);
        }
        return Long.parseLong(NumberUtil.removeNumberFlag(string));
    }

    public static Number parseNumber(String string) {
        string = NumberUtil.removeNumberFlag(string);
        try {
            return NumberFormat.getInstance().parse(string);
        }
        catch (ParseException parseException) {
            throw new UtilException(parseException);
        }
    }

    public static byte[] toBytes(int n2) {
        byte[] byArray = new byte[]{(byte)(n2 >> 24), (byte)(n2 >> 16), (byte)(n2 >> 8), (byte)n2};
        return byArray;
    }

    public static int toInt(byte[] byArray) {
        return (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    public static byte[] toUnsignedByteArray(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray[0] == 0) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            return byArray2;
        }
        return byArray;
    }

    public static byte[] toUnsignedByteArray(int n2, BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length == n2) {
            return byArray;
        }
        int n3 = byArray[0] == 0 ? 1 : 0;
        int n4 = byArray.length - n3;
        if (n4 > n2) {
            throw new IllegalArgumentException("standard length exceeded for value");
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n3, byArray2, byArray2.length - n4, n4);
        return byArray2;
    }

    public static BigInteger fromUnsignedByteArray(byte[] byArray) {
        return new BigInteger(1, byArray);
    }

    public static BigInteger fromUnsignedByteArray(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = byArray;
        if (n2 != 0 || n3 != byArray.length) {
            byArray2 = new byte[n3];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
        }
        return new BigInteger(1, byArray2);
    }

    public static boolean isValidNumber(Number number) {
        if (number instanceof Double) {
            return false == ((Double)number).isInfinite() && false == ((Double)number).isNaN();
        }
        if (number instanceof Float) {
            return false == ((Float)number).isInfinite() && false == ((Float)number).isNaN();
        }
        return true;
    }

    private static int mathSubnode(int n2, int n3) {
        if (n2 == n3) {
            return 1;
        }
        return n2 * NumberUtil.mathSubnode(n2 - 1, n3);
    }

    private static int mathNode(int n2) {
        if (n2 == 0) {
            return 1;
        }
        return n2 * NumberUtil.mathNode(n2 - 1);
    }

    private static String removeNumberFlag(String string) {
        int n2 = string.length() - 1;
        char c2 = Character.toUpperCase(string.charAt(n2));
        if ('D' == c2 || 'L' == c2 || 'F' == c2) {
            string = StrUtil.subPre(string, n2);
        }
        return string;
    }
}

