/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.util;

import com.ccb.core.lang.hash.CityHash;
import com.ccb.core.lang.hash.MurmurHash;
import com.ccb.core.lang.hash.Number128;

public class HashUtil {
    public static int additiveHash(String string, int n2) {
        int n3 = string.length();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            n3 += string.charAt(i2);
        }
        return n3 % n2;
    }

    public static int rotatingHash(String string, int n2) {
        int n3 = string.length();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            n3 = n3 << 4 ^ n3 >> 28 ^ string.charAt(i2);
        }
        return n3 % n2;
    }

    public static int oneByOneHash(String string) {
        int n2 = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            n2 += string.charAt(i2);
            n2 += n2 << 10;
            n2 ^= n2 >> 6;
        }
        n2 += n2 << 3;
        n2 ^= n2 >> 11;
        n2 += n2 << 15;
        return n2;
    }

    public static int bernstein(String string) {
        int n2 = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            n2 = 33 * n2 + string.charAt(i2);
        }
        return n2;
    }

    public static int universal(char[] cArray, int n2, int[] nArray) {
        int n3 = cArray.length;
        int n4 = cArray.length;
        for (int i2 = 0; i2 < n4 << 3; i2 += 8) {
            char c2 = cArray[i2 >> 3];
            if ((c2 & '\u0001') == 0) {
                n3 ^= nArray[i2];
            }
            if ((c2 & 2) == 0) {
                n3 ^= nArray[i2 + 1];
            }
            if ((c2 & 4) == 0) {
                n3 ^= nArray[i2 + 2];
            }
            if ((c2 & 8) == 0) {
                n3 ^= nArray[i2 + 3];
            }
            if ((c2 & 0x10) == 0) {
                n3 ^= nArray[i2 + 4];
            }
            if ((c2 & 0x20) == 0) {
                n3 ^= nArray[i2 + 5];
            }
            if ((c2 & 0x40) == 0) {
                n3 ^= nArray[i2 + 6];
            }
            if ((c2 & 0x80) != 0) continue;
            n3 ^= nArray[i2 + 7];
        }
        return n3 & n2;
    }

    public static int zobrist(char[] cArray, int n2, int[][] nArray) {
        int n3 = cArray.length;
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            n3 ^= nArray[i2][cArray[i2]];
        }
        return n3 & n2;
    }

    public static int fnvHash(byte[] byArray) {
        int n2 = 16777619;
        int n3 = -2128831035;
        for (byte by : byArray) {
            n3 = (n3 ^ by) * 16777619;
        }
        n3 += n3 << 13;
        n3 ^= n3 >> 7;
        n3 += n3 << 3;
        n3 ^= n3 >> 17;
        n3 += n3 << 5;
        return Math.abs(n3);
    }

    public static int fnvHash(String string) {
        int n2 = 16777619;
        int n3 = -2128831035;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            n3 = (n3 ^ string.charAt(i2)) * 16777619;
        }
        n3 += n3 << 13;
        n3 ^= n3 >> 7;
        n3 += n3 << 3;
        n3 ^= n3 >> 17;
        n3 += n3 << 5;
        return Math.abs(n3);
    }

    public static int intHash(int n2) {
        n2 += ~(n2 << 15);
        n2 ^= n2 >>> 10;
        n2 += n2 << 3;
        n2 ^= n2 >>> 6;
        n2 += ~(n2 << 11);
        n2 ^= n2 >>> 16;
        return n2;
    }

    public static int rsHash(String string) {
        int n2 = 378551;
        int n3 = 63689;
        int n4 = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            n4 = n4 * n3 + string.charAt(i2);
            n3 *= n2;
        }
        return n4 & Integer.MAX_VALUE;
    }

    public static int jsHash(String string) {
        int n2 = 1315423911;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            n2 ^= (n2 << 5) + string.charAt(i2) + (n2 >> 2);
        }
        return n2 & Integer.MAX_VALUE;
    }

    public static int pjwHash(String string) {
        int n2 = 32;
        int n3 = n2 * 3 / 4;
        int n4 = n2 / 8;
        int n5 = -1 << n2 - n4;
        int n6 = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            int n7 = (n6 = (n6 << n4) + string.charAt(i2)) & n5;
            if (n7 == 0) continue;
            n6 = (n6 ^ n7 >> n3) & ~n5;
        }
        return n6 & Integer.MAX_VALUE;
    }

    public static int elfHash(String string) {
        int n2 = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            int n3 = (int)((long)(n2 = (n2 << 4) + string.charAt(i2)) & 0xF0000000L);
            if (n3 == 0) continue;
            n2 ^= n3 >> 24;
            n2 &= ~n3;
        }
        return n2 & Integer.MAX_VALUE;
    }

    public static int bkdrHash(String string) {
        int n2 = 131;
        int n3 = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            n3 = n3 * n2 + string.charAt(i2);
        }
        return n3 & Integer.MAX_VALUE;
    }

    public static int sdbmHash(String string) {
        int n2 = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            n2 = string.charAt(i2) + (n2 << 6) + (n2 << 16) - n2;
        }
        return n2 & Integer.MAX_VALUE;
    }

    public static int djbHash(String string) {
        int n2 = 5381;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            n2 = (n2 << 5) + n2 + string.charAt(i2);
        }
        return n2 & Integer.MAX_VALUE;
    }

    public static int dekHash(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            n2 = n2 << 5 ^ n2 >> 27 ^ string.charAt(i2);
        }
        return n2 & Integer.MAX_VALUE;
    }

    public static int apHash(String string) {
        int n2 = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            n2 ^= (i2 & 1) == 0 ? n2 << 7 ^ string.charAt(i2) ^ n2 >> 3 : ~(n2 << 11 ^ string.charAt(i2) ^ n2 >> 5);
        }
        return n2;
    }

    public static long tianlHash(String string) {
        int n2 = string.length();
        if (n2 == 0) {
            return 0L;
        }
        long l2 = n2 <= 256 ? 0x1000000L * (long)(n2 - 1) : 0xFF000000L;
        if (n2 <= 96) {
            for (int i2 = 1; i2 <= n2; ++i2) {
                char c2 = string.charAt(i2 - 1);
                if (c2 <= 'Z' && c2 >= 'A') {
                    c2 = (char)(c2 + 32);
                }
                l2 += (long)((3 * i2 * c2 * c2 + 5 * i2 * c2 + 7 * i2 + 11 * c2) % 0x1000000);
            }
        } else {
            for (int i3 = 1; i3 <= 96; ++i3) {
                char c3 = string.charAt(i3 + n2 - 96 - 1);
                if (c3 <= 'Z' && c3 >= 'A') {
                    c3 = (char)(c3 + 32);
                }
                l2 += (long)((3 * i3 * c3 * c3 + 5 * i3 * c3 + 7 * i3 + 11 * c3) % 0x1000000);
            }
        }
        if (l2 < 0L) {
            l2 *= -1L;
        }
        return l2;
    }

    public static int javaDefaultHash(String string) {
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        for (int i2 = 0; i2 < n4; ++i2) {
            n2 = 31 * n2 + string.charAt(n3++);
        }
        return n2;
    }

    public static long mixHash(String string) {
        long l2 = string.hashCode();
        l2 <<= 32;
        return l2 |= (long)HashUtil.fnvHash(string);
    }

    public static int identityHashCode(Object object) {
        return System.identityHashCode(object);
    }

    public static int murmur32(byte[] byArray) {
        return MurmurHash.hash32(byArray);
    }

    public static long murmur64(byte[] byArray) {
        return MurmurHash.hash64(byArray);
    }

    public static long[] murmur128(byte[] byArray) {
        return MurmurHash.hash128(byArray);
    }

    public static int cityHash32(byte[] byArray) {
        return CityHash.hash32(byArray);
    }

    public static long cityHash64(byte[] byArray, long l2) {
        return CityHash.hash64(byArray, l2);
    }

    public static long cityHash64(byte[] byArray, long l2, long l3) {
        return CityHash.hash64(byArray, l2, l3);
    }

    public static long cityHash64(byte[] byArray) {
        return CityHash.hash64(byArray);
    }

    public static long[] cityHash128(byte[] byArray) {
        return CityHash.hash128(byArray).getLongArray();
    }

    public static long[] cityHash128(byte[] byArray, Number128 number128) {
        return CityHash.hash128(byArray).getLongArray();
    }
}

