/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.util;

import com.ccb.core.lang.Assert;
import com.ccb.core.map.MapUtil;
import com.ccb.core.util.ObjectUtil;
import com.ccb.core.util.ReflectUtil;
import com.ccb.core.util.StrUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class EnumUtil {
    public static boolean isEnum(Class clazz) {
        Assert.notNull(clazz);
        return clazz.isEnum();
    }

    public static boolean isEnum(Object object) {
        Assert.notNull(object);
        return object.getClass().isEnum();
    }

    public static String toString(Enum enum_) {
        return null != enum_ ? enum_.name() : null;
    }

    public static Enum getEnumAt(Class clazz, int n2) {
        Enum[] enumArray = (Enum[])clazz.getEnumConstants();
        return n2 >= 0 && n2 < enumArray.length ? enumArray[n2] : null;
    }

    public static Enum fromString(Class clazz, String string) {
        return Enum.valueOf(clazz, string);
    }

    public static Enum fromString(Class clazz, String string, Enum enum_) {
        return (Enum)ObjectUtil.defaultIfNull(EnumUtil.fromStringQuietly(clazz, string), enum_);
    }

    public static Enum fromStringQuietly(Class clazz, String string) {
        if (null == clazz || StrUtil.isBlank(string)) {
            return null;
        }
        try {
            return EnumUtil.fromString(clazz, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static Enum likeValueOf(Class clazz, Object object) {
        if (object instanceof CharSequence) {
            object = object.toString().trim();
        }
        Field[] fieldArray = ReflectUtil.getFields(clazz);
        Enum[] enumArray = (Enum[])clazz.getEnumConstants();
        for (Field field : fieldArray) {
            String string = field.getName();
            if (field.getType().isEnum() || "ENUM$VALUES".equals(string) || "ordinal".equals(string)) continue;
            for (Enum enum_ : enumArray) {
                if (!ObjectUtil.equal(object, ReflectUtil.getFieldValue((Object)enum_, field))) continue;
                return enum_;
            }
        }
        return null;
    }

    public static List getNames(Class clazz) {
        Enum[] enumArray = (Enum[])clazz.getEnumConstants();
        if (null == enumArray) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(enumArray.length);
        for (Enum enum_ : enumArray) {
            arrayList.add(enum_.name());
        }
        return arrayList;
    }

    public static List getFieldValues(Class clazz, String string) {
        Enum[] enumArray = (Enum[])clazz.getEnumConstants();
        if (null == enumArray) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(enumArray.length);
        for (Enum enum_ : enumArray) {
            arrayList.add(ReflectUtil.getFieldValue((Object)enum_, string));
        }
        return arrayList;
    }

    public static List getFieldNames(Class clazz) {
        Field[] fieldArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Field field : fieldArray = ReflectUtil.getFields(clazz)) {
            String string = field.getName();
            if (field.getType().isEnum() || string.contains("$VALUES") || "ordinal".equals(string) || arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static LinkedHashMap getEnumMap(Class clazz) {
        LinkedHashMap<String, Enum> linkedHashMap = new LinkedHashMap<String, Enum>();
        for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
            linkedHashMap.put(enum_.name(), enum_);
        }
        return linkedHashMap;
    }

    public static Map getNameFieldMap(Class clazz, String string) {
        Enum[] enumArray = (Enum[])clazz.getEnumConstants();
        if (null == enumArray) {
            return null;
        }
        HashMap hashMap = MapUtil.newHashMap(enumArray.length);
        for (Enum enum_ : enumArray) {
            hashMap.put(enum_.name(), ReflectUtil.getFieldValue((Object)enum_, string));
        }
        return hashMap;
    }

    public static boolean contains(Class clazz, String string) {
        return EnumUtil.getEnumMap(clazz).containsKey(string);
    }

    public static boolean notContains(Class clazz, String string) {
        return false == EnumUtil.contains(clazz, string);
    }

    public static boolean equalsIgnoreCase(Enum enum_, String string) {
        return StrUtil.equalsIgnoreCase(EnumUtil.toString(enum_), string);
    }

    public static boolean equals(Enum enum_, String string) {
        return StrUtil.equals(EnumUtil.toString(enum_), string);
    }
}

