/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.util;

import com.ccb.core.lang.PatternPool;
import com.ccb.core.util.RandomUtil;
import com.ccb.core.util.ReUtil;
import com.ccb.core.util.StrUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class CreditCodeUtil {
    public static final Pattern CREDIT_CODE_PATTERN = PatternPool.CREDIT_CODE;
    private static final int[] WEIGHT = new int[]{1, 3, 9, 27, 19, 26, 16, 17, 20, 29, 25, 13, 8, 24, 10, 30, 28};
    private static final char[] BASE_CODE_ARRAY = "0123456789ABCDEFGHJKLMNPQRTUWXY".toCharArray();
    private static final Map CODE_INDEX_MAP = new ConcurrentHashMap();

    public static boolean isCreditCodeSimple(CharSequence charSequence) {
        if (StrUtil.isBlank(charSequence)) {
            return false;
        }
        return ReUtil.isMatch(CREDIT_CODE_PATTERN, charSequence);
    }

    public static boolean isCreditCode(CharSequence charSequence) {
        if (!CreditCodeUtil.isCreditCodeSimple(charSequence)) {
            return false;
        }
        int n2 = CreditCodeUtil.getParityBit(charSequence);
        if (n2 < 0) {
            return false;
        }
        return charSequence.charAt(17) == BASE_CODE_ARRAY[n2];
    }

    public static String randomCreditCode() {
        int n2;
        int n3;
        StringBuilder stringBuilder = new StringBuilder(18);
        for (n3 = 0; n3 < 2; ++n3) {
            n2 = RandomUtil.randomInt(BASE_CODE_ARRAY.length - 1);
            stringBuilder.append(Character.toUpperCase(BASE_CODE_ARRAY[n2]));
        }
        for (n3 = 2; n3 < 8; ++n3) {
            n2 = RandomUtil.randomInt(10);
            stringBuilder.append(BASE_CODE_ARRAY[n2]);
        }
        for (n3 = 8; n3 < 17; ++n3) {
            n2 = RandomUtil.randomInt(BASE_CODE_ARRAY.length - 1);
            stringBuilder.append(BASE_CODE_ARRAY[n2]);
        }
        String string = stringBuilder.toString();
        return string + BASE_CODE_ARRAY[CreditCodeUtil.getParityBit(string)];
    }

    private static int getParityBit(CharSequence charSequence) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < 17; ++n2) {
            Integer n4 = (Integer)CODE_INDEX_MAP.get(Character.valueOf(charSequence.charAt(n2)));
            if (null == n4) {
                return -1;
            }
            n3 += n4 * WEIGHT[n2];
        }
        n2 = 31 - n3 % 31;
        return n2 == 31 ? 0 : n2;
    }

    static {
        for (int i2 = 0; i2 < BASE_CODE_ARRAY.length; ++i2) {
            CODE_INDEX_MAP.put(Character.valueOf(BASE_CODE_ARRAY[i2]), i2);
        }
    }
}

