/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.thread;

import com.ccb.core.thread.ThreadUtil;
import com.ccb.core.util.StrUtil;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadFactory
implements ThreadFactory {
    private final String prefix;
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final boolean isDaemon;
    private final Thread.UncaughtExceptionHandler handler;

    public NamedThreadFactory(String string, boolean bl) {
        this(string, null, bl);
    }

    public NamedThreadFactory(String string, ThreadGroup threadGroup, boolean bl) {
        this(string, threadGroup, bl, null);
    }

    public NamedThreadFactory(String string, ThreadGroup threadGroup, boolean bl, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        String string2 = this.prefix = StrUtil.isBlank(string) ? "Hutool" : string;
        if (null == threadGroup) {
            threadGroup = ThreadUtil.currentThreadGroup();
        }
        this.group = threadGroup;
        this.isDaemon = bl;
        this.handler = uncaughtExceptionHandler;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(this.group, runnable, StrUtil.format((CharSequence)"{}{}", this.prefix, this.threadNumber.getAndIncrement()));
        if (!thread.isDaemon()) {
            if (this.isDaemon) {
                thread.setDaemon(true);
            }
        } else if (!this.isDaemon) {
            thread.setDaemon(false);
        }
        if (null != this.handler) {
            thread.setUncaughtExceptionHandler(this.handler);
        }
        if (5 != thread.getPriority()) {
            thread.setPriority(5);
        }
        return thread;
    }
}

