/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.thread;

import com.ccb.core.exceptions.UtilException;
import com.ccb.core.thread.ExecutorBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class GlobalThreadPool {
    private static ExecutorService executor;

    private GlobalThreadPool() {
    }

    public static synchronized void init() {
        if (null != executor) {
            executor.shutdownNow();
        }
        executor = ExecutorBuilder.create().useSynchronousQueue().build();
    }

    public static synchronized void shutdown(boolean bl) {
        if (null != executor) {
            if (bl) {
                executor.shutdownNow();
            } else {
                executor.shutdown();
            }
        }
    }

    public static ExecutorService getExecutor() {
        return executor;
    }

    public static void execute(Runnable runnable) {
        try {
            executor.execute(runnable);
        }
        catch (Exception exception) {
            throw new UtilException(exception, "Exception when running task!", new Object[0]);
        }
    }

    public static Future submit(Callable callable) {
        return executor.submit(callable);
    }

    public static Future submit(Runnable runnable) {
        return executor.submit(runnable);
    }

    static {
        GlobalThreadPool.init();
    }
}

