/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.thread;

import com.ccb.core.builder.Builder;
import com.ccb.core.thread.FinalizableDelegatedExecutorService;
import com.ccb.core.util.ObjectUtil;
import java.util.AbstractQueue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ExecutorBuilder
implements Builder {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_QUEUE_CAPACITY = 1024;
    private int corePoolSize;
    private int maxPoolSize = Integer.MAX_VALUE;
    private long keepAliveTime = TimeUnit.SECONDS.toNanos(60L);
    private BlockingQueue workQueue;
    private ThreadFactory threadFactory;
    private RejectedExecutionHandler handler;
    private Boolean allowCoreThreadTimeOut;

    public ExecutorBuilder setCorePoolSize(int n2) {
        this.corePoolSize = n2;
        return this;
    }

    public ExecutorBuilder setMaxPoolSize(int n2) {
        this.maxPoolSize = n2;
        return this;
    }

    public ExecutorBuilder setKeepAliveTime(long l2, TimeUnit timeUnit) {
        return this.setKeepAliveTime(timeUnit.toNanos(l2));
    }

    public ExecutorBuilder setKeepAliveTime(long l2) {
        this.keepAliveTime = l2;
        return this;
    }

    public ExecutorBuilder setWorkQueue(BlockingQueue blockingQueue) {
        this.workQueue = blockingQueue;
        return this;
    }

    public ExecutorBuilder useArrayBlockingQueue(int n2) {
        return this.setWorkQueue(new ArrayBlockingQueue(n2));
    }

    public ExecutorBuilder useSynchronousQueue() {
        return this.useSynchronousQueue(false);
    }

    public ExecutorBuilder useSynchronousQueue(boolean bl) {
        return this.setWorkQueue(new SynchronousQueue(bl));
    }

    public ExecutorBuilder setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        return this;
    }

    public ExecutorBuilder setHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        this.handler = rejectedExecutionHandler;
        return this;
    }

    public ExecutorBuilder setAllowCoreThreadTimeOut(boolean bl) {
        this.allowCoreThreadTimeOut = bl;
        return this;
    }

    public static ExecutorBuilder create() {
        return new ExecutorBuilder();
    }

    @Override
    public ThreadPoolExecutor build() {
        return ExecutorBuilder.build(this);
    }

    public ExecutorService buildFinalizable() {
        return new FinalizableDelegatedExecutorService(this.build());
    }

    private static ThreadPoolExecutor build(ExecutorBuilder executorBuilder) {
        int n2 = executorBuilder.corePoolSize;
        int n3 = executorBuilder.maxPoolSize;
        long l2 = executorBuilder.keepAliveTime;
        AbstractQueue abstractQueue = null != executorBuilder.workQueue ? executorBuilder.workQueue : (n2 <= 0 ? new SynchronousQueue() : new LinkedBlockingQueue(1024));
        ThreadFactory threadFactory = null != executorBuilder.threadFactory ? executorBuilder.threadFactory : Executors.defaultThreadFactory();
        RejectedExecutionHandler rejectedExecutionHandler = (RejectedExecutionHandler)ObjectUtil.defaultIfNull(executorBuilder.handler, new ThreadPoolExecutor.AbortPolicy());
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(n2, n3, l2, TimeUnit.NANOSECONDS, (BlockingQueue<Runnable>)((Object)abstractQueue), threadFactory, rejectedExecutionHandler);
        if (null != executorBuilder.allowCoreThreadTimeOut) {
            threadPoolExecutor.allowCoreThreadTimeOut(executorBuilder.allowCoreThreadTimeOut);
        }
        return threadPoolExecutor;
    }
}

