/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.text.csv;

import com.ccb.core.collection.CollUtil;
import com.ccb.core.convert.Convert;
import com.ccb.core.io.FileUtil;
import com.ccb.core.io.IORuntimeException;
import com.ccb.core.io.IoUtil;
import com.ccb.core.text.csv.CsvWriteConfig;
import com.ccb.core.util.ArrayUtil;
import com.ccb.core.util.CharsetUtil;
import com.ccb.core.util.ObjectUtil;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;

public final class CsvWriter
implements Closeable,
Flushable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Writer writer;
    private final CsvWriteConfig config;
    private boolean newline = true;

    public CsvWriter(String string) {
        this(FileUtil.file(string));
    }

    public CsvWriter(File file) {
        this(file, CharsetUtil.CHARSET_UTF_8);
    }

    public CsvWriter(String string, Charset charset) {
        this(FileUtil.file(string), charset);
    }

    public CsvWriter(File file, Charset charset) {
        this(file, charset, false);
    }

    public CsvWriter(String string, Charset charset, boolean bl) {
        this(FileUtil.file(string), charset, bl);
    }

    public CsvWriter(File file, Charset charset, boolean bl) {
        this(file, charset, bl, null);
    }

    public CsvWriter(String string, Charset charset, boolean bl, CsvWriteConfig csvWriteConfig) {
        this(FileUtil.file(string), charset, bl, csvWriteConfig);
    }

    public CsvWriter(File file, Charset charset, boolean bl, CsvWriteConfig csvWriteConfig) {
        this(FileUtil.getWriter(file, charset, bl), csvWriteConfig);
    }

    public CsvWriter(Writer writer) {
        this(writer, null);
    }

    public CsvWriter(Writer writer, CsvWriteConfig csvWriteConfig) {
        this.writer = writer instanceof BufferedWriter ? writer : new BufferedWriter(writer);
        this.config = (CsvWriteConfig)ObjectUtil.defaultIfNull(csvWriteConfig, CsvWriteConfig.defaultConfig());
    }

    public CsvWriter setAlwaysDelimitText(boolean bl) {
        this.config.setAlwaysDelimitText(bl);
        return this;
    }

    public CsvWriter setLineDelimiter(char[] cArray) {
        this.config.setLineDelimiter(cArray);
        return this;
    }

    public CsvWriter write(String[] ... stringArray) {
        if (ArrayUtil.isNotEmpty((Object[])stringArray)) {
            for (String[] stringArray2 : stringArray) {
                this.appendLine(stringArray2);
            }
            this.flush();
        }
        return this;
    }

    public CsvWriter write(Collection collection) {
        if (CollUtil.isNotEmpty(collection)) {
            for (Object e2 : collection) {
                this.appendLine(Convert.toStrArray(e2));
            }
            this.flush();
        }
        return this;
    }

    public void writeLine() {
        try {
            this.writer.write(this.config.lineDelimiter);
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
        this.newline = true;
    }

    @Override
    public void close() {
        IoUtil.close(this.writer);
    }

    @Override
    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    private void appendLine(String ... stringArray) {
        try {
            this.doAppendLine(stringArray);
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    private void doAppendLine(String ... stringArray) {
        if (null != stringArray) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                this.appendField(stringArray[i2]);
            }
            this.writer.write(this.config.lineDelimiter);
            this.newline = true;
        }
    }

    private void appendField(String string) {
        boolean bl = this.config.alwaysDelimitText;
        char c2 = this.config.textDelimiter;
        char c3 = this.config.fieldSeparator;
        if (!this.newline) {
            this.writer.write(c3);
        } else {
            this.newline = false;
        }
        if (null == string) {
            if (bl) {
                this.writer.write(new char[]{c2, c2});
            }
            return;
        }
        char[] cArray = string.toCharArray();
        boolean bl2 = bl;
        boolean bl3 = false;
        for (char c4 : cArray) {
            if (c4 == c2) {
                bl2 = true;
                bl3 = true;
                break;
            }
            if (c4 != c3 && c4 != '\n' && c4 != '\r') continue;
            bl2 = true;
        }
        if (bl2) {
            this.writer.write(c2);
        }
        if (bl3) {
            for (char c4 : cArray) {
                if (c4 == c2) {
                    this.writer.write(c2);
                }
                this.writer.write(c4);
            }
        } else {
            this.writer.write(cArray);
        }
        if (bl2) {
            this.writer.write(c2);
        }
    }
}

