/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.text.csv;

import com.ccb.core.bean.BeanUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public final class CsvRow
implements List {
    private final long originalLineNumber;
    final Map headerMap;
    final List fields;

    public CsvRow(long l2, Map map, List list) {
        this.originalLineNumber = l2;
        this.headerMap = map;
        this.fields = list;
    }

    public long getOriginalLineNumber() {
        return this.originalLineNumber;
    }

    public String getByName(String string) {
        if (this.headerMap == null) {
            throw new IllegalStateException("No header available");
        }
        Integer n2 = (Integer)this.headerMap.get(string);
        if (n2 != null) {
            return this.get(n2);
        }
        return null;
    }

    public List getRawList() {
        return this.fields;
    }

    public Map getFieldMap() {
        if (this.headerMap == null) {
            throw new IllegalStateException("No header available");
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(this.headerMap.size(), 1.0f);
        for (Map.Entry entry : this.headerMap.entrySet()) {
            String string = (String)entry.getKey();
            Integer n2 = (Integer)this.headerMap.get(string);
            String string2 = null == n2 ? null : this.get(n2);
            linkedHashMap.put(string, string2);
        }
        return linkedHashMap;
    }

    public Object toBean(Class clazz) {
        return BeanUtil.toBeanIgnoreError(this.getFieldMap(), clazz);
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    @Override
    public int size() {
        return this.fields.size();
    }

    @Override
    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.fields.contains(object);
    }

    @Override
    public Iterator iterator() {
        return this.fields.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.fields.toArray();
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        return this.fields.toArray(objectArray);
    }

    @Override
    public boolean add(String string) {
        return this.fields.add(string);
    }

    @Override
    public boolean remove(Object object) {
        return this.fields.remove(object);
    }

    @Override
    public boolean containsAll(Collection collection) {
        return this.fields.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection collection) {
        return this.fields.addAll(collection);
    }

    public boolean addAll(int n2, Collection collection) {
        return this.fields.addAll(n2, collection);
    }

    @Override
    public boolean removeAll(Collection collection) {
        return this.fields.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection collection) {
        return this.fields.retainAll(collection);
    }

    @Override
    public void clear() {
        this.fields.clear();
    }

    public String get(int n2) {
        return n2 >= this.fields.size() ? null : (String)this.fields.get(n2);
    }

    public String set(int n2, String string) {
        return this.fields.set(n2, string);
    }

    public void add(int n2, String string) {
        this.fields.add(n2, string);
    }

    public String remove(int n2) {
        return (String)this.fields.remove(n2);
    }

    @Override
    public int indexOf(Object object) {
        return this.fields.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.fields.lastIndexOf(object);
    }

    public ListIterator listIterator() {
        return this.fields.listIterator();
    }

    public ListIterator listIterator(int n2) {
        return this.fields.listIterator(n2);
    }

    public List subList(int n2, int n3) {
        return this.fields.subList(n2, n3);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("CsvRow{");
        stringBuilder.append("originalLineNumber=");
        stringBuilder.append(this.originalLineNumber);
        stringBuilder.append(", ");
        stringBuilder.append("fields=");
        if (this.headerMap != null) {
            stringBuilder.append('{');
            Iterator iterator = this.getFieldMap().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                stringBuilder.append((String)entry.getKey());
                stringBuilder.append('=');
                if (entry.getValue() != null) {
                    stringBuilder.append((String)entry.getValue());
                }
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append('}');
        } else {
            stringBuilder.append(this.fields.toString());
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

