/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.text;

import com.ccb.core.convert.Convert;
import com.ccb.core.util.ArrayUtil;
import java.io.Serializable;
import java.util.Arrays;

public class StrBuilder
implements Serializable,
Appendable,
CharSequence {
    private static final long serialVersionUID = 6341229705927508451L;
    public static final int DEFAULT_CAPACITY = 16;
    private char[] value;
    private int position;

    public static StrBuilder create() {
        return new StrBuilder();
    }

    public static StrBuilder create(int n2) {
        return new StrBuilder(n2);
    }

    public static StrBuilder create(CharSequence ... charSequenceArray) {
        return new StrBuilder(charSequenceArray);
    }

    public StrBuilder() {
        this(16);
    }

    public StrBuilder(int n2) {
        this.value = new char[n2];
    }

    public StrBuilder(CharSequence ... charSequenceArray) {
        this(ArrayUtil.isEmpty(charSequenceArray) ? 16 : StrBuilder.totalLength(charSequenceArray) + 16);
        for (CharSequence charSequence : charSequenceArray) {
            this.append(charSequence);
        }
    }

    public StrBuilder append(Object object) {
        return this.insert(this.position, object);
    }

    @Override
    public StrBuilder append(char c2) {
        return this.insert(this.position, c2);
    }

    public StrBuilder append(char[] cArray) {
        if (ArrayUtil.isEmpty(cArray)) {
            return this;
        }
        return this.append(cArray, 0, cArray.length);
    }

    public StrBuilder append(char[] cArray, int n2, int n3) {
        return this.insert(this.position, cArray, n2, n3);
    }

    @Override
    public StrBuilder append(CharSequence charSequence) {
        return this.insert(this.position, charSequence);
    }

    @Override
    public StrBuilder append(CharSequence charSequence, int n2, int n3) {
        return this.insert(this.position, charSequence, n2, n3);
    }

    public StrBuilder insert(int n2, Object object) {
        if (object instanceof CharSequence) {
            return this.insert(n2, (CharSequence)object);
        }
        return this.insert(n2, Convert.toStr(object));
    }

    public StrBuilder insert(int n2, char c2) {
        this.moveDataAfterIndex(n2, 1);
        this.value[n2] = c2;
        this.position = Math.max(this.position, n2) + 1;
        return this;
    }

    public StrBuilder insert(int n2, char[] cArray) {
        if (ArrayUtil.isEmpty(cArray)) {
            return this;
        }
        return this.insert(n2, cArray, 0, cArray.length);
    }

    public StrBuilder insert(int n2, char[] cArray, int n3, int n4) {
        if (ArrayUtil.isEmpty(cArray) || n3 > cArray.length || n4 <= 0) {
            return this;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 + n4 > cArray.length) {
            n4 = cArray.length - n3;
        }
        this.moveDataAfterIndex(n2, n4);
        System.arraycopy(cArray, n3, this.value, n2, n4);
        this.position = Math.max(this.position, n2) + n4;
        return this;
    }

    public StrBuilder insert(int n2, CharSequence charSequence) {
        if (null == charSequence) {
            charSequence = "null";
        }
        int n3 = charSequence.length();
        this.moveDataAfterIndex(n2, charSequence.length());
        if (charSequence instanceof String) {
            ((String)charSequence).getChars(0, n3, this.value, n2);
        } else if (charSequence instanceof StringBuilder) {
            ((StringBuilder)charSequence).getChars(0, n3, this.value, n2);
        } else if (charSequence instanceof StringBuffer) {
            ((StringBuffer)charSequence).getChars(0, n3, this.value, n2);
        } else if (charSequence instanceof StrBuilder) {
            ((StrBuilder)charSequence).getChars(0, n3, this.value, n2);
        } else {
            int n4 = 0;
            int n5 = this.position;
            while (n4 < n3) {
                this.value[n5] = charSequence.charAt(n4);
                ++n4;
                ++n5;
            }
        }
        this.position = Math.max(this.position, n2) + n3;
        return this;
    }

    public StrBuilder insert(int n2, CharSequence charSequence, int n3, int n4) {
        int n5;
        if (charSequence == null) {
            charSequence = "null";
        }
        if (n3 > (n5 = charSequence.length())) {
            return this;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n4 > n5) {
            n4 = n5;
        }
        if (n3 >= n4) {
            return this;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        int n6 = n4 - n3;
        this.moveDataAfterIndex(n2, n6);
        int n7 = n3;
        int n8 = this.position;
        while (n7 < n4) {
            this.value[n8] = charSequence.charAt(n7);
            ++n7;
            ++n8;
        }
        this.position = Math.max(this.position, n2) + n6;
        return this;
    }

    public StrBuilder getChars(int n2, int n3, char[] cArray, int n4) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 > this.position) {
            n3 = this.position;
        }
        if (n2 > n3) {
            throw new StringIndexOutOfBoundsException("srcBegin > srcEnd");
        }
        System.arraycopy(this.value, n2, cArray, n4, n3 - n2);
        return this;
    }

    public boolean hasContent() {
        return this.position > 0;
    }

    @Override
    public boolean isEmpty() {
        return this.position == 0;
    }

    public StrBuilder clear() {
        return this.reset();
    }

    public StrBuilder reset() {
        this.position = 0;
        return this;
    }

    public StrBuilder delTo(int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        return this.del(n2, this.position);
    }

    public StrBuilder del(int n2, int n3) {
        int n4;
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 >= this.position) {
            this.position = n2;
            return this;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if ((n4 = n3 - n2) > 0) {
            System.arraycopy(this.value, n2 + n4, this.value, n2, this.position - n3);
            this.position -= n4;
        } else if (n4 < 0) {
            throw new StringIndexOutOfBoundsException("Start is greater than End.");
        }
        return this;
    }

    public String toString(boolean bl) {
        if (this.position > 0) {
            String string = new String(this.value, 0, this.position);
            if (bl) {
                this.reset();
            }
            return string;
        }
        return "";
    }

    public String toStringAndReset() {
        return this.toString(true);
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    @Override
    public int length() {
        return this.position;
    }

    @Override
    public char charAt(int n2) {
        if (n2 < 0) {
            n2 = this.position + n2;
        }
        if (n2 < 0 || n2 > this.position) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        return this.value[n2];
    }

    @Override
    public CharSequence subSequence(int n2, int n3) {
        return this.subString(n2, n3);
    }

    public String subString(int n2) {
        return this.subString(n2, this.position);
    }

    public String subString(int n2, int n3) {
        return new String(this.value, n2, n3 - n2);
    }

    private void moveDataAfterIndex(int n2, int n3) {
        this.ensureCapacity(Math.max(this.position, n2) + n3);
        if (n2 < this.position) {
            System.arraycopy(this.value, n2, this.value, n2 + n3, this.position - n2);
        } else if (n2 > this.position) {
            Arrays.fill(this.value, this.position, n2, ' ');
        }
    }

    private void ensureCapacity(int n2) {
        if (n2 > this.value.length) {
            this.expandCapacity(n2);
        }
    }

    private void expandCapacity(int n2) {
        int n3 = this.value.length * 2 + 2;
        if (n3 < n2) {
            n3 = n2;
        }
        if (n3 < 0) {
            throw new OutOfMemoryError("Capacity is too long and max than Integer.MAX");
        }
        this.value = Arrays.copyOf(this.value, n3);
    }

    private static int totalLength(CharSequence ... charSequenceArray) {
        int n2 = 0;
        for (CharSequence charSequence : charSequenceArray) {
            n2 += null == charSequence ? 4 : charSequence.length();
        }
        return n2;
    }
}

