/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.swing.clipboard;

import com.ccb.core.swing.clipboard.ClipboardListener;
import com.ccb.core.swing.clipboard.ClipboardUtil;
import com.ccb.core.thread.ThreadUtil;
import com.ccb.core.util.ObjectUtil;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.io.Closeable;
import java.util.LinkedHashSet;
import java.util.Set;

public enum ClipboardMonitor implements ClipboardOwner,
Closeable,
Runnable
{
    INSTANCE;

    public static final int DEFAULT_TRY_COUNT = 10;
    public static final long DEFAULT_DELAY = 100L;
    private int tryCount;
    private long delay;
    private final Clipboard clipboard;
    private final Set listenerSet = new LinkedHashSet();
    private boolean isRunning;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private ClipboardMonitor() {
        this((String)var1_-1, (int)var2_-1, 10, 100L);
        void var2_-1;
        void var1_-1;
    }

    /*
     * WARNING - void declaration
     */
    private ClipboardMonitor() {
        this((String)var1_-1, (int)var2_-1, (int)var3_1, (long)var4_2, ClipboardUtil.getClipboard());
        void var4_2;
        void var3_1;
        void var2_-1;
        void var1_-1;
    }

    /*
     * WARNING - void declaration
     */
    private ClipboardMonitor(Clipboard clipboard) {
        void var6_3;
        void var3_1;
        this.tryCount = var3_1;
        this.delay = (long)clipboard;
        this.clipboard = var6_3;
    }

    public ClipboardMonitor setTryCount(int n2) {
        this.tryCount = n2;
        return this;
    }

    public ClipboardMonitor setDelay(long l2) {
        this.delay = l2;
        return this;
    }

    public ClipboardMonitor addListener(ClipboardListener clipboardListener) {
        this.listenerSet.add(clipboardListener);
        return this;
    }

    public ClipboardMonitor removeListener(ClipboardListener clipboardListener) {
        this.listenerSet.remove(clipboardListener);
        return this;
    }

    public ClipboardMonitor clearListener() {
        this.listenerSet.clear();
        return this;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        Transferable transferable2;
        try {
            transferable2 = this.tryGetContent(clipboard);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        Transferable transferable3 = null;
        for (ClipboardListener clipboardListener : this.listenerSet) {
            try {
                transferable3 = clipboardListener.onChange(clipboard, (Transferable)ObjectUtil.defaultIfNull(transferable3, transferable2));
            }
            catch (Throwable throwable) {}
        }
        if (this.isRunning) {
            clipboard.setContents((Transferable)ObjectUtil.defaultIfNull(transferable3, ObjectUtil.defaultIfNull(transferable2, transferable)), this);
        }
    }

    @Override
    public synchronized void run() {
        if (!this.isRunning) {
            Clipboard clipboard = this.clipboard;
            clipboard.setContents(clipboard.getContents(null), this);
            this.isRunning = true;
        }
    }

    public void listen(boolean bl) {
        this.run();
        if (bl) {
            ThreadUtil.sync(this);
        }
    }

    @Override
    public void close() {
        this.isRunning = false;
    }

    private Transferable tryGetContent(Clipboard clipboard) {
        Transferable transferable = null;
        for (int i2 = 0; i2 < this.tryCount; ++i2) {
            if (this.delay > 0L && i2 > 0) {
                Thread.sleep(this.delay);
            }
            try {
                transferable = clipboard.getContents(null);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (null == transferable) continue;
            return transferable;
        }
        return null;
    }
}

