/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.swing;

import com.ccb.core.exceptions.UtilException;
import com.ccb.core.img.ImgUtil;
import com.ccb.core.swing.ScreenUtil;
import com.ccb.core.swing.clipboard.ClipboardUtil;
import java.awt.AWTException;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.io.File;

public class RobotUtil {
    private static final Robot ROBOT;
    private static int delay;

    public static void setDelay(int n2) {
        delay = n2;
    }

    public static void mouseMove(int n2, int n3) {
        ROBOT.mouseMove(n2, n3);
    }

    public static void click() {
        ROBOT.mousePress(16);
        ROBOT.mouseRelease(16);
        RobotUtil.delay();
    }

    public static void rightClick() {
        ROBOT.mousePress(16);
        ROBOT.mouseRelease(16);
        RobotUtil.delay();
    }

    public static void mouseWheel(int n2) {
        ROBOT.mouseWheel(n2);
        RobotUtil.delay();
    }

    public static void keyClick(int ... nArray) {
        for (int n2 : nArray) {
            ROBOT.keyPress(n2);
            ROBOT.keyRelease(n2);
        }
        RobotUtil.delay();
    }

    public static void keyPressString(String string) {
        ClipboardUtil.setStr(string);
        RobotUtil.keyPressWithCtrl(86);
        RobotUtil.delay();
    }

    public static void keyPressWithShift(int n2) {
        ROBOT.keyPress(16);
        ROBOT.keyPress(n2);
        ROBOT.keyRelease(n2);
        ROBOT.keyRelease(16);
        RobotUtil.delay();
    }

    public static void keyPressWithCtrl(int n2) {
        ROBOT.keyPress(17);
        ROBOT.keyPress(n2);
        ROBOT.keyRelease(n2);
        ROBOT.keyRelease(17);
        RobotUtil.delay();
    }

    public static void keyPressWithAlt(int n2) {
        ROBOT.keyPress(18);
        ROBOT.keyPress(n2);
        ROBOT.keyRelease(n2);
        ROBOT.keyRelease(18);
        RobotUtil.delay();
    }

    public static BufferedImage captureScreen() {
        return RobotUtil.captureScreen(ScreenUtil.getRectangle());
    }

    public static File captureScreen(File file) {
        ImgUtil.write(RobotUtil.captureScreen(), file);
        return file;
    }

    public static BufferedImage captureScreen(Rectangle rectangle) {
        return ROBOT.createScreenCapture(rectangle);
    }

    public static File captureScreen(Rectangle rectangle, File file) {
        ImgUtil.write(RobotUtil.captureScreen(rectangle), file);
        return file;
    }

    private static void delay() {
        if (delay > 0) {
            ROBOT.delay(delay);
        }
    }

    static {
        try {
            ROBOT = new Robot();
        }
        catch (AWTException aWTException) {
            throw new UtilException(aWTException);
        }
    }
}

