/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.net.url;

import com.ccb.core.lang.Assert;
import com.ccb.core.net.url.UrlPath;
import com.ccb.core.net.url.UrlQuery;
import com.ccb.core.util.CharsetUtil;
import com.ccb.core.util.StrUtil;
import com.ccb.core.util.URLUtil;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.nio.charset.Charset;

public final class UrlBuilder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_SCHEME = "http";
    private String scheme;
    private String host;
    private int port = -1;
    private UrlPath path;
    private UrlQuery query;
    private String fragment;
    private Charset charset;

    public static UrlBuilder of(URI uRI, Charset charset) {
        return UrlBuilder.of(uRI.getScheme(), uRI.getHost(), uRI.getPort(), uRI.getPath(), uRI.getRawQuery(), uRI.getFragment(), charset);
    }

    public static UrlBuilder ofHttpWithoutEncode(String string) {
        return UrlBuilder.ofHttp(string, null);
    }

    public static UrlBuilder ofHttp(String string, Charset charset) {
        Assert.notBlank(string, "Http url must be not blank!", new Object[0]);
        int n2 = string.indexOf("://");
        if (n2 < 0) {
            string = "http://" + string.trim();
        }
        return UrlBuilder.of(string, charset);
    }

    public static UrlBuilder of(String string, Charset charset) {
        Assert.notBlank(string, "Url must be not blank!", new Object[0]);
        return UrlBuilder.of(URLUtil.url(string.trim()), charset);
    }

    public static UrlBuilder of(URL uRL, Charset charset) {
        return UrlBuilder.of(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), uRL.getPath(), uRL.getQuery(), uRL.getRef(), charset);
    }

    public static UrlBuilder of(String string, String string2, int n2, String string3, String string4, String string5, Charset charset) {
        return UrlBuilder.of(string, string2, n2, UrlPath.of(string3, charset), UrlQuery.of(string4, charset), string5, charset);
    }

    public static UrlBuilder of(String string, String string2, int n2, UrlPath urlPath, UrlQuery urlQuery, String string3, Charset charset) {
        return new UrlBuilder(string, string2, n2, urlPath, urlQuery, string3, charset);
    }

    public static UrlBuilder create() {
        return new UrlBuilder();
    }

    public UrlBuilder() {
        this.charset = CharsetUtil.CHARSET_UTF_8;
    }

    public UrlBuilder(String string, String string2, int n2, UrlPath urlPath, UrlQuery urlQuery, String string3, Charset charset) {
        this.charset = charset;
        this.scheme = string;
        this.host = string2;
        this.port = n2;
        this.path = urlPath;
        this.query = urlQuery;
        this.setFragment(string3);
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getSchemeWithDefault() {
        return StrUtil.emptyToDefault(this.scheme, DEFAULT_SCHEME);
    }

    public UrlBuilder setScheme(String string) {
        this.scheme = string;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public UrlBuilder setHost(String string) {
        this.host = string;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public UrlBuilder setPort(int n2) {
        this.port = n2;
        return this;
    }

    public String getAuthority() {
        return this.port < 0 ? this.host : this.host + ":" + this.port;
    }

    public UrlPath getPath() {
        return this.path;
    }

    public String getPathStr() {
        return null == this.path ? "/" : this.path.build(this.charset);
    }

    public UrlBuilder setPath(UrlPath urlPath) {
        this.path = urlPath;
        return this;
    }

    public UrlBuilder addPath(String string) {
        if (StrUtil.isBlank(string)) {
            return this;
        }
        if (null == this.path) {
            this.path = new UrlPath();
        }
        this.path.add(string);
        return this;
    }

    public UrlBuilder appendPath(CharSequence charSequence) {
        if (StrUtil.isEmpty(charSequence)) {
            return this;
        }
        if (this.path == null) {
            this.path = new UrlPath();
        }
        this.path.add(charSequence);
        return this;
    }

    public UrlQuery getQuery() {
        return this.query;
    }

    public String getQueryStr() {
        return null == this.query ? null : this.query.build(this.charset);
    }

    public UrlBuilder setQuery(UrlQuery urlQuery) {
        this.query = urlQuery;
        return this;
    }

    public UrlBuilder addQuery(String string, String string2) {
        if (StrUtil.isEmpty(string)) {
            return this;
        }
        if (this.query == null) {
            this.query = new UrlQuery();
        }
        this.query.add(string, string2);
        return this;
    }

    public String getFragment() {
        return this.fragment;
    }

    public String getFragmentEncoded() {
        return URLUtil.encodeAll(this.fragment, this.charset);
    }

    public UrlBuilder setFragment(String string) {
        if (StrUtil.isEmpty(string)) {
            this.fragment = null;
        }
        this.fragment = StrUtil.removePrefix(string, "#");
        return this;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public UrlBuilder setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public String build() {
        return this.toURL().toString();
    }

    public URL toURL() {
        return this.toURL(null);
    }

    public URL toURL(URLStreamHandler uRLStreamHandler) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StrUtil.blankToDefault(this.getPathStr(), "/"));
        String string = this.getQueryStr();
        if (StrUtil.isNotBlank(string)) {
            stringBuilder.append('?').append(string);
        }
        if (StrUtil.isNotBlank(this.fragment)) {
            stringBuilder.append('#').append(this.getFragmentEncoded());
        }
        try {
            return new URL(this.getSchemeWithDefault(), this.host, this.port, stringBuilder.toString(), uRLStreamHandler);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public URI toURI() {
        try {
            return new URI(this.getSchemeWithDefault(), this.getAuthority(), this.getPathStr(), this.getQueryStr(), this.getFragmentEncoded());
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public String toString() {
        return this.build();
    }
}

