/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.lang.hash;

import com.ccb.core.lang.hash.CityHash$OrderIter;
import com.ccb.core.lang.hash.Number128;
import java.util.Arrays;

public class CityHash {
    private static final long k0 = -4348849565147123417L;
    private static final long k1 = -5435081209227447693L;
    private static final long k2 = -7286425919675154353L;
    private static final long kMul = -7070675565921424023L;
    private static final int c1 = -862048943;
    private static final int c2 = 461845907;

    public static int hash32(byte[] byArray) {
        int n2;
        int n3 = byArray.length;
        if (n3 <= 24) {
            return n3 <= 12 ? (n3 <= 4 ? CityHash.hash32Len0to4(byArray) : CityHash.hash32Len5to12(byArray)) : CityHash.hash32Len13to24(byArray);
        }
        int n4 = n3;
        int n5 = n2 = -862048943 * n3;
        int n6 = CityHash.rotate32(CityHash.fetch32(byArray, n3 - 4) * -862048943, 17) * 461845907;
        int n7 = CityHash.rotate32(CityHash.fetch32(byArray, n3 - 8) * -862048943, 17) * 461845907;
        int n8 = CityHash.rotate32(CityHash.fetch32(byArray, n3 - 16) * -862048943, 17) * 461845907;
        int n9 = CityHash.rotate32(CityHash.fetch32(byArray, n3 - 12) * -862048943, 17) * 461845907;
        int n10 = CityHash.rotate32(CityHash.fetch32(byArray, n3 - 20) * -862048943, 17) * 461845907;
        n4 ^= n6;
        n4 = CityHash.rotate32(n4, 19);
        n4 = n4 * 5 + -430675100;
        n4 ^= n8;
        n4 = CityHash.rotate32(n4, 19);
        n4 = n4 * 5 + -430675100;
        n2 ^= n7;
        n2 = CityHash.rotate32(n2, 19);
        n2 = n2 * 5 + -430675100;
        n2 ^= n9;
        n2 = CityHash.rotate32(n2, 19);
        n2 = n2 * 5 + -430675100;
        n5 += n10;
        n5 = CityHash.rotate32(n5, 19);
        n5 = n5 * 5 + -430675100;
        int n11 = (n3 - 1) / 20;
        int n12 = 0;
        do {
            n6 = CityHash.rotate32(CityHash.fetch32(byArray, n12) * -862048943, 17) * 461845907;
            n7 = CityHash.fetch32(byArray, n12 + 4);
            n8 = CityHash.rotate32(CityHash.fetch32(byArray, n12 + 8) * -862048943, 17) * 461845907;
            n9 = CityHash.rotate32(CityHash.fetch32(byArray, n12 + 12) * -862048943, 17) * 461845907;
            n10 = CityHash.fetch32(byArray, n12 + 16);
            n4 ^= n6;
            n4 = CityHash.rotate32(n4, 18);
            n4 = n4 * 5 + -430675100;
            n5 += n7;
            n5 = CityHash.rotate32(n5, 19);
            n5 *= -862048943;
            n2 += n8;
            n2 = CityHash.rotate32(n2, 18);
            n2 = n2 * 5 + -430675100;
            n4 ^= n9 + n7;
            n4 = CityHash.rotate32(n4, 19);
            n4 = n4 * 5 + -430675100;
            n2 ^= n10;
            n2 = Integer.reverseBytes(n2) * 5;
            n4 += n10 * 5;
            n4 = Integer.reverseBytes(n4);
            int n13 = n5 += n6;
            n5 = n2;
            n2 = n4;
            n4 = n13;
            n12 += 20;
        } while (--n11 != 0);
        n2 = CityHash.rotate32(n2, 11) * -862048943;
        n2 = CityHash.rotate32(n2, 17) * -862048943;
        n5 = CityHash.rotate32(n5, 11) * -862048943;
        n5 = CityHash.rotate32(n5, 17) * -862048943;
        n4 = CityHash.rotate32(n4 + n2, 19);
        n4 = n4 * 5 + -430675100;
        n4 = CityHash.rotate32(n4, 17) * -862048943;
        n4 = CityHash.rotate32(n4 + n5, 19);
        n4 = n4 * 5 + -430675100;
        n4 = CityHash.rotate32(n4, 17) * -862048943;
        return n4;
    }

    public static long hash64(byte[] byArray) {
        int n2 = byArray.length;
        if (n2 <= 32) {
            if (n2 <= 16) {
                return CityHash.hashLen0to16(byArray);
            }
            return CityHash.hashLen17to32(byArray);
        }
        if (n2 <= 64) {
            return CityHash.hashLen33to64(byArray);
        }
        long l2 = CityHash.fetch64(byArray, n2 - 40);
        long l3 = CityHash.fetch64(byArray, n2 - 16) + CityHash.fetch64(byArray, n2 - 56);
        long l4 = CityHash.hashLen16(CityHash.fetch64(byArray, n2 - 48) + (long)n2, CityHash.fetch64(byArray, n2 - 24));
        Number128 number128 = CityHash.weakHashLen32WithSeeds(byArray, n2 - 64, n2, l4);
        Number128 number1282 = CityHash.weakHashLen32WithSeeds(byArray, n2 - 32, l3 + -5435081209227447693L, l2);
        l2 = l2 * -5435081209227447693L + CityHash.fetch64(byArray, 0);
        n2 = n2 - 1 & 0xFFFFFFC0;
        int n3 = 0;
        do {
            l2 = CityHash.rotate(l2 + l3 + number128.getLowValue() + CityHash.fetch64(byArray, n3 + 8), 37) * -5435081209227447693L;
            l3 = CityHash.rotate(l3 + number128.getHighValue() + CityHash.fetch64(byArray, n3 + 48), 42) * -5435081209227447693L;
            l4 = CityHash.rotate(l4 + number1282.getLowValue(), 33) * -5435081209227447693L;
            number128 = CityHash.weakHashLen32WithSeeds(byArray, n3, number128.getHighValue() * -5435081209227447693L, (l2 ^= number1282.getHighValue()) + number1282.getLowValue());
            number1282 = CityHash.weakHashLen32WithSeeds(byArray, n3 + 32, l4 + number1282.getHighValue(), (l3 += number128.getLowValue() + CityHash.fetch64(byArray, n3 + 40)) + CityHash.fetch64(byArray, n3 + 16));
            long l5 = l2;
            l2 = l4;
            l4 = l5;
            n3 += 64;
        } while ((n2 -= 64) != 0);
        return CityHash.hashLen16(CityHash.hashLen16(number128.getLowValue(), number1282.getLowValue()) + CityHash.shiftMix(l3) * -5435081209227447693L + l4, CityHash.hashLen16(number128.getHighValue(), number1282.getHighValue()) + l2);
    }

    public static long hash64(byte[] byArray, long l2, long l3) {
        return CityHash.hashLen16(CityHash.hash64(byArray) - l2, l3);
    }

    public static long hash64(byte[] byArray, long l2) {
        return CityHash.hash64(byArray, -7286425919675154353L, l2);
    }

    public static Number128 hash128(byte[] byArray) {
        int n2 = byArray.length;
        return n2 >= 16 ? CityHash.hash128(byArray, 16, new Number128(CityHash.fetch64(byArray, 0), CityHash.fetch64(byArray, 8) + -4348849565147123417L)) : CityHash.hash128(byArray, 0, new Number128(-4348849565147123417L, -5435081209227447693L));
    }

    public static Number128 hash128(byte[] byArray, Number128 number128) {
        return CityHash.hash128(byArray, 0, number128);
    }

    private static Number128 hash128(byte[] byArray, int n2, Number128 number128) {
        int n3 = byArray.length - n2;
        if (n3 < 128) {
            return CityHash.cityMurmur(Arrays.copyOfRange(byArray, n2, byArray.length), number128);
        }
        Number128 number1282 = new Number128(0L, 0L);
        Number128 number1283 = new Number128(0L, 0L);
        long l2 = number128.getLowValue();
        long l3 = number128.getHighValue();
        long l4 = (long)n3 * -5435081209227447693L;
        number1282.setLowValue(CityHash.rotate(l3 ^ 0xB492B66FBE98F273L, 49) * -5435081209227447693L + CityHash.fetch64(byArray, n2));
        number1282.setHighValue(CityHash.rotate(number1282.getLowValue(), 42) * -5435081209227447693L + CityHash.fetch64(byArray, n2 + 8));
        number1283.setLowValue(CityHash.rotate(l3 + l4, 35) * -5435081209227447693L + l2);
        number1283.setHighValue(CityHash.rotate(l2 + CityHash.fetch64(byArray, n2 + 88), 53) * -5435081209227447693L);
        int n4 = n2;
        do {
            l2 = CityHash.rotate(l2 + l3 + number1282.getLowValue() + CityHash.fetch64(byArray, n4 + 8), 37) * -5435081209227447693L;
            l3 = CityHash.rotate(l3 + number1282.getHighValue() + CityHash.fetch64(byArray, n4 + 48), 42) * -5435081209227447693L;
            l3 += number1282.getLowValue() + CityHash.fetch64(byArray, n4 + 40);
            l4 = CityHash.rotate(l4 + number1283.getLowValue(), 33) * -5435081209227447693L;
            number1282 = CityHash.weakHashLen32WithSeeds(byArray, n4, number1282.getHighValue() * -5435081209227447693L, (l2 ^= number1283.getHighValue()) + number1283.getLowValue());
            number1283 = CityHash.weakHashLen32WithSeeds(byArray, n4 + 32, l4 + number1283.getHighValue(), l3 + CityHash.fetch64(byArray, n4 + 16));
            long l5 = l2;
            l2 = l4;
            l4 = l5;
            l2 = CityHash.rotate(l2 + l3 + number1282.getLowValue() + CityHash.fetch64(byArray, (n4 += 64) + 8), 37) * -5435081209227447693L;
            l3 = CityHash.rotate(l3 + number1282.getHighValue() + CityHash.fetch64(byArray, n4 + 48), 42) * -5435081209227447693L;
            l3 += number1282.getLowValue() + CityHash.fetch64(byArray, n4 + 40);
            l4 = CityHash.rotate(l4 + number1283.getLowValue(), 33) * -5435081209227447693L;
            number1282 = CityHash.weakHashLen32WithSeeds(byArray, n4, number1282.getHighValue() * -5435081209227447693L, (l2 ^= number1283.getHighValue()) + number1283.getLowValue());
            number1283 = CityHash.weakHashLen32WithSeeds(byArray, n4 + 32, l4 + number1283.getHighValue(), l3 + CityHash.fetch64(byArray, n4 + 16));
            l5 = l2;
            l2 = l4;
            l4 = l5;
            n4 += 64;
        } while ((n3 -= 128) >= 128);
        l2 += CityHash.rotate(number1282.getLowValue() + l4, 49) * -4348849565147123417L;
        l3 = l3 * -4348849565147123417L + CityHash.rotate(number1283.getHighValue(), 37);
        l4 = l4 * -4348849565147123417L + CityHash.rotate(number1283.getLowValue(), 27);
        number1283.setLowValue(number1283.getLowValue() * 9L);
        number1282.setLowValue(number1282.getLowValue() * -4348849565147123417L);
        int n5 = 0;
        while (n5 < n3) {
            l3 = CityHash.rotate(l2 + l3, 42) * -4348849565147123417L + number1282.getHighValue();
            number1283.setLowValue(number1283.getLowValue() + CityHash.fetch64(byArray, n4 + n3 - (n5 += 32) + 16));
            l2 = l2 * -4348849565147123417L + number1283.getLowValue();
            number1283.setHighValue(number1283.getHighValue() + number1282.getLowValue());
            number1282 = CityHash.weakHashLen32WithSeeds(byArray, n4 + n3 - n5, number1282.getLowValue() + (l4 += number1283.getHighValue() + CityHash.fetch64(byArray, n4 + n3 - n5)), number1282.getHighValue());
            number1282.setLowValue(number1282.getLowValue() * -4348849565147123417L);
        }
        l2 = CityHash.hashLen16(l2, number1282.getLowValue());
        l3 = CityHash.hashLen16(l3 + l4, number1283.getLowValue());
        return new Number128(CityHash.hashLen16(l2 + number1282.getHighValue(), number1283.getHighValue()) + l3, CityHash.hashLen16(l2 + number1283.getHighValue(), l3 + number1282.getHighValue()));
    }

    private static int hash32Len0to4(byte[] byArray) {
        int n2 = 0;
        int n3 = 9;
        int n4 = byArray.length;
        for (byte by : byArray) {
            n2 = n2 * -862048943 + by;
            n3 ^= n2;
        }
        return CityHash.fmix(CityHash.mur(n2, CityHash.mur(n4, n3)));
    }

    private static int hash32Len5to12(byte[] byArray) {
        int n2;
        int n3 = n2 = byArray.length;
        int n4 = n2 * 5;
        int n5 = 9;
        int n6 = n4;
        return CityHash.fmix(CityHash.mur(n5 += CityHash.fetch32(byArray, n2 >>> 1 & 4), CityHash.mur(n4 += CityHash.fetch32(byArray, n2 - 4), CityHash.mur(n3 += CityHash.fetch32(byArray, 0), n6))));
    }

    private static int hash32Len13to24(byte[] byArray) {
        int n2 = byArray.length;
        int n3 = CityHash.fetch32(byArray, (n2 >>> 1) - 4);
        int n4 = CityHash.fetch32(byArray, 4);
        int n5 = CityHash.fetch32(byArray, n2 - 8);
        int n6 = CityHash.fetch32(byArray, n2 >>> 1);
        int n7 = CityHash.fetch32(byArray, 0);
        int n8 = CityHash.fetch32(byArray, n2 - 4);
        int n9 = n2;
        return CityHash.fmix(CityHash.mur(n8, CityHash.mur(n7, CityHash.mur(n6, CityHash.mur(n5, CityHash.mur(n4, CityHash.mur(n3, n9)))))));
    }

    private static long hashLen0to16(byte[] byArray) {
        int n2 = byArray.length;
        if (n2 >= 8) {
            long l2 = -7286425919675154353L + (long)(n2 * 2);
            long l3 = CityHash.fetch64(byArray, 0) + -7286425919675154353L;
            long l4 = CityHash.fetch64(byArray, n2 - 8);
            long l5 = CityHash.rotate(l4, 37) * l2 + l3;
            long l6 = (CityHash.rotate(l3, 25) + l4) * l2;
            return CityHash.hashLen16(l5, l6, l2);
        }
        if (n2 >= 4) {
            long l7 = -7286425919675154353L + (long)(n2 * 2);
            long l8 = (long)CityHash.fetch32(byArray, 0) & 0xFFFFFFFFL;
            return CityHash.hashLen16((long)n2 + (l8 << 3), (long)CityHash.fetch32(byArray, n2 - 4) & 0xFFFFFFFFL, l7);
        }
        if (n2 > 0) {
            int n3 = byArray[0] & 0xFF;
            int n4 = byArray[n2 >>> 1] & 0xFF;
            int n5 = byArray[n2 - 1] & 0xFF;
            int n6 = n3 + (n4 << 8);
            int n7 = n2 + (n5 << 2);
            return CityHash.shiftMix((long)n6 * -7286425919675154353L ^ (long)n7 * -4348849565147123417L) * -7286425919675154353L;
        }
        return -7286425919675154353L;
    }

    private static long hashLen17to32(byte[] byArray) {
        int n2 = byArray.length;
        long l2 = -7286425919675154353L + (long)(n2 * 2);
        long l3 = CityHash.fetch64(byArray, 0) * -5435081209227447693L;
        long l4 = CityHash.fetch64(byArray, 8);
        long l5 = CityHash.fetch64(byArray, n2 - 8) * l2;
        long l6 = CityHash.fetch64(byArray, n2 - 16) * -7286425919675154353L;
        return CityHash.hashLen16(CityHash.rotate(l3 + l4, 43) + CityHash.rotate(l5, 30) + l6, l3 + CityHash.rotate(l4 + -7286425919675154353L, 18) + l5, l2);
    }

    private static long hashLen33to64(byte[] byArray) {
        int n2 = byArray.length;
        long l2 = -7286425919675154353L + (long)(n2 * 2);
        long l3 = CityHash.fetch64(byArray, 0) * -7286425919675154353L;
        long l4 = CityHash.fetch64(byArray, 8);
        long l5 = CityHash.fetch64(byArray, n2 - 24);
        long l6 = CityHash.fetch64(byArray, n2 - 32);
        long l7 = CityHash.fetch64(byArray, 16) * -7286425919675154353L;
        long l8 = CityHash.fetch64(byArray, 24) * 9L;
        long l9 = CityHash.fetch64(byArray, n2 - 8);
        long l10 = CityHash.fetch64(byArray, n2 - 16) * l2;
        long l11 = CityHash.rotate(l3 + l9, 43) + (CityHash.rotate(l4, 30) + l5) * 9L;
        long l12 = (l3 + l9 ^ l6) + l8 + 1L;
        long l13 = Long.reverseBytes((l11 + l12) * l2) + l10;
        long l14 = CityHash.rotate(l7 + l8, 42) + l5;
        long l15 = (Long.reverseBytes((l12 + l13) * l2) + l9) * l2;
        long l16 = l7 + l8 + l5;
        l3 = Long.reverseBytes((l14 + l16) * l2 + l15) + l4;
        l4 = CityHash.shiftMix((l16 + l3) * l2 + l6 + l10) * l2;
        return l4 + l14;
    }

    private static long loadUnaligned64(byte[] byArray, int n2) {
        long l2 = 0L;
        CityHash$OrderIter cityHash$OrderIter = new CityHash$OrderIter(8);
        while (cityHash$OrderIter.hasNext()) {
            int n3 = cityHash$OrderIter.next();
            long l3 = ((long)byArray[n3 + n2] & 0xFFL) << n3 * 8;
            l2 |= l3;
        }
        return l2;
    }

    private static int loadUnaligned32(byte[] byArray, int n2) {
        int n3 = 0;
        CityHash$OrderIter cityHash$OrderIter = new CityHash$OrderIter(4);
        while (cityHash$OrderIter.hasNext()) {
            int n4 = cityHash$OrderIter.next();
            int n5 = (byArray[n4 + n2] & 0xFF) << n4 * 8;
            n3 |= n5;
        }
        return n3;
    }

    private static long fetch64(byte[] byArray, int n2) {
        return CityHash.loadUnaligned64(byArray, n2);
    }

    private static int fetch32(byte[] byArray, int n2) {
        return CityHash.loadUnaligned32(byArray, n2);
    }

    private static long rotate(long l2, int n2) {
        return n2 == 0 ? l2 : l2 >>> n2 | l2 << 64 - n2;
    }

    private static int rotate32(int n2, int n3) {
        return n3 == 0 ? n2 : n2 >>> n3 | n2 << 32 - n3;
    }

    private static long hashLen16(long l2, long l3, long l4) {
        long l5 = (l2 ^ l3) * l4;
        l5 ^= l5 >>> 47;
        long l6 = (l3 ^ l5) * l4;
        l6 ^= l6 >>> 47;
        return l6 *= l4;
    }

    private static long hashLen16(long l2, long l3) {
        return CityHash.hash128to64(new Number128(l2, l3));
    }

    private static long hash128to64(Number128 number128) {
        long l2 = (number128.getLowValue() ^ number128.getHighValue()) * -7070675565921424023L;
        l2 ^= l2 >>> 47;
        long l3 = (number128.getHighValue() ^ l2) * -7070675565921424023L;
        l3 ^= l3 >>> 47;
        return l3 *= -7070675565921424023L;
    }

    private static long shiftMix(long l2) {
        return l2 ^ l2 >>> 47;
    }

    private static int fmix(int n2) {
        n2 ^= n2 >>> 16;
        n2 *= -2048144789;
        n2 ^= n2 >>> 13;
        n2 *= -1028477387;
        n2 ^= n2 >>> 16;
        return n2;
    }

    private static int mur(int n2, int n3) {
        n2 *= -862048943;
        n2 = CityHash.rotate32(n2, 17);
        n3 ^= (n2 *= 461845907);
        n3 = CityHash.rotate32(n3, 19);
        return n3 * 5 + -430675100;
    }

    private static Number128 weakHashLen32WithSeeds(long l2, long l3, long l4, long l5, long l6, long l7) {
        l7 = CityHash.rotate(l7 + (l6 += l2) + l5, 21);
        long l8 = l6;
        l6 += l3;
        return new Number128(l6 + l5, (l7 += CityHash.rotate(l6 += l4, 44)) + l8);
    }

    private static Number128 weakHashLen32WithSeeds(byte[] byArray, int n2, long l2, long l3) {
        return CityHash.weakHashLen32WithSeeds(CityHash.fetch64(byArray, n2), CityHash.fetch64(byArray, n2 + 8), CityHash.fetch64(byArray, n2 + 16), CityHash.fetch64(byArray, n2 + 24), l2, l3);
    }

    private static Number128 cityMurmur(byte[] byArray, Number128 number128) {
        long l2;
        long l3;
        int n2 = byArray.length;
        long l4 = number128.getLowValue();
        long l5 = number128.getHighValue();
        int n3 = n2 - 16;
        if (n3 <= 0) {
            l4 = CityHash.shiftMix(l4 * -5435081209227447693L) * -5435081209227447693L;
            l3 = l5 * -5435081209227447693L + CityHash.hashLen0to16(byArray);
            l2 = CityHash.shiftMix(l4 + (n2 >= 8 ? CityHash.fetch64(byArray, 0) : l3));
        } else {
            l3 = CityHash.hashLen16(CityHash.fetch64(byArray, n2 - 8) + -5435081209227447693L, l4);
            l2 = CityHash.hashLen16(l5 + (long)n2, l3 + CityHash.fetch64(byArray, n2 - 16));
            l4 += l2;
            int n4 = 0;
            do {
                l4 ^= CityHash.shiftMix(CityHash.fetch64(byArray, n4) * -5435081209227447693L) * -5435081209227447693L;
                l5 ^= (l4 *= -5435081209227447693L);
                l3 ^= CityHash.shiftMix(CityHash.fetch64(byArray, n4 + 8) * -5435081209227447693L) * -5435081209227447693L;
                l2 ^= (l3 *= -5435081209227447693L);
                n4 += 16;
            } while ((n3 -= 16) > 0);
        }
        l4 = CityHash.hashLen16(l4, l3);
        l5 = CityHash.hashLen16(l2, l5);
        return new Number128(l4 ^ l5, CityHash.hashLen16(l5, l4));
    }
}

