/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.lang;

import com.ccb.core.lang.Assert;
import com.ccb.core.lang.SimpleCache;
import com.ccb.core.lang.func.Func0;
import com.ccb.core.util.ArrayUtil;
import com.ccb.core.util.ClassUtil;
import com.ccb.core.util.ReflectUtil;
import com.ccb.core.util.StrUtil;
import java.util.HashMap;

public final class Singleton {
    private static final SimpleCache POOL = new SimpleCache(new HashMap());

    private Singleton() {
    }

    public static Object get(Class clazz, Object ... objectArray) {
        Assert.notNull(clazz, "Class must be not null !", new Object[0]);
        String string = Singleton.buildKey(clazz.getName(), objectArray);
        return Singleton.get(string, () -> ReflectUtil.newInstance(clazz, objectArray));
    }

    public static Object get(String string, Func0 func0) {
        return POOL.get(string, func0::call);
    }

    public static Object get(String string, Object ... objectArray) {
        Assert.notBlank(string, "Class name must be not blank !", new Object[0]);
        Class clazz = ClassUtil.loadClass(string);
        return Singleton.get(clazz, objectArray);
    }

    public static void put(Object object) {
        Assert.notNull(object, "Bean object must be not null !", new Object[0]);
        Singleton.put(object.getClass().getName(), object);
    }

    public static void put(String string, Object object) {
        POOL.put(string, object);
    }

    public static void remove(Class clazz) {
        if (null != clazz) {
            Singleton.remove(clazz.getName());
        }
    }

    public static void remove(String string) {
        POOL.remove(string);
    }

    public static void destroy() {
        POOL.clear();
    }

    private static String buildKey(String string, Object ... objectArray) {
        if (ArrayUtil.isEmpty(objectArray)) {
            return string;
        }
        return StrUtil.format((CharSequence)"{}#{}", string, ArrayUtil.join(objectArray, (CharSequence)"_"));
    }
}

