/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.lang;

import com.ccb.core.date.DateUtil;
import com.ccb.core.util.ClassLoaderUtil;
import com.ccb.core.util.RandomUtil;
import com.ccb.core.util.StrUtil;
import java.lang.management.ManagementFactory;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicInteger;

public class ObjectId {
    private static final AtomicInteger NEXT_INC = new AtomicInteger(RandomUtil.randomInt());
    private static final int MACHINE = ObjectId.getMachinePiece() | ObjectId.getProcessPiece();

    public static boolean isValid(String string) {
        if (string == null) {
            return false;
        }
        int n2 = (string = StrUtil.removeAll((CharSequence)string, "-")).length();
        if (n2 != 24) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'f' || c2 >= 'A' && c2 <= 'F') continue;
            return false;
        }
        return true;
    }

    public static byte[] nextBytes() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[12]);
        byteBuffer.putInt((int)DateUtil.currentSeconds());
        byteBuffer.putInt(MACHINE);
        byteBuffer.putInt(NEXT_INC.getAndIncrement());
        return byteBuffer.array();
    }

    public static String next() {
        return ObjectId.next(false);
    }

    public static String next(boolean bl) {
        byte[] byArray = ObjectId.nextBytes();
        StringBuilder stringBuilder = new StringBuilder(bl ? 26 : 24);
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2;
            if (bl && i2 % 4 == 0 && i2 != 0) {
                stringBuilder.append("-");
            }
            if ((n2 = byArray[i2] & 0xFF) < 16) {
                stringBuilder.append('0');
            }
            stringBuilder.append(Integer.toHexString(n2));
        }
        return stringBuilder.toString();
    }

    private static int getMachinePiece() {
        int n2;
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                stringBuilder.append(networkInterface.toString());
            }
            n2 = stringBuilder.toString().hashCode() << 16;
        }
        catch (Throwable throwable) {
            n2 = RandomUtil.randomInt() << 16;
        }
        return n2;
    }

    private static int getProcessPiece() {
        int n2;
        int n3;
        Object object;
        try {
            object = ManagementFactory.getRuntimeMXBean().getName();
            n3 = ((String)object).indexOf(64);
            n2 = n3 > 0 ? Integer.parseInt(((String)object).substring(0, n3)) : ((String)object).hashCode();
        }
        catch (Throwable throwable) {
            n2 = RandomUtil.randomInt();
        }
        object = ClassLoaderUtil.getClassLoader();
        n3 = object != null ? System.identityHashCode(object) : 0;
        String string = Integer.toHexString(n2) + Integer.toHexString(n3);
        int n4 = string.hashCode() & 0xFFFF;
        return n4;
    }
}

