/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.lang;

import com.ccb.core.exceptions.UtilException;
import com.ccb.core.io.FileUtil;
import com.ccb.core.util.ClassUtil;
import com.ccb.core.util.ReflectUtil;
import com.ccb.core.util.URLUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;

public class JarClassLoader
extends URLClassLoader {
    public static JarClassLoader load(File file) {
        JarClassLoader jarClassLoader = new JarClassLoader();
        jarClassLoader.addJar(file);
        jarClassLoader.addURL(file);
        return jarClassLoader;
    }

    public static JarClassLoader loadJar(File file) {
        JarClassLoader jarClassLoader = new JarClassLoader();
        jarClassLoader.addJar(file);
        return jarClassLoader;
    }

    public static void loadJar(URLClassLoader uRLClassLoader, File file) {
        try {
            Method method = ClassUtil.getDeclaredMethod(URLClassLoader.class, "addURL", URL.class);
            if (null != method) {
                method.setAccessible(true);
                List list = JarClassLoader.loopJar(file);
                for (File file2 : list) {
                    ReflectUtil.invoke((Object)uRLClassLoader, method, file2.toURI().toURL());
                }
            }
        }
        catch (IOException iOException) {
            throw new UtilException(iOException);
        }
    }

    public static URLClassLoader loadJarToSystemClassLoader(File file) {
        URLClassLoader uRLClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        JarClassLoader.loadJar(uRLClassLoader, file);
        return uRLClassLoader;
    }

    public JarClassLoader() {
        this(new URL[0]);
    }

    public JarClassLoader(URL[] uRLArray) {
        super(uRLArray, ClassUtil.getClassLoader());
    }

    public JarClassLoader addJar(File file) {
        if (JarClassLoader.isJarFile(file)) {
            return this.addURL(file);
        }
        List list = JarClassLoader.loopJar(file);
        for (File file2 : list) {
            this.addURL(file2);
        }
        return this;
    }

    @Override
    public void addURL(URL uRL) {
        super.addURL(uRL);
    }

    public JarClassLoader addURL(File file) {
        super.addURL(URLUtil.getURL(file));
        return this;
    }

    private static List loopJar(File file) {
        return FileUtil.loopFiles(file, JarClassLoader::isJarFile);
    }

    private static boolean isJarFile(File file) {
        if (!FileUtil.isFile(file)) {
            return false;
        }
        return file.getPath().toLowerCase().endsWith(".jar");
    }
}

