/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.io.resource;

import com.ccb.core.collection.CollUtil;
import com.ccb.core.io.resource.Resource;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;

public class MultiResource
implements Resource,
Serializable,
Iterable,
Iterator {
    private static final long serialVersionUID = 1L;
    private final List resources;
    private int cursor;

    public MultiResource(Resource ... resourceArray) {
        this(CollUtil.newArrayList(resourceArray));
    }

    public MultiResource(Collection collection) {
        this.resources = collection instanceof List ? (List)collection : CollUtil.newArrayList(collection);
    }

    @Override
    public String getName() {
        return ((Resource)this.resources.get(this.cursor)).getName();
    }

    @Override
    public URL getUrl() {
        return ((Resource)this.resources.get(this.cursor)).getUrl();
    }

    @Override
    public InputStream getStream() {
        return ((Resource)this.resources.get(this.cursor)).getStream();
    }

    @Override
    public BufferedReader getReader(Charset charset) {
        return ((Resource)this.resources.get(this.cursor)).getReader(charset);
    }

    @Override
    public String readStr(Charset charset) {
        return ((Resource)this.resources.get(this.cursor)).readStr(charset);
    }

    @Override
    public String readUtf8Str() {
        return ((Resource)this.resources.get(this.cursor)).readUtf8Str();
    }

    @Override
    public byte[] readBytes() {
        return ((Resource)this.resources.get(this.cursor)).readBytes();
    }

    public Iterator iterator() {
        return this.resources.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.resources.size();
    }

    public synchronized Resource next() {
        if (this.cursor >= this.resources.size()) {
            throw new ConcurrentModificationException();
        }
        ++this.cursor;
        return this;
    }

    @Override
    public void remove() {
        this.resources.remove(this.cursor);
    }

    public synchronized void reset() {
        this.cursor = 0;
    }

    public MultiResource add(Resource resource) {
        this.resources.add(resource);
        return this;
    }
}

