/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.io.file;

import com.ccb.core.io.FileUtil;
import com.ccb.core.io.IORuntimeException;
import com.ccb.core.io.IoUtil;
import com.ccb.core.io.LineHandler;
import com.ccb.core.io.file.FileReader$ReaderHandler;
import com.ccb.core.io.file.FileWrapper;
import com.ccb.core.util.CharsetUtil;
import com.ccb.core.util.StrUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FileReader
extends FileWrapper {
    private static final long serialVersionUID = 1L;

    public static FileReader create(File file, Charset charset) {
        return new FileReader(file, charset);
    }

    public static FileReader create(File file) {
        return new FileReader(file);
    }

    public FileReader(File file, Charset charset) {
        super(file, charset);
        this.checkFile();
    }

    public FileReader(File file, String string) {
        this(file, CharsetUtil.charset(string));
    }

    public FileReader(String string, Charset charset) {
        this(FileUtil.file(string), charset);
    }

    public FileReader(String string, String string2) {
        this(FileUtil.file(string), CharsetUtil.charset(string2));
    }

    public FileReader(File file) {
        this(file, DEFAULT_CHARSET);
    }

    public FileReader(String string) {
        this(string, DEFAULT_CHARSET);
    }

    public byte[] readBytes() {
        long l2 = this.file.length();
        if (l2 >= Integer.MAX_VALUE) {
            throw new IORuntimeException("File is larger then max array size");
        }
        byte[] byArray = new byte[(int)l2];
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.file);
            int n2 = fileInputStream.read(byArray);
            if ((long)n2 < l2) {
                throw new IOException(StrUtil.format((CharSequence)"File length is [{}] but read [{}]!", l2, n2));
            }
        }
        catch (Exception exception) {
            try {
                throw new IORuntimeException(exception);
            }
            catch (Throwable throwable) {
                IoUtil.close(fileInputStream);
                throw throwable;
            }
        }
        IoUtil.close(fileInputStream);
        return byArray;
    }

    public String readString() {
        return new String(this.readBytes(), this.charset);
    }

    public Collection readLines(Collection collection) {
        Collection collection2;
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = FileUtil.getReader(this.file, this.charset);
            while ((string = bufferedReader.readLine()) != null) {
                collection.add(string);
            }
            collection2 = collection;
        }
        catch (IOException iOException) {
            try {
                throw new IORuntimeException(iOException);
            }
            catch (Throwable throwable) {
                IoUtil.close(bufferedReader);
                throw throwable;
            }
        }
        IoUtil.close(bufferedReader);
        return collection2;
    }

    public void readLines(LineHandler lineHandler) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = FileUtil.getReader(this.file, this.charset);
            IoUtil.readLines((Reader)bufferedReader, lineHandler);
        }
        catch (Throwable throwable) {
            IoUtil.close(bufferedReader);
            throw throwable;
        }
        IoUtil.close(bufferedReader);
    }

    public List readLines() {
        return (List)this.readLines(new ArrayList());
    }

    public Object read(FileReader$ReaderHandler fileReader$ReaderHandler) {
        Object object;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = FileUtil.getReader(this.file, this.charset);
            object = fileReader$ReaderHandler.handle(bufferedReader);
        }
        catch (IOException iOException) {
            try {
                throw new IORuntimeException(iOException);
            }
            catch (Throwable throwable) {
                IoUtil.close(bufferedReader);
                throw throwable;
            }
        }
        IoUtil.close(bufferedReader);
        return object;
    }

    public BufferedReader getReader() {
        return IoUtil.getReader((InputStream)this.getInputStream(), this.charset);
    }

    public BufferedInputStream getInputStream() {
        try {
            return new BufferedInputStream(new FileInputStream(this.file));
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long writeToStream(OutputStream outputStream) {
        try (FileInputStream fileInputStream = new FileInputStream(this.file);){
            long l2 = IoUtil.copy((InputStream)fileInputStream, outputStream);
            return l2;
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    private void checkFile() {
        if (!this.file.exists()) {
            throw new IORuntimeException("File not exist: " + this.file);
        }
        if (!this.file.isFile()) {
            throw new IORuntimeException("Not a file:" + this.file);
        }
    }
}

