/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.io.checksum;

import java.io.Serializable;
import java.util.zip.Checksum;

public class CRC8
implements Serializable,
Checksum {
    private static final long serialVersionUID = 1L;
    private final short init;
    private final short[] crcTable = new short[256];
    private short value;

    public CRC8(int n2, short s2) {
        this.value = this.init = s2;
        for (int i2 = 0; i2 < 256; ++i2) {
            int n3 = i2;
            for (int i3 = 0; i3 < 8; ++i3) {
                if ((n3 & 1) != 0) {
                    n3 = n3 >>> 1 ^ n2;
                    continue;
                }
                n3 >>>= 1;
            }
            this.crcTable[i2] = (short)n3;
        }
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = byArray[n2 + i2] ^ this.value;
            this.value = (short)(this.crcTable[n4 & 0xFF] ^ this.value << 8);
        }
    }

    @Override
    public void update(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
    }

    @Override
    public void update(int n2) {
        this.update(new byte[]{(byte)n2}, 0, 1);
    }

    @Override
    public long getValue() {
        return this.value & 0xFF;
    }

    @Override
    public void reset() {
        this.value = this.init;
    }
}

