/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.io;

import com.ccb.core.convert.Convert;
import com.ccb.core.exceptions.UtilException;
import com.ccb.core.io.FastByteArrayOutputStream;
import com.ccb.core.io.IORuntimeException;
import com.ccb.core.io.LineHandler;
import com.ccb.core.io.NullOutputStream;
import com.ccb.core.io.StreamProgress;
import com.ccb.core.io.ValidateObjectInputStream;
import com.ccb.core.lang.Assert;
import com.ccb.core.util.CharsetUtil;
import com.ccb.core.util.HexUtil;
import com.ccb.core.util.StrUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Objects;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;

public class IoUtil {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final int DEFAULT_MIDDLE_BUFFER_SIZE = 16384;
    public static final int DEFAULT_LARGE_BUFFER_SIZE = 32768;
    public static final int EOF = -1;

    public static long copy(Reader reader, Writer writer) {
        return IoUtil.copy(reader, writer, 8192);
    }

    public static long copy(Reader reader, Writer writer, int n2) {
        return IoUtil.copy(reader, writer, n2, null);
    }

    public static long copy(Reader reader, Writer writer, int n2, StreamProgress streamProgress) {
        char[] cArray = new char[n2];
        long l2 = 0L;
        if (null != streamProgress) {
            streamProgress.start();
        }
        try {
            int n3;
            while ((n3 = reader.read(cArray, 0, n2)) != -1) {
                writer.write(cArray, 0, n3);
                l2 += (long)n3;
                writer.flush();
                if (null == streamProgress) continue;
                streamProgress.progress(l2);
            }
        }
        catch (Exception exception) {
            throw new IORuntimeException(exception);
        }
        if (null != streamProgress) {
            streamProgress.finish();
        }
        return l2;
    }

    public static long copy(InputStream inputStream, OutputStream outputStream) {
        return IoUtil.copy(inputStream, outputStream, 8192);
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, int n2) {
        return IoUtil.copy(inputStream, outputStream, n2, null);
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, int n2, StreamProgress streamProgress) {
        Assert.notNull(inputStream, "InputStream is null !", new Object[0]);
        Assert.notNull(outputStream, "OutputStream is null !", new Object[0]);
        if (n2 <= 0) {
            n2 = 8192;
        }
        byte[] byArray = new byte[n2];
        if (null != streamProgress) {
            streamProgress.start();
        }
        long l2 = 0L;
        try {
            int n3;
            while ((n3 = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n3);
                l2 += (long)n3;
                outputStream.flush();
                if (null == streamProgress) continue;
                streamProgress.progress(l2);
            }
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
        if (null != streamProgress) {
            streamProgress.finish();
        }
        return l2;
    }

    public static long copyByNIO(InputStream inputStream, OutputStream outputStream, int n2, StreamProgress streamProgress) {
        return IoUtil.copy(Channels.newChannel(inputStream), Channels.newChannel(outputStream), n2, streamProgress);
    }

    public static long copy(FileInputStream fileInputStream, FileOutputStream fileOutputStream) {
        long l2;
        Assert.notNull(fileInputStream, "FileInputStream is null!", new Object[0]);
        Assert.notNull(fileOutputStream, "FileOutputStream is null!", new Object[0]);
        FileChannel fileChannel = null;
        FileChannel fileChannel2 = null;
        try {
            fileChannel = fileInputStream.getChannel();
            fileChannel2 = fileOutputStream.getChannel();
            l2 = fileChannel.transferTo(0L, fileChannel.size(), fileChannel2);
        }
        catch (IOException iOException) {
            try {
                throw new IORuntimeException(iOException);
            }
            catch (Throwable throwable) {
                IoUtil.close(fileChannel2);
                IoUtil.close(fileChannel);
                throw throwable;
            }
        }
        IoUtil.close(fileChannel2);
        IoUtil.close(fileChannel);
        return l2;
    }

    public static long copy(ReadableByteChannel readableByteChannel, WritableByteChannel writableByteChannel) {
        return IoUtil.copy(readableByteChannel, writableByteChannel, 8192);
    }

    public static long copy(ReadableByteChannel readableByteChannel, WritableByteChannel writableByteChannel, int n2) {
        return IoUtil.copy(readableByteChannel, writableByteChannel, n2, null);
    }

    public static long copy(ReadableByteChannel readableByteChannel, WritableByteChannel writableByteChannel, int n2, StreamProgress streamProgress) {
        Assert.notNull(readableByteChannel, "InputStream is null !", new Object[0]);
        Assert.notNull(writableByteChannel, "OutputStream is null !", new Object[0]);
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2 <= 0 ? 8192 : n2);
        long l2 = 0L;
        if (null != streamProgress) {
            streamProgress.start();
        }
        try {
            while (readableByteChannel.read(byteBuffer) != -1) {
                byteBuffer.flip();
                l2 += (long)writableByteChannel.write(byteBuffer);
                byteBuffer.clear();
                if (null == streamProgress) continue;
                streamProgress.progress(l2);
            }
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
        if (null != streamProgress) {
            streamProgress.finish();
        }
        return l2;
    }

    public static BufferedReader getUtf8Reader(InputStream inputStream) {
        return IoUtil.getReader(inputStream, CharsetUtil.CHARSET_UTF_8);
    }

    public static BufferedReader getReader(InputStream inputStream, String string) {
        return IoUtil.getReader(inputStream, Charset.forName(string));
    }

    public static BufferedReader getReader(InputStream inputStream, Charset charset) {
        if (null == inputStream) {
            return null;
        }
        InputStreamReader inputStreamReader = null == charset ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, charset);
        return new BufferedReader(inputStreamReader);
    }

    public static BufferedReader getReader(Reader reader) {
        if (null == reader) {
            return null;
        }
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static PushbackReader getPushBackReader(Reader reader, int n2) {
        return reader instanceof PushbackReader ? (PushbackReader)reader : new PushbackReader(reader, n2);
    }

    public static OutputStreamWriter getUtf8Writer(OutputStream outputStream) {
        return IoUtil.getWriter(outputStream, CharsetUtil.CHARSET_UTF_8);
    }

    public static OutputStreamWriter getWriter(OutputStream outputStream, String string) {
        return IoUtil.getWriter(outputStream, Charset.forName(string));
    }

    public static OutputStreamWriter getWriter(OutputStream outputStream, Charset charset) {
        if (null == outputStream) {
            return null;
        }
        if (null == charset) {
            return new OutputStreamWriter(outputStream);
        }
        return new OutputStreamWriter(outputStream, charset);
    }

    public static String readUtf8(InputStream inputStream) {
        return IoUtil.read(inputStream, CharsetUtil.CHARSET_UTF_8);
    }

    public static String read(InputStream inputStream, String string) {
        FastByteArrayOutputStream fastByteArrayOutputStream = IoUtil.read(inputStream);
        return StrUtil.isBlank(string) ? fastByteArrayOutputStream.toString() : fastByteArrayOutputStream.toString(string);
    }

    public static String read(InputStream inputStream, Charset charset) {
        FastByteArrayOutputStream fastByteArrayOutputStream = IoUtil.read(inputStream);
        return null == charset ? fastByteArrayOutputStream.toString() : fastByteArrayOutputStream.toString(charset);
    }

    public static String read(ReadableByteChannel readableByteChannel, Charset charset) {
        FastByteArrayOutputStream fastByteArrayOutputStream = IoUtil.read(readableByteChannel);
        return null == charset ? fastByteArrayOutputStream.toString() : fastByteArrayOutputStream.toString(charset);
    }

    public static FastByteArrayOutputStream read(InputStream inputStream) {
        FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream();
        IoUtil.copy(inputStream, fastByteArrayOutputStream);
        return fastByteArrayOutputStream;
    }

    public static FastByteArrayOutputStream read(ReadableByteChannel readableByteChannel) {
        FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream();
        IoUtil.copy(readableByteChannel, Channels.newChannel(fastByteArrayOutputStream));
        return fastByteArrayOutputStream;
    }

    public static String read(Reader reader) {
        StringBuilder stringBuilder = StrUtil.builder();
        CharBuffer charBuffer = CharBuffer.allocate(8192);
        try {
            while (-1 != reader.read(charBuffer)) {
                stringBuilder.append(charBuffer.flip().toString());
            }
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
        return stringBuilder.toString();
    }

    public static String readUtf8(FileChannel fileChannel) {
        return IoUtil.read(fileChannel, CharsetUtil.CHARSET_UTF_8);
    }

    public static String read(FileChannel fileChannel, String string) {
        return IoUtil.read(fileChannel, CharsetUtil.charset(string));
    }

    public static String read(FileChannel fileChannel, Charset charset) {
        MappedByteBuffer mappedByteBuffer;
        try {
            mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size()).load();
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
        return StrUtil.str((ByteBuffer)mappedByteBuffer, charset);
    }

    public static byte[] readBytes(InputStream inputStream) {
        return IoUtil.readBytes(inputStream, true);
    }

    public static byte[] readBytes(InputStream inputStream, boolean bl) {
        FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream();
        IoUtil.copy(inputStream, fastByteArrayOutputStream);
        if (bl) {
            IoUtil.close(inputStream);
        }
        return fastByteArrayOutputStream.toByteArray();
    }

    public static byte[] readBytes(InputStream inputStream, int n2) {
        int n3;
        if (null == inputStream) {
            return null;
        }
        if (n2 <= 0) {
            return new byte[0];
        }
        byte[] byArray = new byte[n2];
        try {
            n3 = inputStream.read(byArray);
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
        if (n3 > 0 && n3 < n2) {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, 0, byArray2, 0, n3);
            return byArray2;
        }
        return byArray;
    }

    public static String readHex(InputStream inputStream, int n2, boolean bl) {
        return HexUtil.encodeHexStr(IoUtil.readBytes(inputStream, n2), bl);
    }

    public static String readHex28Upper(InputStream inputStream) {
        return IoUtil.readHex(inputStream, 28, false);
    }

    public static String readHex28Lower(InputStream inputStream) {
        return IoUtil.readHex(inputStream, 28, true);
    }

    public static Object readObj(InputStream inputStream) {
        return IoUtil.readObj(inputStream, null);
    }

    public static Object readObj(InputStream inputStream, Class clazz) {
        try {
            return IoUtil.readObj(inputStream instanceof ValidateObjectInputStream ? (ValidateObjectInputStream)inputStream : new ValidateObjectInputStream(inputStream, new Class[0]), clazz);
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    public static Object readObj(ValidateObjectInputStream validateObjectInputStream, Class clazz) {
        if (validateObjectInputStream == null) {
            throw new IllegalArgumentException("The InputStream must not be null");
        }
        try {
            return validateObjectInputStream.readObject();
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UtilException(classNotFoundException);
        }
    }

    public static Collection readUtf8Lines(InputStream inputStream, Collection collection) {
        return IoUtil.readLines(inputStream, CharsetUtil.CHARSET_UTF_8, collection);
    }

    public static Collection readLines(InputStream inputStream, String string, Collection collection) {
        return IoUtil.readLines(inputStream, CharsetUtil.charset(string), collection);
    }

    public static Collection readLines(InputStream inputStream, Charset charset, Collection collection) {
        return IoUtil.readLines((Reader)IoUtil.getReader(inputStream, charset), collection);
    }

    public static Collection readLines(Reader reader, Collection collection) {
        IoUtil.readLines(reader, collection::add);
        return collection;
    }

    public static void readUtf8Lines(InputStream inputStream, LineHandler lineHandler) {
        IoUtil.readLines(inputStream, CharsetUtil.CHARSET_UTF_8, lineHandler);
    }

    public static void readLines(InputStream inputStream, Charset charset, LineHandler lineHandler) {
        IoUtil.readLines((Reader)IoUtil.getReader(inputStream, charset), lineHandler);
    }

    public static void readLines(Reader reader, LineHandler lineHandler) {
        Assert.notNull(reader);
        Assert.notNull(lineHandler);
        BufferedReader bufferedReader = IoUtil.getReader(reader);
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                lineHandler.handle(string);
            }
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    public static ByteArrayInputStream toStream(String string, String string2) {
        return IoUtil.toStream(string, CharsetUtil.charset(string2));
    }

    public static ByteArrayInputStream toStream(String string, Charset charset) {
        if (string == null) {
            return null;
        }
        return IoUtil.toStream(StrUtil.bytes((CharSequence)string, charset));
    }

    public static ByteArrayInputStream toUtf8Stream(String string) {
        return IoUtil.toStream(string, CharsetUtil.CHARSET_UTF_8);
    }

    public static FileInputStream toStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IORuntimeException(fileNotFoundException);
        }
    }

    public static ByteArrayInputStream toStream(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        return new ByteArrayInputStream(byArray);
    }

    public static BufferedInputStream toBuffered(InputStream inputStream) {
        return inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
    }

    public static BufferedOutputStream toBuffered(OutputStream outputStream) {
        return outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream);
    }

    public static InputStream toMarkSupportStream(InputStream inputStream) {
        if (null == inputStream) {
            return null;
        }
        if (!inputStream.markSupported()) {
            return new BufferedInputStream(inputStream);
        }
        return inputStream;
    }

    public static PushbackInputStream toPushbackStream(InputStream inputStream, int n2) {
        return inputStream instanceof PushbackInputStream ? (PushbackInputStream)inputStream : new PushbackInputStream(inputStream, n2);
    }

    public static void write(OutputStream outputStream, boolean bl, byte[] byArray) {
        try {
            outputStream.write(byArray);
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
        finally {
            if (bl) {
                IoUtil.close(outputStream);
            }
        }
    }

    public static void writeUtf8(OutputStream outputStream, boolean bl, Object ... objectArray) {
        IoUtil.write(outputStream, CharsetUtil.CHARSET_UTF_8, bl, objectArray);
    }

    public static void write(OutputStream outputStream, String string, boolean bl, Object ... objectArray) {
        IoUtil.write(outputStream, CharsetUtil.charset(string), bl, objectArray);
    }

    public static void write(OutputStream outputStream, Charset charset, boolean bl, Object ... objectArray) {
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = IoUtil.getWriter(outputStream, charset);
            for (Object object : objectArray) {
                if (object == null) continue;
                outputStreamWriter.write(Convert.toStr(object, ""));
            }
            outputStreamWriter.flush();
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
        finally {
            if (bl) {
                IoUtil.close(outputStreamWriter);
            }
        }
    }

    public static void writeObj(OutputStream outputStream, boolean bl, Serializable serializable) {
        IoUtil.writeObjects(outputStream, bl, serializable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeObjects(OutputStream outputStream, boolean bl, Serializable ... serializableArray) {
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = outputStream instanceof ObjectOutputStream ? (ObjectOutputStream)outputStream : new ObjectOutputStream(outputStream);
            for (Serializable serializable : serializableArray) {
                if (serializable == null) continue;
                objectOutputStream.writeObject(serializable);
                objectOutputStream.flush();
            }
            if (!bl) return;
        }
        catch (IOException iOException) {
            try {
                throw new IORuntimeException(iOException);
            }
            catch (Throwable throwable) {
                if (!bl) throw throwable;
                IoUtil.close(objectOutputStream);
                throw throwable;
            }
        }
        IoUtil.close(objectOutputStream);
        return;
    }

    public static void flush(Flushable flushable) {
        if (null != flushable) {
            try {
                flushable.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(AutoCloseable autoCloseable) {
        if (null != autoCloseable) {
            try {
                autoCloseable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void closeIfPosible(Object object) {
        if (object instanceof AutoCloseable) {
            IoUtil.close((AutoCloseable)object);
        }
    }

    public static boolean contentEquals(InputStream inputStream, InputStream inputStream2) {
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        if (!(inputStream2 instanceof BufferedInputStream)) {
            inputStream2 = new BufferedInputStream(inputStream2);
        }
        try {
            int n2;
            int n3 = inputStream.read();
            while (-1 != n3) {
                n2 = inputStream2.read();
                if (n3 != n2) {
                    return false;
                }
                n3 = inputStream.read();
            }
            n2 = inputStream2.read();
            return n2 == -1;
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    public static boolean contentEquals(Reader reader, Reader reader2) {
        reader = IoUtil.getReader(reader);
        reader2 = IoUtil.getReader(reader2);
        try {
            int n2;
            int n3 = reader.read();
            while (-1 != n3) {
                n2 = reader2.read();
                if (n3 != n2) {
                    return false;
                }
                n3 = reader.read();
            }
            n2 = reader2.read();
            return n2 == -1;
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    public static boolean contentEqualsIgnoreEOL(Reader reader, Reader reader2) {
        BufferedReader bufferedReader = IoUtil.getReader(reader);
        BufferedReader bufferedReader2 = IoUtil.getReader(reader2);
        try {
            String string = bufferedReader.readLine();
            String string2 = bufferedReader2.readLine();
            while (string != null && string.equals(string2)) {
                string = bufferedReader.readLine();
                string2 = bufferedReader2.readLine();
            }
            return Objects.equals(string, string2);
        }
        catch (IOException iOException) {
            throw new IORuntimeException(iOException);
        }
    }

    public static long checksumCRC32(InputStream inputStream) {
        return IoUtil.checksum(inputStream, new CRC32()).getValue();
    }

    public static Checksum checksum(InputStream inputStream, Checksum checksum) {
        Assert.notNull(inputStream, "InputStream is null !", new Object[0]);
        if (null == checksum) {
            checksum = new CRC32();
        }
        try {
            inputStream = new CheckedInputStream(inputStream, checksum);
            IoUtil.copy(inputStream, new NullOutputStream());
        }
        finally {
            IoUtil.close(inputStream);
        }
        return checksum;
    }

    public static long checksumValue(InputStream inputStream, Checksum checksum) {
        return IoUtil.checksum(inputStream, checksum).getValue();
    }
}

