/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.io;

public class FastByteBuffer {
    private byte[][] buffers = new byte[16][];
    private int buffersCount;
    private int currentBufferIndex = -1;
    private byte[] currentBuffer;
    private int offset;
    private int size;
    private final int minChunkLen;

    public FastByteBuffer() {
        this.minChunkLen = 1024;
    }

    public FastByteBuffer(int n2) {
        this.minChunkLen = Math.abs(n2);
    }

    private void needNewBuffer(int n2) {
        int n3 = n2 - this.size;
        int n4 = Math.max(this.minChunkLen, n3);
        ++this.currentBufferIndex;
        this.currentBuffer = new byte[n4];
        this.offset = 0;
        if (this.currentBufferIndex >= this.buffers.length) {
            int n5 = this.buffers.length << 1;
            byte[][] byArrayArray = new byte[n5][];
            System.arraycopy(this.buffers, 0, byArrayArray, 0, this.buffers.length);
            this.buffers = byArrayArray;
        }
        this.buffers[this.currentBufferIndex] = this.currentBuffer;
        ++this.buffersCount;
    }

    public FastByteBuffer append(byte[] byArray, int n2, int n3) {
        int n4;
        int n5 = n2 + n3;
        if (n2 < 0 || n3 < 0 || n5 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return this;
        }
        int n6 = this.size + n3;
        int n7 = n3;
        if (this.currentBuffer != null) {
            n4 = Math.min(n7, this.currentBuffer.length - this.offset);
            System.arraycopy(byArray, n5 - n7, this.currentBuffer, this.offset, n4);
            n7 -= n4;
            this.offset += n4;
            this.size += n4;
        }
        if (n7 > 0) {
            this.needNewBuffer(n6);
            n4 = Math.min(n7, this.currentBuffer.length - this.offset);
            System.arraycopy(byArray, n5 - n7, this.currentBuffer, this.offset, n4);
            this.offset += n4;
            this.size += n4;
        }
        return this;
    }

    public FastByteBuffer append(byte[] byArray) {
        return this.append(byArray, 0, byArray.length);
    }

    public FastByteBuffer append(byte by) {
        if (this.currentBuffer == null || this.offset == this.currentBuffer.length) {
            this.needNewBuffer(this.size + 1);
        }
        this.currentBuffer[this.offset] = by;
        ++this.offset;
        ++this.size;
        return this;
    }

    public FastByteBuffer append(FastByteBuffer fastByteBuffer) {
        if (fastByteBuffer.size == 0) {
            return this;
        }
        for (int i2 = 0; i2 < fastByteBuffer.currentBufferIndex; ++i2) {
            this.append(fastByteBuffer.buffers[i2]);
        }
        this.append(fastByteBuffer.currentBuffer, 0, fastByteBuffer.offset);
        return this;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int index() {
        return this.currentBufferIndex;
    }

    public int offset() {
        return this.offset;
    }

    public byte[] array(int n2) {
        return this.buffers[n2];
    }

    public void reset() {
        this.size = 0;
        this.offset = 0;
        this.currentBufferIndex = -1;
        this.currentBuffer = null;
        this.buffersCount = 0;
    }

    public byte[] toArray() {
        int n2 = 0;
        byte[] byArray = new byte[this.size];
        if (this.currentBufferIndex == -1) {
            return byArray;
        }
        for (int i2 = 0; i2 < this.currentBufferIndex; ++i2) {
            int n3 = this.buffers[i2].length;
            System.arraycopy(this.buffers[i2], 0, byArray, n2, n3);
            n2 += n3;
        }
        System.arraycopy(this.buffers[this.currentBufferIndex], 0, byArray, n2, this.offset);
        return byArray;
    }

    public byte[] toArray(int n2, int n3) {
        int n4 = n3;
        int n5 = 0;
        byte[] byArray = new byte[n3];
        if (n3 == 0) {
            return byArray;
        }
        int n6 = 0;
        while (n2 >= this.buffers[n6].length) {
            n2 -= this.buffers[n6].length;
            ++n6;
        }
        while (n6 < this.buffersCount) {
            byte[] byArray2 = this.buffers[n6];
            int n7 = Math.min(byArray2.length - n2, n4);
            System.arraycopy(byArray2, n2, byArray, n5, n7);
            n5 += n7;
            if ((n4 -= n7) == 0) break;
            n2 = 0;
            ++n6;
        }
        return byArray;
    }

    public byte get(int n2) {
        if (n2 >= this.size || n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = 0;
        byte[] byArray;
        while (n2 >= (byArray = this.buffers[n3]).length) {
            ++n3;
            n2 -= byArray.length;
        }
        return byArray[n2];
    }
}

