/*
 * Decompiled with CFR 0.152.
 */
package com.ccb.core.io;

import com.ccb.core.util.CharsetUtil;
import com.ccb.core.util.StrUtil;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class BufferUtil {
    public static ByteBuffer copy(ByteBuffer byteBuffer, int n2, int n3) {
        return BufferUtil.copy(byteBuffer, ByteBuffer.allocate(n3 - n2));
    }

    public static ByteBuffer copy(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        return BufferUtil.copy(byteBuffer, byteBuffer2, Math.min(byteBuffer.limit(), byteBuffer2.remaining()));
    }

    public static ByteBuffer copy(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n2) {
        return BufferUtil.copy(byteBuffer, byteBuffer.position(), byteBuffer2, byteBuffer2.position(), n2);
    }

    public static ByteBuffer copy(ByteBuffer byteBuffer, int n2, ByteBuffer byteBuffer2, int n3, int n4) {
        System.arraycopy(byteBuffer.array(), n2, byteBuffer2.array(), n3, n4);
        return byteBuffer2;
    }

    public static String readUtf8Str(ByteBuffer byteBuffer) {
        return BufferUtil.readStr(byteBuffer, CharsetUtil.CHARSET_UTF_8);
    }

    public static String readStr(ByteBuffer byteBuffer, Charset charset) {
        return StrUtil.str(BufferUtil.readBytes(byteBuffer), charset);
    }

    public static byte[] readBytes(ByteBuffer byteBuffer) {
        int n2 = byteBuffer.remaining();
        byte[] byArray = new byte[n2];
        byteBuffer.get(byArray);
        return byArray;
    }

    public static byte[] readBytes(ByteBuffer byteBuffer, int n2) {
        int n3 = byteBuffer.remaining();
        if (n2 > n3) {
            n2 = n3;
        }
        byte[] byArray = new byte[n2];
        byteBuffer.get(byArray);
        return byArray;
    }

    public static byte[] readBytes(ByteBuffer byteBuffer, int n2, int n3) {
        byte[] byArray = new byte[n3 - n2];
        System.arraycopy(byteBuffer.array(), n2, byArray, 0, byArray.length);
        return byArray;
    }

    public static int lineEnd(ByteBuffer byteBuffer) {
        return BufferUtil.lineEnd(byteBuffer, byteBuffer.remaining());
    }

    public static int lineEnd(ByteBuffer byteBuffer, int n2) {
        int n3 = byteBuffer.position();
        boolean bl = false;
        int n4 = n3;
        while (byteBuffer.hasRemaining()) {
            byte by = byteBuffer.get();
            ++n4;
            if (by == 13) {
                bl = true;
            } else {
                if (by == 10) {
                    return bl ? n4 - 2 : n4 - 1;
                }
                bl = false;
            }
            if (n4 - n3 <= n2) continue;
            byteBuffer.position(n3);
            throw new IndexOutOfBoundsException(StrUtil.format((CharSequence)"Position is out of maxLength: {}", n2));
        }
        byteBuffer.position(n3);
        return -1;
    }

    public static String readLine(ByteBuffer byteBuffer, Charset charset) {
        int n2 = byteBuffer.position();
        int n3 = BufferUtil.lineEnd(byteBuffer);
        if (n3 > n2) {
            byte[] byArray = BufferUtil.readBytes(byteBuffer, n2, n3);
            return StrUtil.str(byArray, charset);
        }
        if (n3 == n2) {
            return "";
        }
        return null;
    }

    public static ByteBuffer create(byte[] byArray) {
        return ByteBuffer.wrap(byArray);
    }

    public static ByteBuffer create(CharSequence charSequence, Charset charset) {
        return BufferUtil.create(StrUtil.bytes(charSequence, charset));
    }

    public static ByteBuffer createUtf8(CharSequence charSequence) {
        return BufferUtil.create(StrUtil.utf8Bytes(charSequence));
    }
}

